/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tizen.nativecommon.build.CommonConfigurationManager;

public class TizenUIThreadForConfirmMessage
implements Runnable {
    private boolean result = false;
    private IProject project;
    private IConfiguration problematicConfig;
    private String suitableConfigName;
    private String arch;

    public TizenUIThreadForConfirmMessage(IProject project, IConfiguration problematicConfig, String arch, String mode) {
        this.project = project;
        this.problematicConfig = problematicConfig;
        this.arch = arch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TizenUIThreadForConfirmMessage tizenUIThreadForConfirmMessage = this;
        synchronized (tizenUIThreadForConfirmMessage) {
            IConfiguration[] configurations;
            IConfiguration[] iConfigurationArray = configurations = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                String configArch = CommonConfigurationManager.getArchitecture(config);
                if (configArch != null && configArch.equals(this.arch) && !config.getName().equals("Release")) {
                    this.suitableConfigName = config.getName();
                    String message = String.format("Configuration should be changed to match device type%nDo you want to change configuration \"%s\" to \"%s\" ?", this.problematicConfig.getName(), this.suitableConfigName);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    this.result = MessageDialog.openQuestion((Shell)shell, (String)"Question", (String)message);
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSuitableConfigName() {
        TizenUIThreadForConfirmMessage tizenUIThreadForConfirmMessage = this;
        synchronized (tizenUIThreadForConfirmMessage) {
            return this.suitableConfigName;
        }
    }
}

