/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DataControl {
    private String providerid;
    private String access;
    private String type;
    private String trusted;
    public static final String ELEMENT = "datacontrol";
    public static final String ATTR_PROVIDER_ID = "providerid";
    public static final String ATTR_ACCESS = "access";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TRUSTED = "trusted";
    public static final String SQL_TYPE = "Sql";
    public static final String MAP_TYPE = "Map";
    public static final String Access_READ_ONLY = "ReadOnly";
    public static final String Access_WRITE_ONLY = "WriteOnly";
    public static final String Access_READ_WRITE_BOTH = "ReadWrite";
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<Privilege> privilegeList = new ArrayList<Privilege>();

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setProviderid(element.getAttribute(ATTR_PROVIDER_ID));
        this.setAccess(element.getAttribute(ATTR_ACCESS));
        this.setType(element.getAttribute(ATTR_TYPE));
        this.setTrusted(element.getAttribute(ATTR_TRUSTED));
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("privilege")) {
                Privilege privilege = new Privilege();
                privilege.loadElement((Element)node);
                this.getPrivilegeList().add(privilege);
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        if (this.providerid != null && this.providerid.length() > 0) {
            element.setAttribute(ATTR_PROVIDER_ID, this.providerid);
        }
        if (this.access != null && this.access.length() > 0) {
            element.setAttribute(ATTR_ACCESS, this.access);
        }
        if (this.type != null && this.type.length() > 0) {
            element.setAttribute(ATTR_TYPE, this.type);
        }
        if (this.trusted != null && this.trusted.length() > 0) {
            element.setAttribute(ATTR_TRUSTED, this.trusted);
        }
        for (Privilege privilege : this.getPrivilegeList()) {
            privilege.generateElement(dom, element, privilege.getLevel());
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
        parent.appendChild(element);
    }

    public String getProviderid() {
        return this.providerid;
    }

    public String getAccess() {
        return this.access;
    }

    public String getType() {
        return this.type;
    }

    public void setProviderid(String providerid) {
        this.providerid = providerid;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTrusted() {
        return this.trusted;
    }

    public void setTrusted(String trusted) {
        this.trusted = trusted;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_ACCESS)) {
            return false;
        }
        if (attr.equals(ATTR_PROVIDER_ID)) {
            return false;
        }
        if (attr.equals(ATTR_TYPE)) {
            return false;
        }
        return !attr.equals(ATTR_TRUSTED);
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    public List<Privilege> getPrivilegeList() {
        return this.privilegeList;
    }
}

