/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.BuildGroup;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.cview.GotoActionGroup;
import org.eclipse.cdt.internal.ui.cview.OpenFileGroup;
import org.eclipse.cdt.internal.ui.cview.OpenProjectGroup;
import org.eclipse.cdt.internal.ui.cview.RefactorActionGroup;
import org.eclipse.cdt.internal.ui.cview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.ide.IDEActionFactory;

public class MainActionGroup
extends CViewActionGroup {
    AddBookmarkAction addBookmarkAction;
    AddTaskAction addTaskAction;
    ImportResourcesAction importAction;
    ExportResourcesAction exportAction;
    OpenIncludeAction openIncludeAction;
    CollapseAllAction collapseAllAction;
    ToggleLinkingAction toggleLinkingAction;
    BuildGroup buildGroup;
    OpenFileGroup openFileGroup;
    GotoActionGroup gotoGroup;
    RefactorActionGroup refactorGroup;
    OpenProjectGroup openProjectGroup;
    WorkingSetFilterActionGroup workingSetGroup;
    CustomFiltersActionGroup fCustomFiltersActionGroup;
    SelectionSearchGroup selectionSearchGroup;
    OpenViewActionGroup openViewActionGroup;
    CRefactoringActionGroup crefactoringActionGroup;
    private NewWizardMenu newWizardMenu;

    public MainActionGroup(CView cview) {
        super(cview);
    }

    @Override
    public void handleKeyPressed(KeyEvent event) {
        this.refactorGroup.handleKeyPressed(event);
        this.openFileGroup.handleKeyPressed(event);
        this.openProjectGroup.handleKeyPressed(event);
        this.gotoGroup.handleKeyPressed(event);
        this.buildGroup.handleKeyPressed(event);
    }

    @Override
    public void handleKeyReleased(KeyEvent event) {
        this.refactorGroup.handleKeyReleased(event);
        this.openFileGroup.handleKeyReleased(event);
        this.openProjectGroup.handleKeyReleased(event);
        this.gotoGroup.handleKeyReleased(event);
        this.buildGroup.handleKeyReleased(event);
    }

    @Override
    protected void makeActions() {
        TreeViewer viewer = this.getCView().getViewer();
        IViewSite shellProvider = this.getCView().getViewSite();
        Shell shell = shellProvider.getShell();
        this.openFileGroup = new OpenFileGroup(this.getCView());
        this.openProjectGroup = new OpenProjectGroup(this.getCView());
        this.gotoGroup = new GotoActionGroup(this.getCView());
        this.buildGroup = new BuildGroup(this.getCView());
        this.refactorGroup = new RefactorActionGroup(this.getCView());
        this.newWizardMenu = new NewWizardMenu(this.getCView().getSite().getWorkbenchWindow());
        this.openIncludeAction = new OpenIncludeAction((ISelectionProvider)viewer);
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        MainActionGroup.this.getCView().setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        MainActionGroup.this.getCView().setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, workingSetUpdater);
        this.workingSetGroup.setWorkingSet(this.getCView().getWorkingSet());
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.getCView(), (StructuredViewer)this.getCView().getViewer());
        this.addBookmarkAction = new AddBookmarkAction((IShellProvider)shellProvider, true);
        this.addTaskAction = new AddTaskAction((IShellProvider)shellProvider);
        this.importAction = new ImportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.exportAction = new ExportResourcesAction(this.getCView().getSite().getWorkbenchWindow());
        this.collapseAllAction = new CollapseAllAction(this.getCView().getViewer());
        this.toggleLinkingAction = new ToggleLinkingAction(this.getCView());
        this.selectionSearchGroup = new SelectionSearchGroup((IWorkbenchSite)this.getCView().getSite());
        this.openViewActionGroup = new OpenViewActionGroup((IWorkbenchPart)this.getCView());
        this.crefactoringActionGroup = new CRefactoringActionGroup((IWorkbenchPart)this.getCView());
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection celements = (IStructuredSelection)this.getCView().getViewer().getSelection();
        IStructuredSelection resources = SelectionConverter.convertSelectionToResources((ISelection)celements);
        this.addNewMenu(menu, resources);
        if (resources.isEmpty()) {
            menu.add((IContributionItem)new Separator("group.goto"));
            menu.add((IContributionItem)new Separator("group.open"));
            menu.add((IContributionItem)new Separator("group.build"));
            menu.add((IContributionItem)new Separator("group.reorganize"));
            menu.add((IContributionItem)new Separator("group.private1"));
            this.importAction.selectionChanged(resources);
            menu.add((IAction)this.importAction);
            this.exportAction.selectionChanged(resources);
            menu.add((IAction)this.exportAction);
            menu.add((IContributionItem)new Separator("group.private2"));
            menu.add((IContributionItem)new Separator("group.search"));
            this.addSearchMenu(menu, celements);
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IContributionItem)new Separator("additions-end"));
            menu.add((IContributionItem)new Separator("group.properties"));
            this.openViewActionGroup.fillContextMenu(menu);
            this.crefactoringActionGroup.fillContextMenu(menu);
            if (OpenIncludeAction.canActionBeAdded((ISelection)celements)) {
                menu.appendToGroup("group.open", (IAction)this.openIncludeAction);
            }
            return;
        }
        menu.add((IContributionItem)new Separator("group.goto"));
        this.gotoGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator("group.open"));
        this.openFileGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator("group.build"));
        this.buildGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator("group.reorganize"));
        this.refactorGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator("group.private1"));
        this.importAction.selectionChanged(resources);
        menu.add((IAction)this.importAction);
        this.exportAction.selectionChanged(resources);
        menu.add((IAction)this.exportAction);
        menu.add((IContributionItem)new Separator("group.private2"));
        this.openProjectGroup.fillContextMenu(menu);
        this.addBookMarkMenu(menu, resources);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        menu.add((IContributionItem)new Separator("group.properties"));
        this.openViewActionGroup.fillContextMenu(menu);
        this.crefactoringActionGroup.fillContextMenu(menu);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.gotoGroup.setContext(context);
        this.openFileGroup.setContext(context);
        this.openProjectGroup.setContext(context);
        this.refactorGroup.setContext(context);
        this.buildGroup.setContext(context);
        this.openViewActionGroup.setContext(context);
        this.crefactoringActionGroup.setContext(context);
    }

    void addNewMenu(IMenuManager menu, IStructuredSelection selection) {
        MenuManager newMenu = new MenuManager(CViewMessages.NewWizardsActionGroup_new);
        menu.add((IContributionItem)newMenu);
        newMenu.add((IContributionItem)this.newWizardMenu);
    }

    void addBookMarkMenu(IMenuManager menu, IStructuredSelection selection) {
        IAdaptable element;
        IResource resource;
        Object obj = selection.getFirstElement();
        if (obj instanceof IAdaptable && (resource = (IResource)(element = (IAdaptable)obj).getAdapter(IResource.class)) instanceof IFile) {
            this.addBookmarkAction.selectionChanged(selection);
            menu.add((IAction)this.addBookmarkAction);
        }
    }

    void addSearchMenu(IMenuManager menu, IStructuredSelection selection) {
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        if (element instanceof ITranslationUnit || element instanceof ICProject) {
            return;
        }
        if (SelectionSearchGroup.canActionBeAdded((ISelection)selection)) {
            this.selectionSearchGroup.fillContextMenu(menu);
        }
    }

    @Override
    public void runDefaultAction(IStructuredSelection selection) {
        this.openFileGroup.runDefaultAction(selection);
        this.openProjectGroup.runDefaultAction(selection);
        this.gotoGroup.runDefaultAction(selection);
        this.buildGroup.runDefaultAction(selection);
        this.refactorGroup.runDefaultAction(selection);
    }

    @Override
    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.addBookmarkAction.selectionChanged(selection);
        this.addTaskAction.selectionChanged(selection);
        this.openFileGroup.updateActionBars();
        this.openProjectGroup.updateActionBars();
        this.gotoGroup.updateActionBars();
        this.buildGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workingSetGroup.updateActionBars();
        this.fCustomFiltersActionGroup.updateActionBars();
        this.openViewActionGroup.updateActionBars();
        this.crefactoringActionGroup.updateActionBars();
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        this.workingSetGroup.fillActionBars(actionBars);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        this.gotoGroup.fillActionBars(actionBars);
        this.refactorGroup.fillActionBars(actionBars);
        this.openFileGroup.fillActionBars(actionBars);
        this.openProjectGroup.fillActionBars(actionBars);
        this.buildGroup.fillActionBars(actionBars);
        this.openViewActionGroup.fillActionBars(actionBars);
        this.crefactoringActionGroup.fillActionBars(actionBars);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.toggleLinkingAction);
    }

    @Override
    public void restoreFilterAndSorterState(IMemento memento) {
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    @Override
    public void saveFilterAndSorterState(IMemento memento) {
        this.fCustomFiltersActionGroup.saveState(memento);
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }

    public void dispose() {
        this.importAction.dispose();
        this.exportAction.dispose();
        this.refactorGroup.dispose();
        this.openFileGroup.dispose();
        this.openProjectGroup.dispose();
        this.gotoGroup.dispose();
        this.buildGroup.dispose();
        this.newWizardMenu.dispose();
        this.openViewActionGroup.dispose();
        this.crefactoringActionGroup.dispose();
        super.dispose();
    }
}

