/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.EditorHighlightingSynchronizer;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.FunctionCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.ParameterGuesser;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class ParameterGuessingProposal
extends FunctionCompletionProposal {
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;
    private String fFullPrefix;
    private CEditor fCEditor;
    private char[][] fParametersNames;
    private IType[] fParametersTypes;
    private List<IBinding> fAssignableElements;

    public static ParameterGuessingProposal createProposal(CContentAssistInvocationContext context, List<IBinding> availableElements, CCompletionProposal proposal, IFunction function, String prefix) {
        String replacement = ParameterGuessingProposal.getParametersList(function);
        String fullPrefix = String.valueOf(function.getName()) + "(";
        int replacementOffset = proposal.getReplacementOffset();
        int replacementLength = 0;
        int invocationOffset = context.getInvocationOffset();
        int parseOffset = context.getParseOffset();
        IDocument document = context.getDocument();
        if (ParameterGuessingProposal.isInsideBracket(invocationOffset, parseOffset)) {
            replacementOffset = parseOffset - prefix.length();
            try {
                fullPrefix = document.get(replacementOffset, invocationOffset - replacementOffset);
                replacement = String.valueOf(fullPrefix) + replacement + ")";
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            try {
                if (document.getChar(invocationOffset) == ')') {
                    replacement = replacement.substring(0, replacement.length() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            replacement = String.valueOf(fullPrefix) + replacement + ")";
            replacementOffset = proposal.getReplacementOffset();
        }
        replacementLength = prefix.length();
        ParameterGuessingProposal ret = new ParameterGuessingProposal(replacement, replacementOffset, replacementLength, proposal.getImage(), proposal.getDisplayString(), proposal.getIdString(), proposal.getRelevance(), context.getViewer(), function, invocationOffset, parseOffset, context.getTranslationUnit(), document);
        ret.setContextInformation(proposal.getContextInformation());
        ret.fFullPrefix = fullPrefix;
        ret.fCEditor = ParameterGuessingProposal.getCEditor(context.getEditor());
        ret.fAssignableElements = availableElements;
        return ret;
    }

    private static String getParametersList(IFunction method) {
        StringBuilder params = new StringBuilder();
        IParameter[] iParameterArray = method.getParameters();
        int n = iParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter param = iParameterArray[n2];
            if (params.length() != 0) {
                params.append(", ");
            }
            params.append(param.getName());
            ++n2;
        }
        return params.toString();
    }

    public ParameterGuessingProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, String idString, int relevance, ITextViewer viewer, IFunction function, int invocationOffset, int parseOffset, ITranslationUnit tu, IDocument document) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, idString, relevance, viewer, function, invocationOffset, parseOffset, tu, document);
    }

    private static boolean isInsideBracket(int invocationOffset, int parseOffset) {
        return invocationOffset - parseOffset != 0;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (ParameterGuessingProposal.isInsideBracket(this.fInvocationOffset, this.fParseOffset)) {
            try {
                return this.fDocument.get(this.getReplacementOffset(), this.fInvocationOffset - this.getReplacementOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        this.generateParameterGuesses();
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        try {
            if (this.fPositions != null && this.fTextViewer != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < this.fPositions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = this.fPositions[i].getOffset();
                    int positionLength = this.fPositions[i].getLength();
                    if (this.fChoices[i].length == 0) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), this.fPositions[i]);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                if (this.fCEditor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fCEditor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.fTextViewer);
                ui.setExitPosition(this.fTextViewer, baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                final char exitChar = replacement.charAt(replacement.length() - 1);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new FunctionCompletionProposal.ExitPolicy(exitChar){

                    @Override
                    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model2, VerifyEvent event, int offset2, int length) {
                        if (event.character == ',') {
                            int i = 0;
                            while (i < ParameterGuessingProposal.this.fPositions.length - 1) {
                                Position position = ParameterGuessingProposal.this.fPositions[i];
                                if (position.offset <= offset2 && offset2 + length <= position.offset + position.length) {
                                    event.character = (char)9;
                                    event.keyCode = 9;
                                    return null;
                                }
                                ++i;
                            }
                        } else if (event.character == ')' && exitChar != ')') {
                            Position position = ParameterGuessingProposal.this.fPositions[ParameterGuessingProposal.this.fPositions.length - 1];
                            if (position.offset <= offset2 && offset2 + length <= position.offset + position.length) {
                                return new LinkedModeUI.ExitFlags(2, false);
                            }
                        }
                        return super.doExit(model2, event, offset2, length);
                    }
                });
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
            }
        }
        catch (Exception e) {
            this.ensurePositionCategoryRemoved(document);
            CUIPlugin.log(e);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public void generateParameterGuesses() {
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)this.fTranslationUnit, ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                if (astRoot == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    ParameterGuessingProposal.this.guessParameters(astRoot);
                }
                catch (Exception e) {
                    CUIPlugin.log(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        });
        if (Status.CANCEL_STATUS == status) {
            return;
        }
    }

    void guessParameters(IASTTranslationUnit ast) throws CModelException {
        this.fParametersNames = ParameterGuessingProposal.getFunctionParametersNames(this.fFunctionParameters);
        this.fParametersTypes = ParameterGuessingProposal.getFunctionParametersTypes(this.fFunctionParameters);
        int count = this.fParametersNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        ParameterGuesser guesser = new ParameterGuesser();
        int i = 0;
        while (i < count) {
            String paramName = new String(this.fParametersNames[i]);
            Position position = new Position(0, 0);
            boolean isLastParameter = i == count - 1;
            ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
            ICompletionProposal[] argumentProposals = guesser.parameterProposals(this.fParametersTypes[i], paramName, position, this.fAssignableElements, isLastParameter, ast);
            allProposals.addAll(Arrays.asList(argumentProposals));
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            ++i;
        }
        this.updateProposalsPositions();
    }

    private void updateProposalsPositions() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.fFullPrefix);
        this.setCursorPosition(buffer.length());
        int count = this.fParametersNames.length;
        int replacementOffset = this.getReplacementOffset();
        int i = 0;
        while (i < count) {
            if (i != 0) {
                buffer.append(", ");
            }
            String argument = new String(this.fParametersNames[i]);
            Position position = this.fPositions[i];
            position.setOffset(replacementOffset + buffer.length());
            position.setLength(argument.length());
            buffer.append(argument);
            ++i;
        }
    }

    private static IType[] getFunctionParametersTypes(IParameter[] functionParameters) {
        IType[] ret = new IType[functionParameters.length];
        int i = 0;
        while (i < functionParameters.length) {
            ret[i] = functionParameters[i].getType();
            ++i;
        }
        return ret;
    }

    private static char[][] getFunctionParametersNames(IParameter[] functionParameters) {
        char[][] parameterNames = new char[functionParameters.length][];
        int i = 0;
        while (i < functionParameters.length) {
            parameterNames[i] = functionParameters[i].getNameCharArray();
            ++i;
        }
        return parameterNames;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    private static CEditor getCEditor(IEditorPart editorPart) {
        if (editorPart instanceof CEditor) {
            return (CEditor)editorPart;
        }
        return null;
    }

    public ICompletionProposal[][] getParametersGuesses() {
        return this.fChoices;
    }
}

