/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.MessageConsoleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.Version;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SBIStatus;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.RootstrapException;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.sbilib.ide.ToolchainNotFoundException;

public class SmartBuildInterface
extends CommandLauncher {
    private final Logger logger = LoggerFactory.getLogger(SmartBuildInterface.class);
    private static final String TmpPath;
    private static final String PluginPath;
    private static final String[] envp;
    private static final String PluginDir = "plugins";
    private static final String platformDir;
    private static final String tmpDir = "tmp";
    private static final String LIB_DIR = "lib";
    private static final String toolsDir;
    private static final String SBIPath;
    private static final String MsysBinPath;
    private static final String MingwBinPath;
    private static final String APICheckerPath;
    private Process shellProcess;
    private static final String TOOLCHAIN_TYPE_PLATFORM = "tizen.platform";
    private static final String TOOLCHAIN_TYPE_NATIVE = "tizen.core";

    static {
        platformDir = String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + "platforms";
        toolsDir = String.valueOf(InstallPathConfig.getSDKPath()) + File.separatorChar + "tools";
        SBIPath = String.valueOf(toolsDir) + File.separatorChar + "smart-build-interface";
        TmpPath = String.valueOf(new Path(SBIPath).toOSString()) + File.separatorChar + tmpDir;
        PluginPath = String.valueOf(new Path(SBIPath).toOSString()) + File.separatorChar + PluginDir;
        APICheckerPath = String.valueOf(new Path(toolsDir).toOSString()) + File.separatorChar + "apichecker";
        if (System.getProperty("os.name").startsWith("Windows")) {
            String pathVar = System.getenv("PATH");
            String InstallPath = InstallPathConfig.getSDKPath();
            MingwBinPath = String.valueOf(InstallPath) + File.separatorChar + "tools" + File.separatorChar + "msys2" + File.separatorChar + "usr" + File.separatorChar + "bin";
            MsysBinPath = String.valueOf(InstallPath) + File.separatorChar + "tools" + File.separatorChar + "msys2" + File.separatorChar + "usr" + File.separatorChar + "bin";
            pathVar = String.valueOf(MingwBinPath) + ";" + MsysBinPath + ";" + pathVar;
            Map<String, String> envMap = System.getenv();
            ArrayList<String> envArray = new ArrayList<String>();
            for (Map.Entry<String, String> entry : envMap.entrySet()) {
                if (entry.getKey().compareToIgnoreCase("PATH") == 0) {
                    envArray.add(String.format("%s=%s", entry.getKey(), pathVar));
                    continue;
                }
                envArray.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
            envp = envArray.toArray(new String[0]);
        } else {
            MingwBinPath = "";
            MsysBinPath = "";
            envp = null;
        }
    }

    public static SmartBuildInterface getInstance() {
        return new SmartBuildInterface();
    }

    public static SmartBuildInterface getInstance(IProject project) {
        if (project != null) {
            SmartBuildInterface newsbi = new SmartBuildInterface();
            newsbi.setProject(project);
            return newsbi;
        }
        return SmartBuildInterface.getInstance();
    }

    private SmartBuildInterface() {
    }

    public static String getMingwBinPath() {
        return MingwBinPath;
    }

    public String getPluginPath() {
        return PluginPath;
    }

    public String getPlatformBasePath() {
        return platformDir;
    }

    public String getAPICheckerPath() {
        return APICheckerPath;
    }

    public String getMsysBinPath() {
        return MsysBinPath;
    }

    public String getSdkToolsPath() {
        return toolsDir;
    }

    public String getTmpPath() {
        return TmpPath;
    }

    public String[] parseCommandString(String cmd) {
        ArrayList<String> list = new ArrayList<String>();
        char charParen = '\u0000';
        int startItemIdx = 0;
        int i = 0;
        while (i < cmd.length()) {
            char ch = cmd.charAt(i);
            if (charParen != '\u0000') {
                if (ch == '\\' && i + 1 < cmd.length()) {
                    ++i;
                } else if (ch == charParen) {
                    charParen = '\u0000';
                }
            } else if (ch == ' ') {
                list.add(cmd.substring(startItemIdx, i));
                while (i + 1 < cmd.length() && cmd.charAt(i + 1) == ' ') {
                    ++i;
                }
                startItemIdx = i + 1;
            } else if (cmd.charAt(i) == '\"' || cmd.charAt(i) == '\'') {
                charParen = cmd.charAt(i);
            }
            ++i;
        }
        if (startItemIdx != cmd.length()) {
            list.add(cmd.substring(startItemIdx, cmd.length()));
        }
        return list.toArray(new String[0]);
    }

    public Process commandNB(String cmd, String workingDir) {
        String[] cmds = this.parseCommandString(cmd);
        return this.commandNB(cmds, workingDir);
    }

    public Process commandNB(String[] cmds, String workingDir) {
        String[] args = new String[cmds.length - 1];
        int i = 0;
        while (i < cmds.length - 1) {
            args[i] = cmds[i + 1];
            ++i;
        }
        Path workingPath = null;
        if (workingDir != null) {
            workingPath = new Path(workingDir);
        }
        try {
            return super.execute((IPath)new Path(cmds[0]), args, envp, (IPath)workingPath, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SBIStatus command(String cmd) throws SBIException {
        return this.command(cmd, null);
    }

    public SBIStatus command(String cmd, String workingDir) throws SBIException {
        try {
            return this.commandInternal(cmd, workingDir, null, null, null);
        }
        catch (SBIException e) {
            ConsoleManager cm = new ConsoleManager("SBI-Error", false);
            cm.clear();
            MessageConsoleStream stream = cm.getMessageConsoleStream();
            stream.setColor(new Color(null, 255, 0, 0));
            stream.print(e.getMessage());
            throw e;
        }
    }

    public SBIStatus commandConsole(String cmd, String workingDir, String[] env, String consoleName) throws SBIException {
        ConsoleManager cm = new ConsoleManager(consoleName, false);
        MessageConsoleStream stdoutStream = cm.getMessageConsoleStream();
        MessageConsoleStream stderrStream = cm.getMessageConsoleStream();
        cm.clear();
        cm.show();
        stdoutStream.println("Start...");
        stdoutStream.println(String.format("Command: %s", cmd));
        if (workingDir != null) {
            stdoutStream.println(String.format("Working Directory: %s", workingDir));
        } else {
            stdoutStream.println(String.format("Working Directory: None", new Object[0]));
        }
        return this.commandInternal(cmd, workingDir, env, (OutputStream)stdoutStream, (OutputStream)stderrStream);
    }

    private int commandReturnExitValue(String cmd, String workingDir) throws SBIException {
        int illegalCommand = 0;
        int exitValue = 0;
        String[] cmds = this.parseCommandString(cmd);
        String[] args = new String[cmds.length - 1];
        int i = 0;
        while (i < cmds.length - 1) {
            args[i] = cmds[i + 1];
            ++i;
        }
        try {
            Path workingPath = null;
            if (workingDir != null) {
                workingPath = new Path(workingDir);
            }
            this.shellProcess = super.execute((IPath)new Path(cmds[0]), args, envp, (IPath)workingPath, (IProgressMonitor)new NullProgressMonitor());
            if (this.shellProcess == null) {
                throw new SBIException(String.format("SBI process fork failed!\nCommand:%s\n", cmd));
            }
            ByteArrayOutputStream consoleStdoutStream = new ByteArrayOutputStream();
            ByteArrayOutputStream consoleStderrStream = new ByteArrayOutputStream();
            illegalCommand = this.waitAndRead(consoleStdoutStream, consoleStderrStream);
            if (illegalCommand != 0) {
                throw new SBIException(String.format("Illegal command!\nCommand:%s\n", cmd));
            }
            exitValue = this.shellProcess.exitValue();
            this.shellProcess.destroy();
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new SBIException(String.format("Java Exception: %s\nCommand:%s\nMethod:CommandLauncher.execute()", e.getMessage(), cmd));
        }
        return exitValue;
    }

    private synchronized SBIStatus commandInternal(String cmd, String workingDir, String[] env, OutputStream consoleStdoutStream, OutputStream consoleStderrStream) throws SBIException {
        int illegalCommand = 0;
        int exitValue = 0;
        String[] cmds = this.parseCommandString(cmd);
        String[] args = new String[cmds.length - 1];
        int i = 0;
        while (i < cmds.length - 1) {
            args[i] = cmds[i + 1];
            ++i;
        }
        String[] _env = this.getEnvironmentVariables();
        if (env != null) {
            _env = env;
        }
        try {
            Path workingPath = null;
            if (workingDir != null) {
                workingPath = new Path(workingDir);
            }
            this.shellProcess = this.getProject() != null ? super.execute((IPath)new Path(cmds[0]), args, _env, (IPath)workingPath, (IProgressMonitor)new NullProgressMonitor()) : super.execute((IPath)new Path(cmds[0]), args, envp, (IPath)workingPath, (IProgressMonitor)new NullProgressMonitor());
            if (this.shellProcess == null) {
                throw new SBIException(String.format("SBI process fork failed!\nCommand:%s\n", cmd));
            }
            if (consoleStdoutStream != null && consoleStderrStream != null) {
                illegalCommand = this.waitAndRead(consoleStdoutStream, consoleStderrStream);
                if (illegalCommand != 0) {
                    throw new SBIException(String.format("Illegal command!\nCommand:%s\n", cmd));
                }
                exitValue = this.shellProcess.exitValue();
                this.shellProcess.destroy();
                if (exitValue == 0) {
                    return new SBIStatus(SBIStatus.OK, null, null);
                }
                throw new SBIException(String.format("SBI failed!\nCommand:%s\n", cmd));
            }
            consoleStdoutStream = new ByteArrayOutputStream();
            consoleStderrStream = new ByteArrayOutputStream();
            illegalCommand = this.waitAndRead(consoleStdoutStream, consoleStderrStream);
            if (illegalCommand != 0) {
                throw new SBIException(String.format("Illegal command!\nCommand:%s\n", cmd));
            }
            exitValue = this.shellProcess.exitValue();
            this.shellProcess.destroy();
            if (exitValue == 0) {
                return new SBIStatus(SBIStatus.OK, consoleStdoutStream.toString(), consoleStderrStream.toString());
            }
            throw new SBIException(String.format("SBI failed!\nCommand:%s\n%s\n%s\n", cmd, consoleStdoutStream.toString(), consoleStderrStream.toString()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new SBIException(String.format("Java Exception: %s\nCommand:%s\nMethod:CommandLauncher.execute()", e.getMessage(), cmd));
        }
    }

    public Process getProcess() {
        return this.shellProcess;
    }

    public void actionConsole(String cmd, String workingDir, String[] env, String consoleName) throws SBIException {
        if (consoleName == null) {
            consoleName = "Action";
        }
        this.commandConsole(cmd, workingDir, env, consoleName);
    }

    public List<String> getTargetList() throws SBIException {
        return SBIModel.getTargetIdList();
    }

    public List<String> getRootstrapList() throws SBIException {
        return SBIModel.getRootstrapIdList();
    }

    public List<String> getToolchainList() throws SBIException {
        return SBIModel.getToolchainIdList();
    }

    public String getRootstrapPath(String targetID) throws SBIException {
        String rPath;
        String result = null;
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrapByTargetId(targetID);
        String string = rPath = rs != null ? rs.getPath() : null;
        if (rPath != null) {
            result = rPath.replaceAll("\\\\", "/");
        }
        return result;
    }

    public String getRootstrapVersion(String targetID) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrapByTargetId(targetID);
        if (rs == null) {
            return null;
        }
        return rs.getVersion();
    }

    public String getRootstrapArchitecture(String targetID) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrapByTargetId(targetID);
        if (rs == null) {
            return null;
        }
        return rs.getArchitecture();
    }

    @Deprecated
    public String getRootstrapVersionFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return null;
        }
        return rs.getVersion();
    }

    public String getVersionFromRootstrap(String rootstrapID) {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return null;
        }
        return rs.getVersion();
    }

    public String getRootstrapArchitectureFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return null;
        }
        return rs.getArchitecture();
    }

    public String getRootstrapNameFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return null;
        }
        return rs.getName();
    }

    public String getRootstrapPathFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return null;
        }
        String rPath = rs.getPath();
        if (rPath == null) {
            return null;
        }
        return rPath.replaceAll("\\\\", "/");
    }

    public boolean getIsDefaultFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return false;
        }
        return rs.isDefault();
    }

    public String getToolchianNameFromToolchainID(String toolchainID) throws SBIException {
        Toolchain tc = SBIModel.getToolchainById(toolchainID);
        if (tc == null) {
            return null;
        }
        return tc.getName();
    }

    public boolean isToolSupported(String targetId, String toolName) {
        PluginManager pm = PluginManager.getInstance();
        Toolchain tc = pm.getToolchainByTargetId(targetId);
        if (tc == null) {
            return false;
        }
        return tc.getTool(toolName) != null;
    }

    public String getToolPath(String targetID, String toolName) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        Toolchain tc = pm.getToolchainByTargetId(targetID);
        if (tc == null) {
            return "";
        }
        Tool tool = tc.getTool(toolName);
        if (tool == null) {
            return "";
        }
        return tool.getPath();
    }

    public String getCCompilerPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "c_compiler");
    }

    public String getCXXCompilerPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "c++_compiler");
    }

    public String getCXXLinkerPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "c++_linker");
    }

    public String getAssemblerPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "assembler");
    }

    public String getArchiverPath(String targetID) throws SBIException {
        if (this.isToolSupported(targetID, "archiver")) {
            return this.getToolPath(targetID, "archiver");
        }
        return null;
    }

    public String getBinutilsPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "binutils");
    }

    public String getEdjeCCPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "edje_cc");
    }

    public String getMsgfmtPath(String targetID) throws SBIException {
        return this.getToolPath(targetID, "msgfmt");
    }

    public String getEdjeBinPath(String targetID) throws SBIException {
        String edjeCCPath = this.getEdjeCCPath(targetID);
        if (edjeCCPath == null || edjeCCPath.isEmpty()) {
            return "";
        }
        try {
            edjeCCPath = new File(edjeCCPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getParentPath(edjeCCPath);
    }

    public String getEdjeLibPath(String targetID) throws SBIException {
        String edjeBinPath = this.getEdjeBinPath(targetID);
        String edjeHomePath = this.getParentPath(edjeBinPath);
        String edjeLibPath = String.valueOf(edjeHomePath) + File.separator + LIB_DIR;
        if (edjeLibPath == null || edjeLibPath.isEmpty()) {
            return "";
        }
        try {
            edjeLibPath = new File(edjeLibPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return edjeLibPath;
    }

    private String getParentPath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        File file = new File(path);
        return file.getParent();
    }

    public Map<String, String> getConfigValueMap(String source) {
        String[] subs;
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = subs = this.splitConfigLineByLine(source);
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            int idx = sub.indexOf("=");
            if (idx >= 1) {
                String key = sub.substring(0, idx);
                String value = sub.substring(idx + 1);
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }

    public String getRootstrapIDFromTargetID(String targetID) {
        if (targetID == null) {
            return "";
        }
        int index = targetID.lastIndexOf("_");
        if (index < 0) {
            return "";
        }
        return targetID.substring(0, index);
    }

    public String getToolchainIDFromTargetID(String targetID) {
        int index = targetID.lastIndexOf("_");
        if (index < 0) {
            return "";
        }
        return targetID.substring(index + 1, targetID.length());
    }

    public String getToolchainNameFromProject(IProject project) {
        String rootstrapID;
        String targetID;
        String toolchainPath = "";
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        if (config != null && (targetID = CommonConfigurationManager.getBuildTargetName(config)) != null && (rootstrapID = this.getRootstrapIDFromTargetID(targetID)) != null && !rootstrapID.equals("")) {
            Toolchain toolChain = this.getToolchainFromRootstrapID(rootstrapID);
            return this.getToolchainNameFromToolchain(toolChain);
        }
        return toolchainPath;
    }

    public String getToolchainNameFromToolchain(Toolchain toolchain) {
        String toolChainPath;
        if (toolchain != null && (toolChainPath = toolchain.getToolchainPath()) != null && !toolChainPath.equals("")) {
            return toolChainPath.substring(toolChainPath.lastIndexOf(47) + 1, toolChainPath.length()).trim();
        }
        return null;
    }

    public Toolchain getToolchainFromRootstrapID(String rootstrapID) {
        Rootstrap rs;
        PluginManager pm = PluginManager.getInstance();
        if (rootstrapID != null && pm != null && (rs = pm.getRootstrap(rootstrapID)) != null) {
            try {
                Tool defaultToolchain = rs.getDefaultToolchain();
                if (defaultToolchain != null) {
                    return pm.getToolchain(defaultToolchain.getName(), defaultToolchain.getVersion(), rs.getArchitecture());
                }
            }
            catch (RootstrapException rootstrapException) {
                this.logger.warn("failed to get Roostrap using " + rootstrapID);
            }
            catch (ToolchainNotFoundException toolchainNotFoundException) {
                this.logger.warn("failed to find Toolchain using " + rootstrapID);
            }
        }
        return null;
    }

    public String getArchitectureFromRootstrapID(String rootstrapID) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            throw new SBIException("There is no avaiable rootstrap");
        }
        return SBIModel.getRootstrapById(rootstrapID).getArchitecture();
    }

    public String getArchitectureFromToolchainID(String toolchainID) {
        return SBIModel.getToolchainById(toolchainID).getArchitecture();
    }

    public String getToolchainTypeFromToolchainID(String toolchainID) throws SBIException {
        return SBIModel.getToolchainById(toolchainID).getToolchainType();
    }

    public String getSupportToolchainTypeFromRootstrapID(String rootstrapID) throws SBIException {
        return SBIModel.getRootstrapById(rootstrapID).getSupportToolchainType();
    }

    public boolean doesRootstrapSupportToolchainType(String rootstrapID, String toolchainType) throws SBIException {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapID);
        if (rs == null) {
            return false;
        }
        return rs.isSupportToolchainType(toolchainType);
    }

    private boolean checkCfg(String targetID, List<String> sourceList) {
        for (String id : sourceList) {
            if (!id.equals(targetID)) continue;
            return true;
        }
        return false;
    }

    public boolean checkTargetID(String targetID) throws SBIException {
        List<String> targetList = this.getTargetList();
        return this.checkCfg(targetID, targetList);
    }

    public boolean checkToolchainID(String toolchainID) throws SBIException {
        List<String> toolchainList = this.getToolchainList();
        return this.checkCfg(toolchainID, toolchainList);
    }

    public boolean checkRootstrapID(String rootstrapID) throws SBIException {
        List<String> rootstrapList = this.getRootstrapList();
        return this.checkCfg(rootstrapID, rootstrapList);
    }

    public boolean isToolchainSupported(String toolchainName, String artifactType) throws SBIException {
        List<String> toolchainCfgList = this.getToolchainList();
        for (String toolchainID : toolchainCfgList) {
            String projectType = this.getToolchainPropertyValue(toolchainID, "PROJECT_TYPE");
            if (projectType != null && artifactType != null && !projectType.equals(artifactType)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canProvideVirtualEnvironment(String targetID) {
        String toolchainCfgName = this.getToolchainIDFromTargetID(targetID);
        try {
            String result;
            String toolchainID;
            List<String> toolchainCfgList = this.getToolchainList();
            Iterator<String> iterator = toolchainCfgList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(toolchainID = iterator.next()).equals(toolchainCfgName) || (result = this.getToolchainPropertyValue(toolchainID, "SUPPORT_VIRTUAL_ENVIRONMENT")) == null || !result.equals("yes"));
            return true;
        }
        catch (SBIException e) {
            this.logger.error("Unknown error occurred", (Throwable)e);
        }
        return false;
    }

    public static String makeTargetID(String rootstrapID, String toolchainID) {
        return String.valueOf(rootstrapID) + "_" + toolchainID;
    }

    public void writeTargetCfgFile(String targetID) throws SBIException {
        String rootstrapCfgName = this.getRootstrapIDFromTargetID(targetID);
        String toolchainCfgName = this.getToolchainIDFromTargetID(targetID);
        SBIModel.addTarget(targetID, targetID, rootstrapCfgName, toolchainCfgName);
    }

    public String getToolchainPropertyValue(String toolchainID, String key) {
        PluginManager pm = PluginManager.getInstance();
        Toolchain tc = pm.getToolchain(toolchainID);
        return tc.getPropertyValue(key);
    }

    public String getRootstrapPropertyValue(String rootstrapId, String key) {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId);
        if (rs == null) {
            return null;
        }
        return rs.getPropertyValue(key);
    }

    public List<Rootstrap> getPlatformRootstrapList() {
        PluginManager pm = PluginManager.getInstance();
        return pm.getAvailableRootstrapList(TOOLCHAIN_TYPE_PLATFORM);
    }

    public List<Rootstrap> getCoreRootstrapList() {
        PluginManager pm = PluginManager.getInstance();
        return pm.getAvailableRootstrapList(TOOLCHAIN_TYPE_NATIVE);
    }

    public List<Rootstrap> getAvailableRootstrapList(String rootstrapId) {
        if (SmartBuildInterface.getInstance().isPlatformRootstrap(rootstrapId)) {
            return this.getAvailablePlatformRootstrapList();
        }
        if (SmartBuildInterface.getInstance().isNativeRootstrap(rootstrapId)) {
            return this.getAvailableNativeRootstrapList(rootstrapId);
        }
        return Collections.emptyList();
    }

    private List<Rootstrap> getAvailablePlatformRootstrapList() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        return sbi.getPlatformRootstrapList();
    }

    private List<Rootstrap> getAvailableNativeRootstrapList(String rootstrapId) {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap currentRS = pm.getRootstrap(rootstrapId);
        String currentProfile = currentRS.getProfile();
        String currentVersion = currentRS.getProfileVersion();
        if (currentProfile == null || currentVersion == null) {
            return Collections.emptyList();
        }
        Version currentVer = new Version(currentVersion);
        ArrayList<Rootstrap> availableRS = new ArrayList<Rootstrap>();
        for (Rootstrap rs : this.getCoreRootstrapList()) {
            if (!currentProfile.equals(rs.getProfile()) || currentVer.compareTo(new Version(rs.getProfileVersion())) > 0) continue;
            availableRS.add(rs);
        }
        return availableRS;
    }

    private String getRootstrapType(String rootstrapId) {
        if (rootstrapId == null || rootstrapId.isEmpty()) {
            return null;
        }
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId);
        if (rs == null) {
            return null;
        }
        return rs.getSupportToolchainType();
    }

    public boolean isPlatformRootstrap(String rootstrapId) {
        String supportToolchain = this.getRootstrapType(rootstrapId);
        if (supportToolchain == null) {
            return false;
        }
        return supportToolchain.equals(TOOLCHAIN_TYPE_PLATFORM);
    }

    public boolean isNativeRootstrap(String rootstrapId) {
        String supportToolchain = this.getRootstrapType(rootstrapId);
        if (supportToolchain == null) {
            return false;
        }
        return supportToolchain.equals(TOOLCHAIN_TYPE_NATIVE);
    }

    public String[] splitConfigLineByLine(String src) {
        String str1 = src.replace("\r\n", "\n");
        String str2 = str1.replace("\r", "\n");
        return str2.split("\n");
    }

    public String[] getEnvironmentVariables() {
        ArrayList<String> newEnvArray = new ArrayList<String>();
        if (envp == null) {
            Map<String, String> envMap = this.getEnvMap();
            for (Map.Entry<String, String> entry : envMap.entrySet()) {
                newEnvArray.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        } else {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String env = stringArray[n2];
                newEnvArray.add(env);
                ++n2;
            }
        }
        return newEnvArray.toArray(new String[0]);
    }

    public Map<String, String> getEnvMap() {
        HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
        this.verifyEnv(envMap);
        return envMap;
    }

    public String[] addEnvironmentVariableArray(String key, String value) {
        Map<String, String> envMap = this.addEnvironmentVariable(key, value);
        ArrayList<String> newEnvArray = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            newEnvArray.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return newEnvArray.toArray(new String[0]);
    }

    public Map<String, String> addEnvironmentVariable(String key, String value) {
        Map<String, String> envMap = this.getEnvMap();
        envMap.put(key, value);
        return envMap;
    }

    public String getMinGWPathFromWindowsPath(String srcPath, boolean removeDrive) {
        char ch;
        if ("".equals(srcPath)) {
            return srcPath;
        }
        int index = srcPath.indexOf(":");
        if (index < 0) {
            return srcPath;
        }
        String drive = srcPath.substring(0, index);
        if (drive.length() == 1 && ((ch = drive.charAt(0)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            String path = srcPath.substring(index + 1);
            if (path.contains("\\")) {
                path = path.replace("\\", "/");
            }
            String result = "";
            result = removeDrive ? path : String.format("/%c%s", Character.valueOf(ch), path);
            return result;
        }
        return srcPath;
    }

    public String getWindowsPathFromMinGWPath(String srcPath) {
        char drive;
        if ("".equals(srcPath)) {
            return srcPath;
        }
        if ((srcPath = srcPath.replace("\\", "/")).charAt(0) == '/' && srcPath.charAt(2) == '/' && ((drive = srcPath.charAt(1)) >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z')) {
            String _path = String.valueOf(drive) + ":";
            _path = _path.concat(srcPath.substring(2));
            return _path;
        }
        return srcPath;
    }

    public String getPlatformRootstrapPath(String rootstrapBasePath) {
        return this.getPlatformRootstrapPath((IPath)new Path(rootstrapBasePath));
    }

    public String getPlatformRootstrapPath(IPath rootstrapBasePath) {
        IPath basePath = rootstrapBasePath.append("local").append("BUILD-ROOTS");
        File buildRoots = new File(basePath.toOSString());
        if (buildRoots.exists() && buildRoots.listFiles() != null) {
            File[] fileArray = buildRoots.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && f.getName().startsWith("scratch.")) {
                    return f.getPath();
                }
                ++n2;
            }
        }
        return null;
    }

    public void verifyEnv(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!"no_proxy".equals(entry.getKey().trim())) continue;
            boolean dirty = false;
            String value = entry.getValue();
            if (value.startsWith(",")) {
                value = value.substring(1);
                dirty = true;
            }
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
                dirty = true;
            }
            if (!dirty) continue;
            entry.setValue(value);
        }
    }

    public boolean removeTmpDir() {
        File tmpDir = new File(this.getTmpPath());
        if (tmpDir.exists()) {
            return FileUtil.recursiveDelete((File)tmpDir);
        }
        return true;
    }

    public void reloadPlugin(String pluginId) {
        PluginManager pm = PluginManager.getInstance();
        pm.loadPlugin(pluginId);
    }
}

