/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.VariableHelpers;

public class CPPField
extends CPPVariable
implements ICPPField {
    public CPPField(IASTName name) {
        super(name);
    }

    @Override
    public int getVisibility() {
        return VariableHelpers.getVisibility(this);
    }

    @Override
    public ICPPClassType getClassOwner() {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    @Override
    public boolean isStatic() {
        IASTNode def;
        if (this.getDeclarations() == null && (def = this.getDefinition()) instanceof ICPPASTQualifiedName) {
            return true;
        }
        return super.isStatic();
    }

    @Override
    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public ICompositeType getCompositeTypeOwner() {
        return this.getClassOwner();
    }

    @Override
    public int getFieldPosition() {
        return CPPField.getFieldPosition(this.getName(), this.getClassOwner());
    }

    public static int getFieldPosition(String fieldName, ICPPClassType classOwner) {
        ICPPField[] fields = ClassTypeHelper.getDeclaredFields(classOwner, null);
        int fieldPos = 0;
        while (fieldPos < fields.length) {
            if (fields[fieldPos].getName().equals(fieldName)) {
                return fieldPos;
            }
            ++fieldPos;
        }
        return -1;
    }

    public static class CPPFieldProblem
    extends ProblemBinding
    implements ICPPField {
        private ICPPClassType fOwner;

        public CPPFieldProblem(ICPPClassType owner, IASTNode node, int id, char[] arg) {
            super(node, id, arg);
            this.fOwner = owner;
        }

        @Override
        public int getVisibility() {
            return 3;
        }

        @Override
        public ICPPClassType getClassOwner() {
            return this.fOwner;
        }

        @Override
        public ICompositeType getCompositeTypeOwner() {
            return this.getClassOwner();
        }

        @Override
        public int getFieldPosition() {
            return -1;
        }
    }
}

