/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import org.tizen.nativecore.misc.core.IconType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Icon {
    public static final String ELEMENT = "icon";
    String lang;
    private String value;
    private String dpi;
    private IconType fIconType;
    private String fIconName;
    private String fType;

    public Icon() {
        this.fIconType = IconType.MAINMENU;
    }

    public Icon(IconType type) {
        this.fIconType = type;
    }

    public IconType getIconType() {
        return this.fIconType;
    }

    public void set(String name) {
        this.fIconName = name;
    }

    public void setType(String fType) {
        this.fType = fType;
    }

    public String getFileName() {
        return this.fIconName;
    }

    public String getType() {
        return this.fType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLang() {
        if (this.lang == null) {
            return null;
        }
        if (this.lang.equalsIgnoreCase("default")) {
            return "";
        }
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getDpi() {
        return this.dpi;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        String value = element.getTextContent().trim();
        this.setLang(element.getAttribute("xml:lang"));
        this.setValue(value);
        this.setIcon(IconType.MAINMENU, value, null);
        this.setDpi(element.getAttribute("dpi"));
    }

    public void generateElement(Document dom, Element parent) {
        String value = this.getFileName();
        if (value != null && value.length() > 0) {
            Element eIcon = dom.createElement(ELEMENT);
            eIcon.setTextContent(value);
            if (this.getLang() != null && this.getLang().length() > 0) {
                eIcon.setAttribute("xml:lang", this.getLang());
            }
            parent.appendChild(eIcon);
        }
    }

    public void setIcon(IconType iType, String value, String type) {
        if (this.getIconType() == iType) {
            this.set(value);
            if (type != null && type.length() > 0) {
                this.setType(type);
            }
        }
    }
}

