/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import org.tizen.nativecore.ext.manifest.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TizenSplashScreen {
    public static final String ELEMENT = "splash-screen";
    private Icon src;
    private String type;
    private String dpi;
    private String orientation;
    private boolean indicator;
    private String operation;
    public static final String ATTR_SRC = "src";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_DPI = "dpi";
    public static final String ATTR_ORIENTATION = "orientation";
    public static final String ATTR_INDICATOR = "indicator-display";
    public static final String ATTR_OPERATION = "app-control-operation";

    public String toString() {
        String def = "Splash Screen";
        return def;
    }

    public Icon getSrc() {
        return this.src;
    }

    public void setSrc(Icon src) {
        this.src = src;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDpi() {
        return this.dpi;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public boolean getIndicator() {
        return this.indicator;
    }

    public void setIndicator(boolean indicator) {
        this.indicator = indicator;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void loadElement(Element element) {
        Icon icon = new Icon();
        icon.set(element.getAttribute(ATTR_SRC));
        this.setSrc(icon);
        this.setDpi(element.getAttribute(ATTR_DPI));
        this.setType(element.getAttribute(ATTR_TYPE));
        this.setOrientation(element.getAttribute(ATTR_ORIENTATION));
        if (element.getAttribute(ATTR_ORIENTATION).equalsIgnoreCase("true")) {
            this.setIndicator(true);
        } else {
            this.setIndicator(false);
        }
        this.setOperation(element.getAttribute(ATTR_OPERATION));
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        element.setAttribute(ATTR_SRC, this.src.getFileName());
        element.setAttribute(ATTR_TYPE, this.type);
        element.setAttribute(ATTR_DPI, this.dpi);
        element.setAttribute(ATTR_ORIENTATION, this.orientation);
        if (this.indicator) {
            element.setAttribute(ATTR_INDICATOR, "true");
        } else {
            element.setAttribute(ATTR_INDICATOR, "false");
        }
        element.setAttribute(ATTR_OPERATION, this.operation);
        parent.appendChild(element);
    }
}

