/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.errorparsers.AbstractErrorParser;
import org.eclipse.cdt.core.errorparsers.ErrorPattern;
import org.tizen.nativeappcommon.parser.SLPErrorPattern;

public class SLPGccErrorParser
extends AbstractErrorParser {
    private static final Pattern[] PatternsForVariables = new Pattern[]{Pattern.compile("'(.*)' undeclared"), Pattern.compile("'(.*)' defined but not used"), Pattern.compile("conflicting types for '(.*)'"), Pattern.compile("parse error before '(.*)'")};
    private static final SLPErrorPattern[] patterns = new SLPErrorPattern[]{new SLPErrorPattern("\\(Each undeclared identifier is reported only once"), new SLPErrorPattern("for each function it appears in.\\)"), new SLPErrorPattern(": note:"), new SLPErrorPattern("instantiated from "), new SLPErrorPattern("(.*?):([0-9]+):([0-9]+:)?(.*[([Ww]arning)([Ee]rror)]:)? (.*)", 1, 2, 5, 0, 0){

        public String getVarName(Matcher matcher) {
            String description = this.getDesc(matcher);
            if (description == null) {
                return null;
            }
            int i = 0;
            while (i < PatternsForVariables.length) {
                Matcher MatcherForVar = PatternsForVariables[i].matcher(description);
                if (MatcherForVar.find()) {
                    return MatcherForVar.group(1);
                }
                ++i;
            }
            return null;
        }

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(4);
            if (warningGroup != null && warningGroup.indexOf("arning") >= 0) {
                return 1;
            }
            return 2;
        }
    }};

    public SLPGccErrorParser() {
        super((ErrorPattern[])patterns);
    }
}

