/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.internal.ui.wizard.icon;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecore.misc.IConstants;
import org.tizen.nativecore.misc.core.IconType;
import org.tizen.nativecore.misc.core.ScreenDensity;
import org.tizen.nativecore.misc.internal.ui.wizard.icon.UiChooseIconTypePage;
import org.tizen.nativecore.misc.internal.ui.wizard.icon.UiConfigureIconPage;

public class UiNewIconWizard
extends Wizard
implements INewWizard {
    private Options fOptions = new Options();

    public UiNewIconWizard(IProject project, String resolutionFolder) {
        this.setWindowTitle("Create Icon");
        TrayDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        this.fOptions.resolutionFolder = resolutionFolder;
        this.fOptions.project = project;
    }

    public Options getOptions() {
        return this.fOptions;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        IFile destFile = this.fOptions.getProject().getFile(String.valueOf(IConstants.DIR_SHARED_RES) + File.separatorChar + this.fOptions.getResolutionFolder() + File.separatorChar + this.fOptions.getSrcFile().getName());
        IFolder folder = (IFolder)destFile.getParent();
        if (!folder.exists()) {
            try {
                IFolder sharedDir = (IFolder)folder.getParent();
                if (!sharedDir.exists()) {
                    sharedDir.create(true, true, null);
                }
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (destFile.exists()) {
            MessageDialog dlg = new MessageDialog(this.getShell(), "File Already Exists", null, String.valueOf(destFile.getProjectRelativePath().toOSString()) + " already exists.\nWould you like to replace it?", 3, new String[]{"Yes", "No"}, 0);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            try {
                destFile.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            Image image = this.fOptions.getImage();
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            loader.save(destFile.getLocation().toString(), 5);
            destFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException e3) {
            e3.printStackTrace();
        }
        return true;
    }

    public void dispose() {
        TrayDialog.setDialogHelpAvailable((boolean)true);
        super.dispose();
    }

    public void addPages() {
        UiChooseIconTypePage typePage = new UiChooseIconTypePage(this);
        this.addPage((IWizardPage)typePage);
        UiConfigureIconPage configPage = new UiConfigureIconPage(this);
        this.addPage((IWizardPage)configPage);
    }

    public static class Options {
        IProject project;
        IconType iconType = IconType.MAINMENU;
        File srcFile;
        Image resultImage;
        private int recommendedSize;
        private ScreenDensity density;
        private String resolutionFolder;
        private HashMap<String, BufferedImage> fImgCache;

        public ScreenDensity getDensity() {
            return this.density;
        }

        public void setDensity(ScreenDensity density) {
            this.density = density;
        }

        public IProject getProject() {
            return this.project;
        }

        public Image getImage() {
            return this.resultImage;
        }

        public void setImage(Image image) {
            this.resultImage = image;
        }

        public File getSrcFile() {
            return this.srcFile;
        }

        public void setSrcFile(File src) {
            this.srcFile = src;
        }

        public void setIconType(IconType type) {
            this.iconType = type;
        }

        public IconType getIconType() {
            return this.iconType;
        }

        public int getRecommendedSize() {
            return this.recommendedSize;
        }

        public void setRecommendedSize(int recommendedSize) {
            this.recommendedSize = recommendedSize;
        }

        public String getResolutionFolder() {
            return this.resolutionFolder;
        }

        public void setResolutionFolder(String resolutionFolder) {
            this.resolutionFolder = resolutionFolder;
        }

        public static BufferedImage getAWTImage(String path, boolean isRelativePath) {
            BufferedImage image;
            block9: {
                image = null;
                InputStream is = null;
                try {
                    try {
                        if (isRelativePath) {
                            is = UiNewIconWizard.class.getResourceAsStream(path);
                            if (is != null) {
                                image = ImageIO.read(is);
                            }
                        } else {
                            image = ImageUtil.getAWTImage((String)path, (boolean)isRelativePath);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        IOUtil.tryClose((Object[])new Object[]{is});
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{is});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{is});
            }
            if (image == null) {
                image = new BufferedImage(1, 1, 2);
            }
            return image;
        }

        public BufferedImage getCachedImage(String fullpath, boolean relative) {
            BufferedImage image;
            if (this.fImgCache == null) {
                this.fImgCache = new HashMap();
            }
            if ((image = this.fImgCache.get(fullpath)) == null && (image = Options.getAWTImage(fullpath, relative)) != null) {
                this.fImgCache.put(fullpath, image);
                return image;
            }
            return image;
        }
    }
}

