/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.service.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.Category;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class ServiceCategoryEditingSupport
extends EditingSupport {
    int column;
    private CellEditor editor;
    private AbstractChangeListener listener;

    public ServiceCategoryEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Category)) {
            return null;
        }
        Category category = (Category)element;
        switch (this.column) {
            case 0: {
                return category.getName();
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Category)) {
            return;
        }
        Category category = (Category)element;
        switch (this.column) {
            case 0: {
                category.setName((String)value);
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

