/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.util;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.IOUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Application;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;

public class ConfigurationUtil {
    public static String[] VERSIONS_SUPPORT_TRUST_ANCHOR = new String[]{"4.0"};
    public static String[] VERSIONS_SUPPORT_APPDEFINED_PRIVILEGE = new String[]{"4.0"};

    public static Widget getWidget(IProject project) throws CoreException, ConfigurationException {
        Assert.isNotNull((Object)project);
        if (!project.isAccessible()) {
            return null;
        }
        IFile file = project.getFile("config.xml");
        if (!file.isAccessible()) {
            return null;
        }
        InputStream is = null;
        Widget widget = null;
        try {
            is = file.getContents();
            widget = ConfiguratorFactory.unmarshal(is);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return widget;
    }

    public static String getApplicationVersion(IProject project) throws CoreException, ConfigurationException {
        TizenProjectDescription description = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (description != null) {
            return description.getVersion();
        }
        return null;
    }

    public static String getRequiredVersion(IProject project) throws CoreException, ConfigurationException {
        Application application = ConfigurationUtil.getApplication(project);
        if (application != null) {
            return application.getRequiredVersion();
        }
        return null;
    }

    private static Application getApplication(IProject project) throws CoreException, ConfigurationException {
        Widget widget = ConfigurationUtil.getWidget(project);
        if (widget == null) {
            return null;
        }
        List elements = widget.getContent();
        for (Object element : elements) {
            if (!(element instanceof Application)) continue;
            return (Application)element;
        }
        return null;
    }
}

