/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.widl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.web.editor.widl.IDLReader;
import org.tizen.web.editor.widl.model.Module;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExternalIDLHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String IDL_FOLDER = "external-idls";
    private static ExternalIDLHandler instance;

    public static ExternalIDLHandler getInstance() {
        if (instance == null) {
            instance = new ExternalIDLHandler();
        }
        return instance;
    }

    private ExternalIDLHandler() {
    }

    public Collection<Module> getModules(IProject project) {
        Assert.notNull((Object)project, (String)"No project to get features from");
        LinkedList<Module> result = new LinkedList<Module>();
        IFolder folder = project.getFolder(IDL_FOLDER);
        if (folder.exists()) {
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    String fileExtension;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile && resource.isAccessible() && (fileExtension = (file = (IFile)resource).getFileExtension()) != null && (fileExtension.equalsIgnoreCase("xml") || fileExtension.equalsIgnoreCase("widlprocxml"))) {
                        Collection<Module> modules = this.scanDocument(file);
                        result.addAll(modules);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public Collection<Module> scanDocument(IFile file) {
        Collection<Module> collection;
        if (file == null || !file.isAccessible()) {
            return new HashSet<Module>();
        }
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        InputStream inputStream = null;
        try {
            Collection<Module> newModules;
            inputStream = file.getContents();
            Document document = reader.read(inputStream);
            IDLReader readerInstance = IDLReader.getInstance();
            collection = newModules = readerInstance.processDocument(document);
        }
        catch (DocumentException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        catch (CoreException e2) {
            this.logger.error(e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return collection;
        return new HashSet<Module>();
    }
}

