/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FileUtil;

public abstract class AbstractLintBuilder
extends AbstractBuilder {
    private String extension;
    protected String[] excludes = new String[0];
    protected String[] excludeFolders = new String[0];

    public AbstractLintBuilder(String extension) {
        this.extension = extension;
    }

    public AbstractLintBuilder(String extension, IBuildListener buildListener) {
        super(buildListener);
        this.extension = extension;
    }

    public boolean canBuild(IResource resource) {
        if (this.extension == null) {
            return false;
        }
        if (!this.extension.equalsIgnoreCase(FileUtil.getFileExtension((String)resource.getName()))) {
            return false;
        }
        String[] stringArray = this.excludeFolders;
        int n = this.excludeFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String excludeFolder = stringArray[n2];
            if (resource.getPath().startsWith(excludeFolder)) {
                return false;
            }
            ++n2;
        }
        stringArray = this.excludes;
        n = this.excludes.length;
        n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            if (resource.getPath().contains(exclude)) {
                return false;
            }
            ++n2;
        }
        return super.canBuild(resource);
    }

    public void setExcludes(String ... excludes) {
        super.setExcludes(excludes);
        this.excludes = excludes;
    }

    public void setExcludeFolders(String ... excludeFolders) {
        if (excludeFolders == null) {
            excludeFolders = new String[]{};
        }
        this.excludeFolders = excludeFolders;
    }
}

