/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide.listener;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.file.IResource;
import org.tizen.common.util.Assert;

public class ErrorMarkListener
implements IBuildListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String markerId = null;
    private IProject project;

    public ErrorMarkListener(IProject project, String markerId) {
        Assert.notNull((Object)project);
        this.project = project;
        this.markerId = markerId;
    }

    public void buildSuccess(BuildResult result) {
        for (IResource resource : result.getInputs()) {
            this.deleteMarkers(this.markerId, resource);
        }
    }

    public void buildError(BuildResult result) {
        this.createMarkers(result.getBuildErrorInfos());
    }

    private void deleteMarkers(String markerId, IResource resource) {
        String path = resource.getPath();
        IFile file = this.project.getFile(path);
        if (!file.exists()) {
            this.logger.debug("{} file does not exists.", (Object)path);
            return;
        }
        try {
            file.deleteMarkers(markerId, true, 0);
        }
        catch (CoreException e) {
            this.logger.info("Can't delete {} file's markers", (Object)path);
            this.logger.info(e.getMessage(), (Throwable)e);
        }
    }

    private void createMarkers(Collection<BuildErrorInfo> buildErrorInfos) {
        if (buildErrorInfos == null || buildErrorInfos.size() == 0) {
            this.logger.debug("Build error information does not exists.");
            return;
        }
        for (BuildErrorInfo errInfo : buildErrorInfos) {
            this.logger.debug(errInfo.toString());
            String path = errInfo.getLocation().getResource().getPath();
            IFile file = this.project.getFile(path);
            if (!file.exists()) {
                this.logger.debug("{} file does not exists.", (Object)path);
                continue;
            }
            try {
                IMarker marker = file.createMarker(this.markerId);
                marker.setAttribute("lineNumber", errInfo.getLocation().getLineNumber());
                marker.setAttribute("severity", this.getSeverityOfMarker(errInfo));
                marker.setAttribute("priority", this.getPriorityOfMarker(errInfo));
                marker.setAttribute("message", (Object)errInfo.getMessage());
                marker.setAttribute("location", (Object)("line " + errInfo.getLocation().getLineNumber()));
            }
            catch (CoreException e) {
                this.logger.info("Can't create {} file's markers", (Object)file.getFullPath().toString());
                this.logger.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    private int getPriorityOfMarker(BuildErrorInfo errInfo) {
        int severity = this.getSeverityOfMarker(errInfo);
        switch (severity) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    private int getSeverityOfMarker(BuildErrorInfo errInfo) {
        switch (errInfo.getSeverity()) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public void buildWarning(BuildResult result) {
        this.createMarkers(result.getBuildErrorInfos());
    }

    public void preBuild(IResource resource) {
        this.deleteMarkers(this.markerId, resource);
    }

    public void postBuild(IResource resource) {
    }
}

