/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.cli.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.engine.freemarker.FreemarkerTemplateEngine;
import org.tizen.common.verrari.engine.freemarker.FreemarkerTemplateTransformer;
import org.tizen.common.verrari.model.ModelManager;
import org.tizen.common.verrari.template.InMemoryTemplate;
import org.tizen.common.verrari.template.TemplateManager;
import org.tizen.common.verrari.util.BufferFactory;

public class ProjectGenCommand
implements Command<String> {
    protected static final String DEFAULT_PROJECT_NAME = "HelloTizen";
    protected static final String DEFAULT_TEMPLATE_NAME = "Basic";
    protected String result;
    protected FileHandler fileHandler;
    protected String projectName;
    protected String templateName;
    protected String targetPath;

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getProjectName() {
        if (StringUtil.isEmpty((CharSequence)this.projectName)) {
            this.setProjectName(DEFAULT_PROJECT_NAME);
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTemplateName() {
        if (StringUtil.isEmpty((CharSequence)this.templateName)) {
            this.setTemplateName(DEFAULT_TEMPLATE_NAME);
        }
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTargetPath() {
        if (StringUtil.isEmpty((CharSequence)this.targetPath)) {
            this.setTargetPath(StringUtil.trimTrailingCharacter((String)System.getProperty("user.dir"), (char)'.'));
        }
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public ProjectGenCommand() {
        this.projectName = DEFAULT_PROJECT_NAME;
    }

    public ProjectGenCommand(String projectName) {
        this.projectName = projectName;
    }

    protected boolean ensureDirectoryExists(File f) {
        if (f == null) {
            return false;
        }
        return f.exists() || f.mkdirs();
    }

    public boolean copyResourcesRecursively(File destDir, File srcDir) throws IOException {
        if (destDir == null || srcDir == null) {
            return false;
        }
        FileUtil.copyRecursively((String)srcDir.getAbsolutePath(), (String)destDir.getAbsolutePath());
        return true;
    }

    @Deprecated
    public boolean copyJarResourcesRecursively(File destDir, JarURLConnection jarConnection) throws IOException {
        if (destDir == null || jarConnection == null) {
            return false;
        }
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String filename = StringUtil.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            File f = new File(destDir, filename);
            File fAbs = new File(f.getAbsolutePath());
            if (!entry.isDirectory()) {
                if (!this.ensureDirectoryExists(fAbs.getParentFile())) {
                    throw new IOException("Could not create directory: " + fAbs.getParentFile().getAbsolutePath());
                }
                InputStream entryInputStream = jarFile.getInputStream(entry);
                FileOutputStream fileOutputStream = new FileOutputStream(fAbs);
                try {
                    IOUtil.redirect((InputStream)entryInputStream, (OutputStream)fileOutputStream);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{entryInputStream, fileOutputStream});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{entryInputStream, fileOutputStream});
                continue;
            }
            if (this.ensureDirectoryExists(fAbs)) continue;
            throw new IOException("Could not create directory: " + f.getAbsolutePath());
        }
        return true;
    }

    protected String templateNameforAddress(String name) throws IOException {
        if (DEFAULT_TEMPLATE_NAME.equalsIgnoreCase(name)) {
            File templateRoot = this.getTemplateRoot();
            String[] candidates = new String[]{"Tizen_Blank", "TizenW_basic"};
            StringBuilder builder = new StringBuilder("Template");
            builder = builder.append(File.separator).append("Tizen").append(File.separator).append(DEFAULT_TEMPLATE_NAME);
            String[] stringArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                StringBuilder template = new StringBuilder(builder).append(File.separator).append(candidate).append(File.separator).append("project");
                File templatePath = new File(templateRoot, template.toString());
                if (this.fileHandler != null && this.fileHandler.is(templatePath.getPath(), FileHandler.Attribute.EXISTS)) {
                    return template.toString();
                }
                ++n2;
            }
        }
        return null;
    }

    @Deprecated
    public URL getTemplateURL(String tempate_address) {
        return this.getClass().getResource(tempate_address);
    }

    public JarURLConnection getTemplateJarURL(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        URL new_url = new URL("jar:" + url.getPath());
        JarURLConnection jurl = (JarURLConnection)new_url.openConnection();
        return jurl;
    }

    public void printInfo(Prompter prompter) {
        if (prompter == null) {
            return;
        }
        prompter.notify("Generate project name: " + this.getProjectName());
        prompter.notify("Generate project path: " + this.getTargetPath());
    }

    public boolean isDirectoryExists(String path) {
        return new File(path).exists();
    }

    public String getDestDir() {
        String name = this.getProjectName();
        String path = this.getTargetPath();
        return FilenameUtil.addTailingPath((String)path, (String)name);
    }

    public ByteArrayOutputStream createConfigXML() throws Exception {
        FreemarkerTemplateEngine engine = new FreemarkerTemplateEngine();
        TemplateManager templateProvider = new TemplateManager();
        engine.setTemplateProvider((ITemplateProvider)templateProvider);
        InputStream inStream = this.getClass().getResource("/templates/engine/config/CONFIGBase").openStream();
        try {
            templateProvider.addTemplate("CONFIGBase", (ITemplate)new InMemoryTemplate(new FreemarkerTemplateTransformer().templateTranslate(FileUtil.readTextStream((InputStream)inStream, null)).getBytes(), "utf-8", (FactoryWithArgument)BufferFactory.getInstance()));
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inStream});
        ModelManager modelManager = new ModelManager();
        modelManager.addModel("WidgetID", (Object)this.getProjectName());
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        engine.generate("CONFIGBase", (IModelProvider)modelManager, (OutputStream)byteOut);
        return byteOut;
    }

    protected File getTemplateRoot() {
        String samplesPath = InstallPathConfig.getSamplesPath(null, null);
        return new File(samplesPath, "web");
    }

    public void run(Executor executor, ExecutionContext context) throws Exception {
        block7: {
            try {
                this.fileHandler = context.getFileHandler();
                if (this.fileHandler == null) {
                    throw new IOException("File handler is not set.");
                }
                String tname = this.getTemplateName();
                String taddr = this.templateNameforAddress(tname);
                if (taddr == null) {
                    this.setResult(MessageFormat.format("failed\n[{0}] template is not supported", tname));
                    return;
                }
                String destDir = this.getDestDir();
                this.fileHandler.makeDirectory(destDir);
                File destFile = new File(destDir);
                File srcDir = new File(this.getTemplateRoot(), taddr);
                if (this.copyResourcesRecursively(destFile, srcDir)) {
                    ByteArrayOutputStream oStream = this.createConfigXML();
                    File configxml = new File(String.valueOf(destDir) + "/" + "config.xml");
                    FileOutputStream foStream = new FileOutputStream(configxml);
                    try {
                        oStream.writeTo(foStream);
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{foStream});
                        throw throwable;
                    }
                    IOUtil.tryClose((Object[])new Object[]{foStream});
                    this.setResult("Success");
                    break block7;
                }
                this.setResult("Failed");
            }
            catch (Exception e) {
                this.setResult("failed\n" + e.getMessage());
                throw e;
            }
        }
    }

    public void undo(Executor executor, ExecutionContext context) throws Exception {
    }
}

