/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PlatformUI;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.tizen.common.project.util.Messages;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.common.ui.wizards.TizenCommonNewWizardPage;
import org.tizen.common.ui.wizards.TizenWizardProjectCheckViewer;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.SampleTemplateLoader;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizardOptionPage;
import org.tizen.web.project.wizard.ui.TizenWebPWComposite;

public class NewWebAppProjectWizardPage
extends TizenCommonNewWizardPage {
    private NewWebAppProjectWizardOptionPage optionPage;
    private boolean isValitaion = false;

    public NewWebAppProjectWizardPage(String pageName) {
        super(pageName);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public NewWebAppProjectWizardPage(String pageName, String appType) {
        super(pageName, appType);
        this.setNewProjectChecker(new TizenWizardProjectCheckViewer((TizenCommonNewWizardPage)this, this.getErrorReporter()));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Control[] controlArray = this.fComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control children = controlArray[n2];
            this.removeHelpListeners(children);
            ++n2;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tizen.ide.web.new_project_wizard_context");
    }

    protected Category createTemplateTabModel() {
        Category root = super.createTemplateTabModel();
        return root;
    }

    protected void buildTab(PWTab tab, final String name, Category category) {
        TizenWebPWComposite pwComposite = new TizenWebPWComposite(name, category, this){

            public Control createControl(Composite parent) {
                String helpContext = "User Template".equals(name) ? "org.tizen.ide.web.user_template_context" : "org.tizen.ide.web.new_project_wizard_context";
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)NewWebAppProjectWizardPage.this.getShell(), helpContext);
                return super.createControl(parent);
            }
        };
        tab.add((PWWidget)pwComposite);
    }

    private void removeHelpListeners(Control ctrl) {
        Listener[] listenerArray = ctrl.getListeners(28);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener instanceof TypedListener && ((TypedListener)listener).getEventListener() instanceof HelpListener) {
                ctrl.removeHelpListener((HelpListener)((TypedListener)listener).getEventListener());
            }
            ++n2;
        }
    }

    public ProjectTemplate getSelectedTemplate() {
        return (ProjectTemplate)((Object)this.fSelectedTemplate);
    }

    public void setSelectedTemplate(Object selectedTemplate) {
        super.setSelectedTemplate(selectedTemplate);
    }

    public boolean isExistProject() {
        return ProjectValidationUtil.isExistProject((String)this.getProjectName(), (URI)this.getLocationURI());
    }

    public String getLocationPathString() {
        return new File(this.getLocationURI()).getPath();
    }

    public boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        if (!ProjectValidationUtil.isValidNameForAppID((String)this.getProjectName())) {
            this.setErrorMessage(Messages.ValidationUtil_InvalidProjectName);
            return false;
        }
        this.isValitaion = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        if (!this.isValitaion) {
            return false;
        }
        if (this.getSelectedTemplate() == null || !this.getSelectedTemplate().isHasOption()) {
            return false;
        }
        SampleTemplateLoader sampletemplateLoader = SampleTemplateLoader.getInstance();
        sampletemplateLoader.addTemplateDefinition(this.getSelectedTemplate());
        if (this.getSelectedTemplate() == null) {
            return false;
        }
        Options templateOptions = this.getSelectedTemplate().getTemplateOptions();
        if (templateOptions == null) {
            return false;
        }
        this.getOptionPage().createOptionControl(this.getSelectedTemplate());
        List optionGroup = templateOptions.getOptionGroup();
        if (optionGroup.isEmpty()) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public NewWebAppProjectWizardOptionPage getOptionPage() {
        return this.optionPage;
    }

    public void setOptionPage(NewWebAppProjectWizardOptionPage optionPage) {
        this.optionPage = optionPage;
    }

    public void setVisible(boolean visible) {
        this.fComposite.setVisible(visible);
    }

    public TizenWizardProjectCheckViewer.IErrorMessageReporter getErrorReporter() {
        return new TizenWizardProjectCheckViewer.IErrorMessageReporter(){

            public void reportError(String errorMessage, boolean infoOnly) {
                boolean valid;
                if (infoOnly) {
                    NewWebAppProjectWizardPage.this.setMessage(errorMessage, 1);
                    NewWebAppProjectWizardPage.this.setErrorMessage(null);
                } else {
                    NewWebAppProjectWizardPage.this.setErrorMessage(errorMessage);
                }
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = NewWebAppProjectWizardPage.this.validatePage();
                }
                NewWebAppProjectWizardPage.this.setPageComplete(valid);
            }
        };
    }
}

