/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.notification;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.tizen.web.zimlaunch.notification.ProcessConsoleStream;

public class ProcessConsoleSpy
extends ProcessConsole {
    public ProcessConsoleSpy(IProcess process, IConsoleColorProvider colorProvider) {
        super(process, colorProvider);
    }

    public void setName(String name) {
        super.setName(name);
    }

    protected String computeName() {
        IProcess process = this.getProcess();
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        String label = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
        if (label == null) {
            if (config == null) {
                label = process.getLabel();
            } else if (DebugUITools.isPrivate((ILaunchConfiguration)config)) {
                label = process.getLabel();
            } else {
                String type = null;
                try {
                    type = config.getType().getName();
                }
                catch (CoreException coreException) {}
                StringBuffer buffer = new StringBuffer();
                buffer.append(config.getName());
                if (type != null) {
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
                buffer.append(process.getLabel());
                label = buffer.toString();
            }
        }
        if (process.isTerminated()) {
            return MessageFormat.format(ConsoleMessages.ProcessConsole_0, label);
        }
        return label;
    }

    public ProcessConsoleStream newProcessConsoleOutputStream() {
        IOConsoleOutputStream stream = super.newOutputStream();
        ProcessConsoleStream pstream = new ProcessConsoleStream(stream, this);
        return pstream;
    }
}

