/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.sdb.command.PackageInfoCommand;
import org.tizen.common.sdb.command.UnInstallCommand;
import org.tizen.common.sdb.command.message.CommandErrorException;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.ShellCommandUnresponsiveException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class UnInstallStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(UnInstallStep.class);
    public static final String name = Messages.UNINSTALL_PACKAGE;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected boolean isInstalled;
    protected int percent;

    public UnInstallStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        String msg;
        UnInstallCommand command;
        UserLogger.start((String)"web.launch", (String)".uninstall");
        this.preExecuteStep(ctx);
        if (!this.isInstalled) {
            this.notifier.notifyContents(Messages.getSuccessMessage((String)Messages.UNINSTALL_PACKAGE), this.getWorkCount(100));
            UserLogger.end((String)".uninstall");
            return;
        }
        int timeout = this.launcher.getTimeout() * 1000;
        String failMessage = Messages.getFailMessage((String)name);
        try {
            command = new UnInstallCommand(this.launcher.getDevice(), this.resource.getAppinfo().getAppPackageID(), "WGT".toLowerCase(), (ITizenConsoleManager)TizenWebConsole.getInstance());
            command.execute();
        }
        catch (TimeoutException timeoutException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_SYNCSERVICE_CONNECTION_TIMEOUT));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(NLS.bind((String)Messages.SDB_TIMEOUT_EXCEPTION, (Object)timeout)), this.notifier);
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_REJECT));
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), this.notifier);
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_UNRESPONSE));
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), this.notifier);
        }
        catch (CommandErrorException commandErrorException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_ERROR));
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), this.notifier);
        }
        catch (IOException iOException) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_IO));
            msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), this.notifier);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            String msg2 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg2), this.notifier);
        }
        command = new PackageInfoCommand(this.launcher.getDevice(), (ITizenConsoleManager)TizenWebConsole.getInstance());
        if (command.isInstalled(this.resource.getAppinfo().getAppPackageID(), "wgt")) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_STEPUNINSTALL_FAIL;
            logger.error(this.makeErrorDescription(code));
            String msg3 = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + code.getDescription() + " " + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.UNINSTALL_PACKAGE), new TizenWebIDEException(msg3), new TizenWebNotifier[0]);
        }
        this.isInstalled = false;
        ctx.setValue((Object)"widget installation", (Object)this.isInstalled);
        this.notifier.notifyContents(NLS.bind((String)Messages.UNINSTALLED_PACKAGE, (Object)this.resource.getAppinfo().getAppID()), this.getWorkCount(100));
        UserLogger.end((String)"web.launch", (String)".uninstall");
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String failMessage = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        String msg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

