/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.ISdbCommandHelper;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;
import org.tizen.web.zimlaunch.exception.NoConnectedDeviceException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.Messages;
import org.tizen.web.zimlaunch.util.PortUtil;
import org.tizen.web.zimlaunch.util.WRTCommandUtil;

public class CommandLauncher
implements ISdbCommandHelper {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected StringBuffer result = null;
    protected IDevice device = null;
    protected int timeout = 300;

    public CommandLauncher() throws NoConnectedDeviceException {
        this(ConnectionPlugin.getDefault().getCurrentDevice());
    }

    public CommandLauncher(IDevice device) throws NoConnectedDeviceException {
        this(device, 300);
    }

    public CommandLauncher(IDevice device, int timeout) throws NoConnectedDeviceException {
        this.device = device != null ? device : ConnectionPlugin.getDefault().getCurrentDevice();
        this.timeout = Math.max(90, timeout);
    }

    protected void clearResult() {
        if (this.result == null) {
            this.result = new StringBuffer();
        } else {
            this.result.delete(0, this.result.capacity());
            this.result.setLength(0);
        }
    }

    protected MultiLineReceiver getReceiver() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String content = stringArray[n2];
                    CommandLauncher.this.result.append(String.valueOf(content) + System.getProperty("line.separator"));
                    ++n2;
                }
            }
        };
    }

    /*
     * Exception decompiling
     */
    public int runCommand(String cmd, boolean rCodeChk) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getAppInstallPath() {
        return this.device.getAppInstallPath();
    }

    protected String queryXwalkAppInfo(ZimLaunchResource resource, String projectName) throws Exception {
        String APP_ID = "Application ID";
        String xwalkAppID = "";
        int nAppID = 0;
        String cmd = this.getCommand("QUERY_COMMAND", resource);
        this.runCommand(cmd, false);
        String xwalkAppList = this.getResultString();
        String delim = System.getProperty("line.separator");
        String subdelim1 = "\\s{2,}";
        String subdelim2 = "\\t{1,}";
        String[] lines = StringUtil.split((String)xwalkAppList, (String)delim);
        String[] columns = lines[0].split(subdelim1);
        int nColumn = 0;
        while (nColumn < columns.length) {
            if (columns[nColumn].equals(APP_ID)) {
                nAppID = nColumn;
            }
            ++nColumn;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] appInfos;
            String line = stringArray[n2];
            String[] stringArray2 = appInfos = line.split(subdelim2);
            int n3 = appInfos.length;
            int n4 = 0;
            while (n4 < n3) {
                String appInfo = stringArray2[n4];
                if (projectName.equals(appInfo)) {
                    xwalkAppID = appInfos[nAppID];
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return xwalkAppID;
    }

    protected boolean checkWRTType(String wrtCommand) throws Exception {
        String cmd = "ls /usr/bin/" + wrtCommand + TizenWebLaunchConstants.WRT_CMD_RESULT_CHECK;
        int code = this.runCommand(cmd, true);
        return code == 0;
    }

    public boolean isInstalled(ZimLaunchResource resource) throws Exception {
        boolean isInstalled = false;
        if (this.checkWRTType("xwalk-launcher")) {
            String appID = this.queryXwalkAppInfo(resource, resource.getAppinfo().getAppPackageID());
            if (StringUtil.isEmpty((CharSequence)appID)) {
                return isInstalled;
            }
            resource.getAppinfo().setAppID(appID);
            isInstalled = true;
        } else if (this.checkWRTType("wrt-launcher") || this.checkWRTType("app_launcher")) {
            Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
            boolean sameOrBiggerThanVersion3 = version.isSameOrBiggerThanVersion3();
            String pkgId = sameOrBiggerThanVersion3 ? "'" + resource.getAppinfo().getAppID() + "'" : resource.getAppinfo().getAppPackageID();
            if (StringUtil.isEmpty((CharSequence)pkgId)) {
                return isInstalled;
            }
            String cmd = this.getCommand("QUERY_COMMAND", resource);
            if (sameOrBiggerThanVersion3) {
                cmd = cmd.replaceFirst("wrt-", "app_");
            }
            this.runCommand(cmd, false);
            String delim = String.valueOf(System.getProperty("line.separator")) + " ";
            String[] stringArray = StringUtil.split((String)this.getResultString(), (String)delim);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String widget = stringArray[n2];
                if (ObjectUtil.equals((Object)pkgId, (Object)widget)) {
                    isInstalled = true;
                    break;
                }
                ++n2;
            }
        }
        return isInstalled;
    }

    public boolean isRunningWidget(ZimLaunchResource resource) throws Exception {
        Object[] results;
        boolean isRunning = false;
        String appPkgId = resource.getAppinfo().getAppPackageID();
        if (StringUtil.isEmpty((CharSequence)appPkgId)) {
            return isRunning;
        }
        String cmd = String.valueOf(this.getCommand("RUN_CHECK_COMMAND", resource)) + ";echo $?";
        int code = this.runCommand(cmd, true);
        if (code == 0) {
            isRunning = true;
        }
        if (ArrayUtil.isEmpty((Object[])(results = this.getResultLineStrings()))) {
            return false;
        }
        Object[] objectArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            Object result = objectArray[n2];
            isRunning = ((String)result).endsWith("is Running");
            if (isRunning) break;
            ++n2;
        }
        if (code != 0) {
            isRunning = false;
        }
        return isRunning;
    }

    public boolean isLaunched() throws Exception {
        return this.isLaunched(false);
    }

    public boolean isLaunched(boolean isWebWidget) throws Exception {
        boolean isLaunched;
        block7: {
            String[] lines;
            block8: {
                isLaunched = false;
                lines = StringUtil.split((String)this.getResultString(), (String)"\r\n");
                if (!this.checkWRTType("xwalk-launcher")) break block8;
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.indexOf("Error") == -1) {
                        isLaunched = true;
                        break block7;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!this.checkWRTType("wrt-launcher") && !this.checkWRTType("app_launcher")) break block7;
            Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
            boolean sameOrBiggerThanVersion3 = version.isSameOrBiggerThanVersion3();
            String[] stringArray = lines;
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                String line = stringArray[n3];
                if (sameOrBiggerThanVersion3 || isWebWidget) {
                    if (line.startsWith("... successfully launched")) {
                        isLaunched = true;
                        break;
                    }
                } else if ("result: launched".equals(line)) {
                    isLaunched = true;
                    break;
                }
                ++n3;
            }
        }
        return isLaunched;
    }

    public int getRemotePort() {
        return this.getRemotePort(null);
    }

    public int getRemotePort(String result) {
        if (result == null) {
            result = this.getResultString();
        }
        String[] lines = StringUtil.split((String)result, (String)"\r\n");
        String port = "9222";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] contents = StringUtil.split((String)line, (String)" ");
            boolean isThisLine = false;
            String[] stringArray2 = contents;
            int n3 = contents.length;
            int n4 = 0;
            while (n4 < n3) {
                String content = stringArray2[n4];
                if ("port:".equals(content)) {
                    isThisLine = true;
                    break;
                }
                ++n4;
            }
            if (isThisLine) {
                port = contents[contents.length - 1];
                break;
            }
            ++n2;
        }
        return Integer.parseInt(StringUtil.getOnlyNumerics((String)port));
    }

    public void removeForward(String appID, int lport, int rport) throws Exception {
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)"remove port forward");
        int code = 0;
        try {
            this.device.removeForward(lport, rport);
        }
        catch (TimeoutException timeoutException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_TIMEOUT.getCode();
            TizenWebIDEException.abort(NLS.bind((String)Messages.SDB_TIMEOUT_EXCEPTION, (Object)this.timeout), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_REJECT.getCode();
            TizenWebIDEException.abort(Messages.STEP_SDB_SHELL_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        catch (IOException iOException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_IO.getCode();
            TizenWebIDEException.abort(Messages.STEP_SDB_SHELL_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        PortUtil.getInstance().removePortItem(this.device.getSerialNumber(), appID);
    }

    public void createForward(String appID, int lport, int rport) throws Exception {
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)"create port forward");
        int code = 0;
        try {
            this.device.createForward(lport, rport);
        }
        catch (TimeoutException timeoutException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_TIMEOUT.getCode();
            TizenWebIDEException.abort(NLS.bind((String)Messages.SDB_TIMEOUT_EXCEPTION, (Object)this.timeout), new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        catch (SdbCommandRejectedException sdbCommandRejectedException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_REJECT.getCode();
            TizenWebIDEException.abort(Messages.STEP_SDB_SHELL_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        catch (IOException iOException) {
            code = TizenWebIDEExceptionCode.SDB_EXEC_SHELL_CMD_IO.getCode();
            TizenWebIDEException.abort(Messages.STEP_SDB_SHELL_HANDLE_FAILED, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        PortUtil.getInstance().setPortItem(this.device.getSerialNumber(), appID, lport, rport);
    }

    public String getCommand(String key, ZimLaunchResource resource) throws Exception {
        return this.getCmdUtil().getCommand(key, resource);
    }

    public WRTCommandUtil getCmdUtil() {
        return WRTCommandUtil.getInstance();
    }

    public StringBuffer getResult() {
        return this.result;
    }

    public String getResultString() {
        return this.result.toString();
    }

    public String[] getResultLineStrings() {
        String strs = this.getResultString();
        if (StringUtil.isEmpty((CharSequence)strs)) {
            return null;
        }
        String[] str = StringUtil.split((String)strs, (String)System.getProperty("line.separator"));
        return str;
    }

    public String getResultLastLineString() {
        String[] str = this.getResultLineStrings();
        if (str == null) {
            return "";
        }
        return str[str.length - 1];
    }

    public void setResult(StringBuffer result) {
        if (result == null) {
            throw new NullPointerException();
        }
        this.result = result;
    }

    public void setResultString(String result) {
        this.result = new StringBuffer(result);
    }

    public IDevice getDevice() {
        return this.device;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = Math.max(90, timeout);
    }

    public void runCommand(String command, boolean rCode, String expectedResult) throws Exception {
        int code = this.runCommand(command, rCode);
        if (rCode && code != 0) {
            throw new Exception();
        }
    }

    public String getInspectorPath() {
        return this.getInspectorPath(null);
    }

    public String getInspectorPath(String result) {
        String[] lines;
        if (result == null) {
            result = this.getResultString();
        }
        String[] stringArray = lines = StringUtil.split((String)result, (String)"\r\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("inspector:")) {
                return line.substring("inspector:".length());
            }
            ++n2;
        }
        return "";
    }

    public String getCheckTempDirCommand(String dirCmdOutput) {
        return "mkdir -p " + dirCmdOutput + "; echo $?";
    }

    public String getCreateCmdOutputMessageFileDirCommand(String dirCmdOutput) {
        return "mkdir -p " + dirCmdOutput + TizenWebLaunchConstants.WRT_CMD_RESULT_CHECK;
    }
}

