/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.model.util.FileUtil;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.AbstractTemplateLoader;

public class UserTemplateLoader
extends AbstractTemplateLoader {
    private String userTemplateRootPath;
    private List<File> userTemplateList;

    @Override
    protected void initialize() {
        try {
            this.userTemplateRootPath = IDEPathUtil.getUserTemplatePath().toOSString();
            this.userTemplateList = FileUtil.getFileList((File)new File(this.userTemplateRootPath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warn(WizardMessages.bind((String)WizardMessages.FAIL_TO_LOAD_TEMPLATE_FILE, (Object)this.userTemplateRootPath));
        }
    }

    public Category makeUserTemplate(Category root) {
        this.removeChild(root, "User Template");
        Category userTemplateRoot = this.getGroup(root, "User Template", "usertemplate.png");
        Category userTemplateEntry = this.createEntry(userTemplateRoot, "UserDefined");
        if (this.userTemplateList != null) {
            for (File file : this.userTemplateList) {
                try {
                    TizenAppTemplate tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((File)file);
                    if (tizenAppTemplate == null) continue;
                    this.createProjectTemplate(userTemplateEntry, tizenAppTemplate);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Error", (Throwable)e);
                }
            }
        }
        return userTemplateRoot;
    }
}

