/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.progress.IProgressConstants2;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.common.CommonMessages;

public class CleanJob
extends WorkspaceJob {
    private IProject[] projects;

    public CleanJob() {
        super(CommonMessages.CLEANING_PROJECTS);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (this.projects == null) {
            return Status.CANCEL_STATUS;
        }
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void setProjects(IProject ... projects) {
        this.projects = projects;
    }

    public void run(IProject ... projects) {
        this.setUser(true);
        this.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, Boolean.TRUE);
        this.setProjects(projects);
        this.setRule(WorkspaceUtil.getWorkspace().getRuleFactory().buildRule());
        this.schedule();
    }
}

