/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.common.util.StringUtil;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.Preference;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.AbstractFormPage;
import org.tizen.web.editor.configuration.preference.PreferenceContentProvider;
import org.tizen.web.editor.configuration.preference.PreferenceEditingSupport;
import org.tizen.web.editor.configuration.preference.PreferenceLabelProvider;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class PreferencePage
extends AbstractFormPage {
    public static final String PreferencePage_ID = "Preferences";
    private ImageButton addButton;
    private ImageButton editButton;
    private ImageButton removeButton;
    private TableViewer viewer;
    private PreferenceEditingSupport nameEditingSupport;
    private PreferenceEditingSupport valueEditingSupport;
    private PreferenceEditingSupport readonlyEditingSupport;
    private AbstractChangeListener changeListener;
    private SelectionListener addBtnSelectionListener;
    private SelectionListener editBtnSelectionListener;
    private SelectionListener removeBtnSelectionListener;
    private ISelectionChangedListener viewerSelectionChangedListener;

    public PreferencePage(ConfigurationEditor editor) {
        super(editor, PreferencePage_ID, Messages.PreferencePage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.PreferencePage_ID, "icons/ConfigurationEditor/40_title_preferences.png");
        Composite page = this.createPage(this.body);
        Composite section = this.editorToolkit.createSection(page, Messages.PreferencePage_SectionLabel, Messages.PreferencePage_SectionDescription);
        this.createPreferenceContent(section);
        ((Section)section.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createPreferenceContent(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(1808));
        Composite preferenceComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        preferenceComposite.setLayout((Layout)grid);
        preferenceComposite.setLayoutData((Object)new GridData(768));
        Composite tableBtns = this.editorToolkit.createComposite(preferenceComposite);
        grid = new GridLayout(3, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        tableBtns.setLayout((Layout)grid);
        tableBtns.setLayoutData((Object)new GridData(3, 2, true, false));
        this.addButton = this.editorToolkit.createAddButton(tableBtns);
        this.editButton = this.editorToolkit.createEditButton(tableBtns);
        this.removeButton = this.editorToolkit.createRemoveButton(tableBtns);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.viewer = new TableViewer(base, 68352);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.heightHint = 248;
        table.setLayoutData((Object)data);
        TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText(Messages.PreferencePage_NameColumnLabel);
        nameColumn.getColumn().setToolTipText(Messages.PreferencePage_NameColumnTooltip);
        this.nameEditingSupport = new PreferenceEditingSupport((ColumnViewer)this.viewer, 0);
        nameColumn.setEditingSupport((EditingSupport)this.nameEditingSupport);
        TableViewerColumn valueColumn = new TableViewerColumn(this.viewer, 0);
        valueColumn.getColumn().setText(Messages.PreferencePage_ValueColumnLabel);
        valueColumn.getColumn().setToolTipText(Messages.PreferencePage_ValueColumnTooltip);
        this.valueEditingSupport = new PreferenceEditingSupport((ColumnViewer)this.viewer, 1);
        valueColumn.setEditingSupport((EditingSupport)this.valueEditingSupport);
        TableViewerColumn readonlyColumn = new TableViewerColumn(this.viewer, 0);
        readonlyColumn.getColumn().setText(Messages.PreferencePage_ReadOnlyColumnLabel);
        readonlyColumn.getColumn().setToolTipText(Messages.PreferencePage_ReadOnlyColumnTooltip);
        this.readonlyEditingSupport = new PreferenceEditingSupport((ColumnViewer)this.viewer, 2);
        readonlyColumn.setEditingSupport((EditingSupport)this.readonlyEditingSupport);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.viewer.getTable().setLayout((Layout)tableLayout);
        PreferenceContentProvider icp = new PreferenceContentProvider();
        PreferenceLabelProvider itlp = new PreferenceLabelProvider();
        this.viewer.setContentProvider((IContentProvider)icp);
        this.viewer.setLabelProvider((IBaseLabelProvider)itlp);
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        this.tizenConfig = config;
        this.removeListener();
        this.viewer.setInput((Object)this.tizenConfig);
        this.viewer.refresh();
        this.addListener();
    }

    @Override
    public void saveStatus(ITizenConfigurator config) {
        if (this.viewer.isCellEditorActive()) {
            this.viewer.applyEditorValue();
        }
        TableItem[] items = this.viewer.getTable().getItems();
        config.removeAllPreferences();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Preference preference;
            String name;
            TableItem ti = tableItemArray[n2];
            Object data = ti.getData();
            if (data instanceof Preference && !StringUtil.isEmpty((CharSequence)(name = (preference = (Preference)data).getName()))) {
                config.setPreference(name, preference.getValue(), DataBoolean.fromValue((String)preference.getReadonly()));
            }
            ++n2;
        }
        this.viewer.refresh();
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.changeListener != null) {
            this.nameEditingSupport.setListener(this.changeListener);
            this.valueEditingSupport.setListener(this.changeListener);
            this.readonlyEditingSupport.setListener(this.changeListener);
        }
        if (this.viewerSelectionChangedListener != null) {
            this.viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        }
    }

    @Override
    public void removeListener() {
        this.nameEditingSupport.unsetListener();
        this.valueEditingSupport.unsetListener();
        this.readonlyEditingSupport.unsetListener();
        this.viewer.removeSelectionChangedListener(this.viewerSelectionChangedListener);
    }

    @Override
    public void createListener() {
        if (this.changeListener == null) {
            this.changeListener = new AbstractChangeListener(){

                @Override
                public void notifyChange() {
                    PreferencePage.this.markDirty();
                }
            };
        }
        if (this.viewerSelectionChangedListener == null) {
            this.viewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        PreferencePage.this.editButton.setEnabled(true);
                        PreferencePage.this.removeButton.setEnabled(true);
                    } else {
                        PreferencePage.this.editButton.setEnabled(false);
                        PreferencePage.this.removeButton.setEnabled(false);
                    }
                }
            };
        }
        if (this.addBtnSelectionListener == null) {
            this.addBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Preference preference = new Preference();
                    preference.setName("");
                    preference.setValue("");
                    preference.setReadonly(DataBoolean.FALSE.value());
                    PreferencePage.this.viewer.add((Object)preference);
                    PreferencePage.this.changeListener.notifyChange();
                }
            };
            this.addButton.addSelectionListener(this.addBtnSelectionListener);
        }
        if (this.editBtnSelectionListener == null) {
            this.editBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencePage.this.viewer.editElement(PreferencePage.this.viewer.getElementAt(Math.max(0, PreferencePage.this.viewer.getTable().getSelectionIndex())), 0);
                }
            };
            this.editButton.addSelectionListener(this.editBtnSelectionListener);
        }
        if (this.removeBtnSelectionListener == null) {
            this.removeBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = PreferencePage.this.viewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Preference)) continue;
                            PreferencePage.this.viewer.remove(object);
                            PreferencePage.this.changeListener.notifyChange();
                        }
                    }
                }
            };
            this.removeButton.addSelectionListener(this.removeBtnSelectionListener);
        }
    }
}

