/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.tizen.web.zimlaunch.util.PortUtil;

public class DebugPortSettingStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(DebugPortSettingStep.class);
    public static final String name = Messages.STEP_DEBUG_PORT_SETTING;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected IDevice device;
    protected String appID;
    protected boolean isInstalled;
    protected int percent;

    public DebugPortSettingStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".debug.port.setting");
        this.preExecuteStep(ctx);
        int oldlport = PortUtil.getInstance().getLocalPort(this.device.getSerialNumber(), this.appID);
        int oldrport = PortUtil.getInstance().getRemotePort(this.device.getSerialNumber(), this.appID);
        if (oldlport > 0 && oldrport > 0) {
            this.launcher.removeForward(this.appID, oldlport, oldrport);
        }
        int rport = this.resource.getDeviceinfo().getRemotePort();
        int lport = LocalPortChecker.getAvailableLocalPort((int)1, (int)rport);
        this.launcher.createForward(this.appID, lport, rport);
        ctx.setValue((Object)"local port", (Object)lport);
        ctx.setValue((Object)"remote port", (Object)rport);
        this.notifier.notifyContents(NLS.bind((String)Messages.STEP_DEBUG_PORT_SETTING_FORWARDED, (Object)lport, (Object)rport), this.getWorkCount(100));
        UserLogger.end((String)"web.launch", (String)".debug.port.setting");
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.device = this.resource.getDeviceinfo().getDevice();
        this.appID = this.resource.getAppinfo().getAppID();
        this.work = 100;
        this.rwork = 100;
        this.percent = 30;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

