/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.tizen.common.util.ProjectUtil;

public class WebNature
implements IProjectNature {
    public static final String WEB_NATURE_ID = "org.tizen.web.project.builder.WebNature";
    private static final String XSD_VALIDATOR = "org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDDelegatingValidator";
    private static final String XML_VALIDATOR = "org.eclipse.wst.xml.core.internal.validation.eclipse.Validator";
    private IProject project;
    private static Map<String, String> buildArgs = new HashMap<String, String>();

    public void configure() throws CoreException {
        if (!this.getProject().isNatureEnabled("org.tizen.web.project.builder.WebWidgetNature")) {
            ProjectUtil.setBuildCommandWithArgument((IProject)this.getProject(), (String)"org.tizen.web.project.builder.WebBuilder", buildArgs, null);
        }
    }

    private void setValidationProperties() {
        Validator[] validators;
        ValidationFramework framework = ValidationFramework.getDefault();
        Validator[] validatorArray = validators = framework.getValidators();
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            String validatorClassname = v.getValidatorClassname();
            if (XML_VALIDATOR.equals(validatorClassname) || XSD_VALIDATOR.equals(validatorClassname)) {
                v.setBuildValidation(false);
                v.setManualValidation(false);
            }
            ++n2;
        }
        try {
            framework.saveValidators(validators);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        MutableProjectSettings settings = framework.getProjectSettings(this.getProject());
        settings.setOverride(true);
        framework.applyChanges(settings, true);
        framework.suspendAllValidation(false);
        framework.addValidationBuilder(this.getProject());
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addNature(IProject project, Map<String, String> newBuildArgs, IProgressMonitor monitor) throws CoreException {
        String[] natures;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!project.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.project", "Project does not exist. a nature cannot be added"));
        }
        IProjectDescription description = project.getDescription();
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(WEB_NATURE_ID)) {
                return;
            }
            ++n2;
        }
        if (!buildArgs.isEmpty()) {
            buildArgs.clear();
        }
        if (newBuildArgs != null) {
            buildArgs.putAll(newBuildArgs);
        }
        String[] newNatures = Arrays.copyOf(natures, natures.length + 1);
        newNatures[natures.length] = WEB_NATURE_ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }
}

