/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.AbstractTizenProject;
import org.tizen.common.ITizenProject;
import org.tizen.common.ITizenProjectAdapter;
import org.tizen.common.ITizenWebProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.util.Assert;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.ProjectUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TizenWebProject
extends AbstractTizenProject
implements ITizenProjectAdapter,
IAdaptable,
ITizenWebProject {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected IProject project;
    public static final String WEB_NATURE_ID = "org.tizen.web.project.builder.WebNature";

    public TizenWebProject() {
    }

    public TizenWebProject(IProject project) {
        Assert.notNull((Object)project);
        this.project = project;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    /*
     * Exception decompiling
     */
    protected ConfigurationParserHandler getParsedHandler() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getAppId() {
        ConfigurationParserHandler parserHandler = this.getParsedHandler();
        return parserHandler != null ? parserHandler.getAppId() : "";
    }

    public String getPackageId() {
        ConfigurationParserHandler parserHandler = this.getParsedHandler();
        return parserHandler != null ? parserHandler.getPkgId() : "";
    }

    public TizenProjectType getTizenProjectType() {
        if (!this.project.isOpen()) {
            return null;
        }
        try {
            IProjectNature nature = this.project.getNature("org.tizen.webuibuilder.nature");
            if (nature != null) {
                return TizenProjectType.TIZEN_WEB_UIBUILDER_APPLICATION;
            }
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (ProjectUtil.isTizenWebUIFWProject(this.project)) {
            return TizenProjectType.TIZEN_WEB_UIFW_APPLICATION;
        }
        if (ProjectUtil.isWebWidgetProject(this.project)) {
            return TizenProjectType.TIZEN_WEB_WIDGET_APPLICATION;
        }
        if (ProjectUtil.isWebProject(this.project)) {
            return TizenProjectType.TIZEN_WEB_APPLICATION;
        }
        return null;
    }

    protected IProject getProject() {
        return this.project;
    }

    public boolean canHandle(IProject project) {
        return org.tizen.common.util.ProjectUtil.isTizenWebProject((IProject)project);
    }

    public ITizenProject getTizenProject(IProject project) {
        this.project = project;
        return this;
    }

    public TizenPackageInfoStore getTizenPkgInfoStore() {
        IProject project = this.getProject();
        ArrayList<PackageResourceInfo> invisibleList = new ArrayList<PackageResourceInfo>();
        String[] stringArray = WebConstant.DEFAULT_EXCLUDING_RESOURCES;
        int n = WebConstant.DEFAULT_EXCLUDING_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultExclude = stringArray[n2];
            if (defaultExclude.endsWith("/*")) {
                invisibleList.add(new PackageResourceInfo(defaultExclude.substring(0, defaultExclude.indexOf("/*")), 2, 1, "", false));
            } else {
                invisibleList.add(new PackageResourceInfo(defaultExclude, 1, 1, "", false));
            }
            ++n2;
        }
        if (ProjectUtil.isTizenWebUIFWProject(project)) {
            invisibleList.add(new PackageResourceInfo("tizen-web-ui-fw", 2, 1, "", !ProjectUtil.isCheckedUsingTargetLibrary(project)));
        } else if (ProjectUtil.isTizenCowhideProject(project)) {
            invisibleList.add(new PackageResourceInfo("cowhide", 2, 1, "", !ProjectUtil.isCheckedUsingTargetLibrary(project)));
        }
        invisibleList.add(new PackageResourceInfo(String.valueOf(ProjectUtil.getPackageName(project)) + "." + "wgt", 1, 1, "", false));
        String filterRegex = this.getUIBuilderFilter(project);
        if (filterRegex != null) {
            invisibleList.add(new PackageResourceInfo(filterRegex, 1, 2, "", false));
        }
        ArrayList<PackageResourceInfo> pkgResInfo = new ArrayList<PackageResourceInfo>();
        pkgResInfo.add(new PackageResourceInfo("/", 2, 1, "", false));
        TizenPackageInfoStore tpis = new TizenPackageInfoStore(project, pkgResInfo, invisibleList);
        return tpis;
    }

    private String getUIBuilderFilter(IProject project) {
        Map buildCommandArgument = ProjectUtil.getBuildCommandArgument((IProject)project, (String)"org.tizen.web.project.builder.WebBuilder");
        if (buildCommandArgument != null && buildCommandArgument.containsKey("buildResourceFilter")) {
            return (String)buildCommandArgument.get("buildResourceFilter");
        }
        return null;
    }

    private class ConfigurationParserHandler
    extends DefaultHandler {
        private static final String APP_ELEMENT = "tizen:application";
        private static final String APP_ID_ATTRIBUTE = "id";
        private static final String PKG_ID_ATTRIBUTE = "package";
        protected String pkgID = null;
        protected String appID = null;

        private ConfigurationParserHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase(APP_ELEMENT)) {
                this.appID = attributes.getValue(APP_ID_ATTRIBUTE);
                this.pkgID = attributes.getValue(PKG_ID_ATTRIBUTE);
            }
            super.startElement(uri, localName, qName, attributes);
        }

        public String getPkgId() {
            return this.pkgID;
        }

        public String getAppId() {
            return this.appID;
        }
    }
}

