/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide.manager;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IDependency;
import org.tizen.common.builder.util.DependencyUtil;
import org.tizen.common.file.IResource;

public class BuildManager {
    protected static final Logger logger = LoggerFactory.getLogger(BuildManager.class);
    private static HashMap<String, IBuildDependency> dependency = new HashMap();

    private BuildManager() {
    }

    public static IBuildDependency getBuildDependency(String key, IBuildDependency buildDependency) {
        IBuildDependency dependency = BuildManager.dependency.get(key);
        if (dependency == null) {
            BuildManager.dependency.put(key, buildDependency);
            dependency = buildDependency;
        }
        return dependency;
    }

    public static IBuildDependency getBuildDependency(String key) {
        return dependency.get(key);
    }

    public static void removeDependencyTargets(String key, IResource ... resources) throws IOException {
        IBuildDependency buildDependency = BuildManager.getBuildDependency(key);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            DependencyUtil.removeDependencyTargets((IBuildDependency)buildDependency, (IResource)resource, (boolean)false);
            ++n2;
        }
    }

    public static HashSet<IResource> getBuiltResources(IBuildDependency buildDependency, IResource resource) {
        HashSet<IResource> builtResources = new HashSet<IResource>();
        Set dependencies = null;
        try {
            dependencies = buildDependency.edgesOf(resource);
        }
        catch (IllegalArgumentException e) {
            logger.debug("{} [{}]", (Object)e.getMessage(), (Object)resource.getPath());
            return null;
        }
        if (dependencies == null || dependencies.isEmpty()) {
            return builtResources;
        }
        for (IDependency dependency : dependencies) {
            HashSet<IResource> subBuiltResources;
            IResource targetResource = dependency.getTarget();
            if (targetResource == null) {
                builtResources.add(targetResource);
                continue;
            }
            if (targetResource.equals(resource) || (subBuiltResources = BuildManager.getBuiltResources(buildDependency, targetResource)).isEmpty()) continue;
            builtResources.addAll(subBuiltResources);
        }
        if (builtResources.isEmpty()) {
            builtResources.add(resource);
        }
        return builtResources;
    }

    public static HashSet<IResource> getRelatedResources(String key, IResource resource) {
        HashSet<IResource> relatedResources = new HashSet<IResource>();
        IBuildDependency buildDependency = BuildManager.getBuildDependency(key);
        if (buildDependency == null) {
            return relatedResources;
        }
        HashSet<IResource> builtResources = BuildManager.getBuiltResources(buildDependency, resource);
        if (builtResources == null) {
            return relatedResources;
        }
        for (IResource builtResource : builtResources) {
            Set dependencies;
            if (builtResource == null || (dependencies = buildDependency.edgesOf(builtResource)) == null) continue;
            for (IDependency dependency : dependencies) {
                if (!dependency.getSource().equals(resource)) continue;
            }
        }
        return relatedResources;
    }

    public static HashSet<IResource> getBuiltResources(String key, IResource resource) {
        return BuildManager.getBuiltResources(BuildManager.getBuildDependency(key), resource);
    }

    public static HashSet<IResource> getBuiltResources(IBuildDependency buildDependency, IResource ... resources) {
        HashSet<IResource> builtResources = new HashSet<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            HashSet<IResource> builts = BuildManager.getBuiltResources(buildDependency, resource);
            if (builts == null) {
                builtResources.add(resource);
            } else {
                builtResources.addAll(builts);
            }
            ++n2;
        }
        return builtResources;
    }
}

