/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.ide.ActionScript;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.sbilib.ide.ToolchainAction;
import org.tizen.sbilib.lib.CommandRunner;
import org.tizen.sbilib.lib.Log;

public class ActionRunner {
    private final String TEMP_SCRIPT_FILE_NAME = "action_script";
    private final String TEMP_SCRIPT_FILE_EXTENSION = ".tmp";
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    ToolchainAction action = null;
    Process process = null;
    boolean waitable = false;
    Toolchain toolchain = null;
    Log log = SBI.log;

    public ActionRunner(Toolchain t) {
        this.toolchain = t;
        if (t != null) {
            this.action = t.getDebugAction();
        }
    }

    public ActionRunner(Toolchain t, ToolchainAction tAction) {
        this.toolchain = t;
        this.action = tAction;
    }

    public void setAction(ToolchainAction tAction) {
        this.action = tAction;
    }

    public String getActionName() {
        return this.action.getActionName();
    }

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    public void setErrorStream(OutputStream stream) {
        this.errorStream = stream;
    }

    public Process execute(String workingDir) {
        return this.execute(workingDir, false);
    }

    public Process execute(String workingDir, boolean seperate) {
        if (this.action == null) {
            this.log.warn("Cannot execute action => " + this.action);
            return null;
        }
        Process proc = null;
        for (ActionScript aScript : this.action.getScriptActionList()) {
            proc = this.executeScript(aScript, workingDir, seperate);
        }
        return proc;
    }

    public ArrayList<String> getCommand() {
        ActionScript aScript = this.action.getScriptActionList().get(0);
        String script = aScript.getScriptList().get(0);
        File scriptFile = this.makeScriptFile(script);
        if (scriptFile == null) {
            this.log.error("Cannot execute script => \n" + script);
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(scriptFile.getAbsolutePath());
        for (String arg : aScript.getArguments()) {
            cmd.add(arg);
        }
        return cmd;
    }

    private Process executeScript(ActionScript aScript, String workingDir, boolean seperate) {
        Process proc = null;
        for (String script : aScript.getScriptList()) {
            File scriptFile = this.makeScriptFile(script);
            if (scriptFile == null) {
                this.log.error("Cannot execute script => \n" + script);
                return null;
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(scriptFile.getAbsolutePath());
            for (String arg : aScript.getArguments()) {
                if (seperate) {
                    String[] args;
                    for (String a : args = arg.split(" ")) {
                        cmd.add(a);
                    }
                    continue;
                }
                cmd.add(arg);
            }
            CommandRunner cRunner = new CommandRunner();
            try {
                proc = cRunner.execute(cmd, workingDir, null);
            }
            catch (IOException e) {
                this.log.exception(e);
                return null;
            }
            catch (InterruptedException e) {
                this.log.exception(e);
                return null;
            }
            if (proc == null) {
                return null;
            }
            try {
                if (!this.waitable || cRunner.waitFor() == 0) continue;
                this.log.error("Action script error. Exit value is " + cRunner.getExitValue());
            }
            catch (InterruptedException e) {
                this.log.exception(e);
            }
        }
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeScriptFile(String script) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("action_script", ".tmp");
        }
        catch (IOException e) {
            this.log.exception(e);
            return null;
        }
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(tmpFile);
            fWriter.write(script);
            fWriter.flush();
            fWriter.close();
        }
        catch (IOException e) {
            this.log.exception(e);
            File file = null;
            return file;
        }
        finally {
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (IOException e) {
                    this.log.exception(e);
                    return null;
                }
            }
        }
        tmpFile.setExecutable(true);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    private void printCommandOutput(CommandRunner cr) {
        this.print(cr.getInputStream(), this.outputStream);
        this.print(cr.getErrorStream(), this.errorStream);
    }

    private Thread print(final InputStream input, final OutputStream output) {
        Thread printThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        line = line + "\n";
                        if (ActionRunner.this.log != null) {
                            ActionRunner.this.log.info(line);
                        }
                        if (output == null) continue;
                        output.write(line.getBytes());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        printThread.start();
        return printThread;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setWaitable(boolean waitable) {
        this.waitable = waitable;
    }
}

