/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.PlatformTemplateLoader;
import org.tizen.common.ui.wizards.TizenTemplateException;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.ui.wizards.online.TizenWizardFileServiceImpl;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.project.wizard.model.AbstractTemplateLoader;
import org.tizen.web.project.wizard.model.ProjectTemplate;

public class SampleTemplateLoader
extends AbstractTemplateLoader {
    private static SampleTemplateLoader instance = new SampleTemplateLoader();

    @Override
    protected void initialize() {
    }

    public static SampleTemplateLoader getInstance() {
        return instance;
    }

    private File getSampleRoot(ProfileInfo profileInfo) {
        return new File(String.valueOf(InstallPathConfig.getSamplesPath((ProfileInfo)profileInfo, (String)profileInfo.getLatestPlatformVersion())) + File.separator + "web");
    }

    public void makeTemplate(Category rootGroup, Map<ProfileInfo, List<File>> platformTemplateMap) {
        if (rootGroup == null) {
            this.logger.warn("RootGroup is null");
            return;
        }
        for (ProfileInfo profileInfo : platformTemplateMap.keySet()) {
            for (File templateFile : platformTemplateMap.get(profileInfo)) {
                this.createModel(rootGroup, profileInfo, templateFile.toURI());
            }
        }
    }

    private ProjectTemplate createModel(Category rootGroup, ProfileInfo platformInfo, URI templateURI) {
        Category subCategory;
        URI rootURI = this.getSampleRoot(platformInfo).toURI();
        URI relativeURI = rootURI.relativize(templateURI);
        this.logger.trace("sampleRootUri: {}", (Object)rootURI);
        this.logger.trace("Relative path: {}", (Object)relativeURI.getPath());
        String[] segments = StringUtil.split((String)relativeURI.getPath(), (String)"/");
        PlatformTemplateLoader.mapToPlatformName((String[])segments, (ProfileInfo)platformInfo);
        int pathSize = segments.length;
        if (pathSize < 4) {
            this.logger.error("At least, template category depth is more than three: {}", (Object)templateURI.getPath());
            return null;
        }
        Category tabGroup = this.getGroup(rootGroup, segments[0], null);
        if (pathSize == 4) {
            subCategory = this.createEntry(tabGroup, segments[PlatformTemplateLoader.SEGMENT_TREE_ROOT]);
        } else {
            Category category = this.getGroup(tabGroup, segments[PlatformTemplateLoader.SEGMENT_TREE_ROOT]);
            subCategory = this.createEntry(category, segments[2]);
        }
        try {
            TizenAppTemplate tizenAppTemplate = this.unmarshalAppTemplate(templateURI.getPath());
            if (tizenAppTemplate != null) {
                return this.createProjectTemplate(subCategory, tizenAppTemplate, platformInfo);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Failed to read template xml", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public ProjectTemplate addTemplateDefinition(ProjectTemplate template) {
        InputStream inputStream;
        block11: {
            ProjectTemplate projectTemplate;
            block10: {
                block9: {
                    inputStream = null;
                    if (template != null) break block9;
                    IOUtil.tryClose((Object[])new Object[]{inputStream});
                    return null;
                }
                TizenWizardFileServiceImpl metaFileService = new TizenWizardFileServiceImpl();
                inputStream = metaFileService.getFileStream(template.getDefinitionPath());
                if (inputStream != null) break block10;
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                return null;
            }
            try {
                TizenAppTemplate tizenAppTemplate = this.unmarshalAppTemplate(inputStream);
                if (tizenAppTemplate == null) break block11;
                String widgetType = template.getProjectType();
                if (widgetType == null) {
                    this.logger.trace("Not matched WidgetType of project: {}", (Object)template.getProjectType());
                }
                File templateRootPath = new File(template.getDefinitionPath());
                template.setWidgetType(widgetType);
                template.setTemplateRoot(templateRootPath.getParent());
                template.setTemplateId(tizenAppTemplate.getTemplateId());
                template.setIcons(tizenAppTemplate.getIconList());
                template.setTemplateOptions(tizenAppTemplate.getOptions());
                template.setBuildProperties(tizenAppTemplate.getBuildProperty());
                template.setTemplateDefinition(true);
                projectTemplate = template;
            }
            catch (FileNotFoundException e) {
                this.logger.error("Failed to read template xml", (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{inputStream});
            }
            catch (TizenTemplateException e2) {
                this.logger.error("Failed to read template xml", (Object)e2.getMessage());
                {
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{inputStream});
                        throw throwable;
                    }
                }
                IOUtil.tryClose((Object[])new Object[]{inputStream});
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            return projectTemplate;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return null;
    }
}

