/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.web.apptemplate.model.LibraryElement;
import org.tizen.web.apptemplate.model.SupportLibraries;
import org.tizen.web.apptemplate.model.SupportLibrary;
import org.tizen.web.apptemplate.model.TizenTemplateLibraries;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.common.core.JAXBUtil;
import org.tizen.web.model.ITizenTemplateLibraries;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.model.impl.TizenTemplateLibrariesImpl;
import org.tizen.web.project.wizard.model.TizenTemplateLibraryGroup;

public class TizenTemplateLibrariesPool {
    private String builtInTemplateLibrariesRootPath;
    private List<TemplateLibraryInfo> templateLibrariesList = new ArrayList<TemplateLibraryInfo>();
    private List<TizenTemplateLibraryGroup> groupList = new ArrayList<TizenTemplateLibraryGroup>();
    protected static Logger logger = LoggerFactory.getLogger(TizenTemplateLibrariesPool.class);
    private static FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static FilenameFilter libraryXMLFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String s) {
            return "tizen-template-libraries.xml".equalsIgnoreCase(s);
        }
    };

    public TizenTemplateLibrariesPool(ProfileInfo profileInfo, String builtInTemplateLibrariesRootPath) {
        try {
            if (builtInTemplateLibrariesRootPath == null) {
                this.loadTemplateLibraries(IDEPathUtil.getBuiltInTemplateLibrariesPath());
            } else {
                this.loadTemplateLibraries(builtInTemplateLibrariesRootPath);
            }
            this.loadTemplateLibraries(IDEPathUtil.getWebUIFWTemplateLibrariesPath((ProfileInfo)profileInfo));
            this.loadDefaults();
        }
        catch (Exception e) {
            logger.error("Failed to load templates", (Throwable)e);
        }
    }

    public TizenTemplateLibrariesPool(ProfileInfo profileInfo) {
        this(profileInfo, null);
    }

    public String getBuiltInTemplateLibrariesRootPath() {
        return this.builtInTemplateLibrariesRootPath;
    }

    private void loadTemplateLibraries(String librariesRootPath) throws FileNotFoundException {
        File rootPath = new File(librariesRootPath);
        if (!rootPath.exists()) {
            logger.trace("The template library does not exist: {}", (Object)librariesRootPath);
            return;
        }
        File[] rootFiles = rootPath.listFiles(directoryFilter);
        if (rootFiles != null) {
            File[] fileArray = rootFiles;
            int n = rootFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File libraryDir = fileArray[n2];
                String path = libraryDir.getPath();
                File[] listFiles = libraryDir.listFiles(libraryXMLFilter);
                if (listFiles != null) {
                    File[] fileArray2 = listFiles;
                    int n3 = listFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File libraryFile = fileArray2[n4];
                        ITizenTemplateLibraries templateLibraries = TizenModelFactory.unmarshalTemplateLibraries((File)libraryFile);
                        if (templateLibraries != null) {
                            this.templateLibrariesList.add(new TemplateLibraryInfo(templateLibraries, path));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public void loadDefaults() {
        this.groupList.clear();
        for (TemplateLibraryInfo templateLibraries : this.templateLibrariesList) {
            String path = templateLibraries.getPath();
            try {
                TizenTemplateLibraries modelLibraries = templateLibraries.getTemplateLibrariesList().getModelLibraries();
                JAXBElement copiedElement = JAXBUtil.copyJAXBElement((Object)modelLibraries);
                TizenTemplateLibrariesImpl copiedTemplateLibraries = new TizenTemplateLibrariesImpl(copiedElement);
                for (LibraryElement library : copiedTemplateLibraries.getLibraries()) {
                    TizenTemplateLibraryGroup group = this.getLibraryGroup(library.getName());
                    if (group != null) {
                        group.addLibraryElement(library, path);
                        continue;
                    }
                    TizenTemplateLibraryGroup newGroup = new TizenTemplateLibraryGroup(this, library, path);
                    this.groupList.add(newGroup);
                }
            }
            catch (JAXBException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (TizenTemplateLibraryGroup group : this.groupList) {
            group.initializeDefaultSelected();
        }
    }

    public TizenTemplateLibraryGroup getLibraryGroup(String name) {
        for (TizenTemplateLibraryGroup group : this.groupList) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public List<TizenTemplateLibraryGroup> getLibraryGroupWithDepends(SupportLibraries libraries) {
        List<String> names = this.getSupportLibraryNames(libraries);
        return this.getLibraryGroupWithDepends(names);
    }

    public List<TizenTemplateLibraryGroup> getLibraryGroupWithDepends(List<String> names) {
        ArrayList<TizenTemplateLibraryGroup> resultList = new ArrayList<TizenTemplateLibraryGroup>();
        for (String name : names) {
            TizenTemplateLibraryGroup group = this.getLibraryGroup(name);
            this.getLibraryGroupWithDepends(group, resultList);
        }
        return resultList;
    }

    public List<TizenTemplateLibraryGroup> getLibraryGroupWithDepends(String name) {
        ArrayList<TizenTemplateLibraryGroup> resultList = new ArrayList<TizenTemplateLibraryGroup>();
        TizenTemplateLibraryGroup group = this.getLibraryGroup(name);
        this.getLibraryGroupWithDepends(group, resultList);
        return resultList;
    }

    private void getLibraryGroupWithDepends(TizenTemplateLibraryGroup group, List<TizenTemplateLibraryGroup> resultList) {
        if (group == null) {
            return;
        }
        if (!resultList.contains(group)) {
            resultList.add(group);
        }
        for (TizenTemplateLibraryGroup dependsGroup : group.getDependsGroup()) {
            this.getLibraryGroupWithDepends(dependsGroup, resultList);
        }
    }

    public List<String> getSupportLibraryNames(SupportLibraries libraries) {
        ArrayList<String> names = new ArrayList<String>();
        if (libraries != null) {
            for (SupportLibrary library : libraries.getLibrary()) {
                names.add(library.getName());
            }
        }
        return names;
    }

    class TemplateLibraryInfo {
        private ITizenTemplateLibraries templateLibrariesList;
        private String path;

        public TemplateLibraryInfo(ITizenTemplateLibraries templateLibrariesList, String path) {
            this.templateLibrariesList = templateLibrariesList;
            this.path = path;
        }

        public ITizenTemplateLibraries getTemplateLibrariesList() {
            return this.templateLibrariesList;
        }

        public String getPath() {
            return this.path;
        }
    }
}

