/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.wizards.TizenCommonWizard;
import org.tizen.common.ui.wizards.online.ITizenWizardFileService;
import org.tizen.common.ui.wizards.online.TizenWizardFileServiceImpl;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.model.ProjectTemplate;
import org.tizen.web.project.wizard.model.SampleTemplateLoader;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.operation.ContentAssistOperation;
import org.tizen.web.project.wizard.operation.DefaultNatureOperation;
import org.tizen.web.project.wizard.operation.IProjectTemplateOperation;
import org.tizen.web.project.wizard.operation.LibraryCopyOperation;
import org.tizen.web.project.wizard.operation.OptionProcessOperation;
import org.tizen.web.project.wizard.operation.ProjectCreateOperation;
import org.tizen.web.project.wizard.operation.TemplateCopyOperation;
import org.tizen.web.project.wizard.operation.TizenProjectDescriptOperation;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizardOptionPage;
import org.tizen.web.project.wizard.ui.NewWebAppProjectWizardPage;

public class NewWebAppProjectWizard
extends TizenCommonWizard {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private NewWebAppProjectWizardPage mainPage;
    private NewWebAppProjectWizardOptionPage optionPage;
    private ITizenWizardFileService metaFileService = new TizenWizardFileServiceImpl();
    private Collection<IProjectTemplateOperation> operations;
    private ProjectTemplate template;

    public NewWebAppProjectWizard() {
        this.setWindowTitle(WizardMessages.NewWizardTitle);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewWebAppProjectWizardPage(WizardMessages.NewWizardMainPageName, "web");
        this.mainPage.setTitle(WizardMessages.NewWizardMainPageTitle);
        this.mainPage.setDescription(WizardMessages.NewWizardMainPageDescription);
        this.addPage((IWizardPage)this.mainPage);
        this.optionPage = new NewWebAppProjectWizardOptionPage(WizardMessages.NewWizardOptionPageName);
        this.optionPage.setTitle(WizardMessages.NewWizardOptionPageTitle);
        this.optionPage.setDescription(WizardMessages.NewWizardOptionPageDescription);
        this.addPage((IWizardPage)this.optionPage);
        this.mainPage.setOptionPage(this.optionPage);
    }

    public boolean performFinish() {
        UserLogger.start((String)"web.wizard", (String)"web.wizard.finish");
        this.projectName = this.mainPage.getProjectName();
        if (this.projectName == null) {
            return false;
        }
        if (this.mainPage.isExistProject()) {
            String path = this.mainPage.getLocationPathString();
            String title = NLS.bind((String)WizardMessages.NewWizardExistProjectQuestionDialogTitle, (Object)this.projectName);
            String msg = NLS.bind((String)WizardMessages.NewWizardExistProjectQuestionDialogDescription, (Object)path);
            boolean isOK = MessageDialog.open((int)3, (Shell)SWTUtil.getActiveShell(), (String)title, (String)msg, (int)0);
            if (isOK) {
                FileUtil.recursiveDelete((File)new File(this.mainPage.getLocationURI()));
            } else {
                return false;
            }
        }
        this.operations = this.createOperationList();
        if (this.operations == null) {
            return false;
        }
        this.template = this.mainPage.getSelectedTemplate();
        if (this.template == null) {
            return false;
        }
        if (!this.template.isTemplateDefinition()) {
            SampleTemplateLoader sampletemplateLoader = SampleTemplateLoader.getInstance();
            sampletemplateLoader.addTemplateDefinition(this.template);
            this.template = this.mainPage.getSelectedTemplate();
            if (this.template == null) {
                return false;
            }
        }
        this.workingSets = this.mainPage.getSelectedWorkingSets();
        return super.performFinish();
    }

    protected WorkspaceJob createFinishJob() {
        return new WorkspaceJob("Creating web project"){

            /*
             * Exception decompiling
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 37[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    private void deleteProject(IProject project) {
        try {
            if (project != null && project.exists()) {
                project.delete(true, true, null);
            }
        }
        catch (CoreException e) {
            this.logger.error("Failed to delete a project", (Throwable)e);
        }
    }

    private Collection<IProjectTemplateOperation> createOperationList() {
        LinkedList<IProjectTemplateOperation> operations = new LinkedList<IProjectTemplateOperation>();
        URI locationURI = this.mainPage.useDefaults() ? null : this.mainPage.getLocationURI();
        TizenTemplateLibrariesPool librariesPool = new TizenTemplateLibrariesPool(this.mainPage.getSelectedTemplate().getProfileInfo());
        operations.add(new ProjectCreateOperation(locationURI));
        operations.add(new TemplateCopyOperation());
        LibraryCopyOperation libraryCopyOperation = new LibraryCopyOperation(librariesPool);
        operations.add(libraryCopyOperation);
        operations.add(new OptionProcessOperation(librariesPool));
        operations.add(new DefaultNatureOperation());
        operations.add(new TizenProjectDescriptOperation());
        operations.add(new ContentAssistOperation(libraryCopyOperation));
        return operations;
    }

    static /* synthetic */ String access$0(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.projectName;
    }

    static /* synthetic */ ITizenWizardFileService access$1(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.metaFileService;
    }

    static /* synthetic */ ProjectTemplate access$2(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.template;
    }

    static /* synthetic */ void access$3(NewWebAppProjectWizard newWebAppProjectWizard, IResource iResource) {
        newWebAppProjectWizard.selectAndReveal(iResource);
    }

    static /* synthetic */ IConfigurationElement access$4(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.fConfigElement;
    }

    static /* synthetic */ Collection access$5(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.operations;
    }

    static /* synthetic */ void access$6(NewWebAppProjectWizard newWebAppProjectWizard, IProject iProject) {
        newWebAppProjectWizard.deleteProject(iProject);
    }

    static /* synthetic */ NewWebAppProjectWizardOptionPage access$7(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.optionPage;
    }

    static /* synthetic */ IWorkingSet[] access$8(NewWebAppProjectWizard newWebAppProjectWizard) {
        return newWebAppProjectWizard.workingSets;
    }
}

