/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.tizen.common.AppIdGenerator;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Application;
import org.tizen.web.config.schema.model.LaunchmodeType;
import org.tizen.web.config.schema.model.Profile;
import org.tizen.web.config.schema.model.Service;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.W3CConfiguratorImpl;

public class TizenConfiguratorImpl
extends W3CConfiguratorImpl
implements ITizenConfigurator {
    @Override
    public Application getApplication() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Application)) continue;
            return (Application)element;
        }
        return null;
    }

    @Override
    public Profile getProfile() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Profile)) continue;
            return (Profile)element;
        }
        return null;
    }

    @Override
    public Service getService() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Service)) continue;
            return (Service)element;
        }
        return null;
    }

    @Override
    public void setApplication(String name, String appPackage, String requiredVersion) {
        Application application = this.getApplication();
        if (application == null) {
            application = new Application();
            this.addElement(application);
        }
        if (StringUtil.isEmpty((CharSequence)appPackage) || appPackage.length() != 10) {
            appPackage = AppIdGenerator.getInstance().create();
        }
        if (StringUtil.isEmpty((CharSequence)requiredVersion)) {
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
            if (tizenDesc != null) {
                requiredVersion = tizenDesc.getVersion();
            }
            boolean isRequiredVersion = false;
            String[] stringArray = WebConstant.REQUIRED_VERSIONS;
            int n = WebConstant.REQUIRED_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (requiredVersion.equalsIgnoreCase(version)) {
                    isRequiredVersion = true;
                    break;
                }
                ++n2;
            }
            if (!isRequiredVersion) {
                requiredVersion = WebConstant.REQUIRED_VERSIONS[0];
            }
        }
        if (StringUtil.isEmpty((CharSequence)name)) {
            application.setId(appPackage);
        } else {
            name = name.replaceAll("\\s", "");
            application.setId(String.valueOf(appPackage) + "." + name);
        }
        application.setPackage(appPackage);
        application.setRequiredVersion(requiredVersion);
    }

    @Override
    public void setApplicationAppID(String applicationAppID) {
        Application application = this.getApplication();
        if (application != null && !StringUtil.isEmpty((CharSequence)applicationAppID)) {
            application.setId(applicationAppID);
        }
    }

    @Override
    public String getApplicationAppID() {
        Application application = this.getApplication();
        if (application != null) {
            return application.getId();
        }
        return null;
    }

    @Override
    public void setApplicationPackage(String applicationPackage) {
        Application application = this.getApplication();
        if (application != null && !StringUtil.isEmpty((CharSequence)applicationPackage)) {
            application.setPackage(applicationPackage);
        }
    }

    @Override
    public String getApplicationPackage() {
        Application application = this.getApplication();
        if (application != null) {
            return application.getPackage();
        }
        return null;
    }

    @Override
    public void setApplicationRequiredVersion(String applicationRequiredVersion) {
        Application application = this.getApplication();
        if (application != null && !StringUtil.isEmpty((CharSequence)applicationRequiredVersion)) {
            application.setRequiredVersion(applicationRequiredVersion);
        }
    }

    @Override
    public String getApplicationRequiredVersion() {
        Application application = this.getApplication();
        if (application != null) {
            return application.getRequiredVersion();
        }
        String requiredVersion = "";
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (tizenDesc != null) {
            requiredVersion = tizenDesc.getVersion();
        }
        boolean isRequiredVersion = false;
        String[] stringArray = WebConstant.REQUIRED_VERSIONS;
        int n = WebConstant.REQUIRED_VERSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            if (requiredVersion.equalsIgnoreCase(version)) {
                isRequiredVersion = true;
                break;
            }
            ++n2;
        }
        if (!isRequiredVersion) {
            requiredVersion = WebConstant.REQUIRED_VERSIONS[0];
        }
        return requiredVersion;
    }

    @Override
    public void setProfileName(String profileName) {
        Profile profile = this.getProfile();
        if (profile == null) {
            profile = new Profile();
            this.addElement(profile);
        }
        profile.setName(profileName);
    }

    @Override
    public void setServiceID(String serviceID) {
        Service service = this.getService();
        if (service != null) {
            service.setId(serviceID);
        }
    }

    @Override
    public boolean supportsTizenControl() {
        return true;
    }

    @Override
    public void setApplicationLaunchMode(String launchMode) {
        Application application = this.getApplication();
        if (application != null) {
            LaunchmodeType value = null;
            try {
                value = LaunchmodeType.fromValue((String)launchMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            application.setLaunchMode(value);
        }
    }

    @Override
    public LaunchmodeType getApplicationLaunchMode() {
        Application application = this.getApplication();
        if (application != null) {
            return application.getLaunchMode();
        }
        return null;
    }
}

