/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.localization;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.editor.configuration.Messages;

public class LicenseDialog
extends LocaleDialog {
    protected String href;
    protected Text licenseURLText;

    public LicenseDialog(Shell parentShell, HashMap<String, String> locales) {
        super(parentShell, locales);
        this.setTitle(Messages.WidgetPage_LicenseGroupLabel);
    }

    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.langComboViewer.getSelection();
        if (!selection.isEmpty()) {
            this.lang = (String)selection.getFirstElement();
        }
        this.content = this.contentText.getText().trim();
        this.href = this.licenseURLText.getText().trim();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.contentLabel.setText(Messages.LocalizationPage_LicenseLabel);
        Label label = new Label(composite, 0);
        label.setText(Messages.LocalizationPage_LicenseURLLabel);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 105;
        label.setLayoutData((Object)data);
        this.licenseURLText = new Text(composite, 2048);
        data = new GridData(768);
        data.widthHint = 365;
        this.licenseURLText.setLayoutData((Object)data);
        this.licenseURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LicenseDialog.this.validate();
            }
        });
        if (!StringUtil.isEmpty((CharSequence)this.href)) {
            this.licenseURLText.setText(this.href);
        }
        this.validate();
        return composite;
    }

    protected void validate() {
        if (this.contentText == null) {
            return;
        }
        Status status = null;
        status = this.langComboViewer.getSelection() == null ? new Status(4, "org.tizen.web.editor.configuration", Messages.LocalizationPage_LicenseDialog_LicenseLangError) : (this.contentText.getText().trim().length() == 0 ? new Status(4, "org.tizen.web.editor.configuration", Messages.LocalizationPage_LicenseDialog_LicenseContentError) : (this.licenseURLText != null && !StringUtil.isEmpty((CharSequence)this.licenseURLText.getText()) && !ValidationUtil.checkForURL((String)this.licenseURLText.getText()) ? new Status(4, "org.tizen.web.editor.configuration", Messages.Validator_MalformedURL) : new Status(0, "org.tizen.web.editor.configuration", null)));
        this.updateStatus((IStatus)status);
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHref() {
        return this.href;
    }
}

