<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:tizen="http://tizen.org/ns/widgets" xmlns:widget="http://www.w3.org/ns/widgets">
	<xsl:output encoding="UTF-8" indent="yes" method="xml" />

	<xsl:variable name="PACKAGE_ID" select="/root/data/macro[@name='PACKAGE_ID']/@value" />
	<xsl:variable name="PROJECT_NAME" select="/root/data/macro[@name='PROJECT_NAME']/@value" />
	<xsl:variable name="PROFILE_NAME" select="/root/data/macro[@name='PROFILE_NAME']/@value" />
	<xsl:variable name="PROFILE_VER" select="/root/data/macro[@name='PROFILE_VER']/@value" />

	<xsl:template match="tizen:app-widget/@id" mode="replace">
		<xsl:attribute name="id">
			<xsl:variable name="USER_WIDGET_PROJECT_NAME" select="substring-after(substring-after(current(), '.'), '.')"/>
			<xsl:choose>
				<xsl:when test="$USER_WIDGET_PROJECT_NAME=''">
					<xsl:value-of select="concat($PACKAGE_ID,'.',$PROJECT_NAME,'.',$PROJECT_NAME)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($PACKAGE_ID,'.',$PROJECT_NAME,'.',$USER_WIDGET_PROJECT_NAME)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="tizen:application/@id" mode="replace">
		<xsl:attribute name="id">
			<xsl:value-of select="concat($PACKAGE_ID,'.',$PROJECT_NAME)" />
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="tizen:application/@package" mode="replace">
		<xsl:attribute name="package">
			<xsl:value-of select="$PACKAGE_ID" />
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="widget:widget/tizen:service/@id" mode="replace">
		<xsl:attribute name="id">
			<xsl:value-of select="concat($PACKAGE_ID,'.','Service')" />
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="widget:widget/widget:name" mode="out2">
		<xsl:copy>
			<xsl:value-of select="$PROJECT_NAME" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="widget:widget/tizen:profile" mode="out2">
		<xsl:copy>
		<xsl:attribute name="name">
			<xsl:value-of select="$PROFILE_NAME" />
		</xsl:attribute>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="@*" mode="replace">
		<xsl:copy />
	</xsl:template>

	<xsl:template match="@*" mode="out2">
		<xsl:apply-templates select="." mode="replace" />
	</xsl:template>

	<xsl:template match="*" mode="out2">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()" mode="out2" />
			<xsl:if test="local-name()='widget'">
				<xsl:if test="count(widget:name)=0">
					 <xsl:text>    </xsl:text><xsl:element name="{'name'}"><xsl:value-of select="$PROJECT_NAME"/></xsl:element><xsl:text>
</xsl:text>
				</xsl:if>
				<xsl:if test="count(tizen:profile)=0">
					 <xsl:text>    </xsl:text><xsl:element name="tizen:profile"><xsl:attribute name="name"><xsl:value-of select="$PROFILE_NAME"/></xsl:attribute></xsl:element>
				</xsl:if>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/root/manifest" mode="out">
		<xsl:apply-templates select="*" mode="out2" />
	</xsl:template>

	<xsl:template match="/">
		<xsl:text>
</xsl:text>
		<xsl:apply-templates select="/root/manifest" mode="out" />
	</xsl:template>
</xsl:stylesheet>

