/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck.model;

import java.util.ArrayList;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindError;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.memcheck.model.AuxErrorTreeElement;
import org.eclipse.linuxtools.valgrind.memcheck.model.ValgrindTreeElement;
import org.eclipse.swt.graphics.Image;

public class ErrorTreeElement
extends ValgrindTreeElement {
    protected ValgrindError error;

    public ErrorTreeElement(ValgrindTreeElement valgrindTreeElement, ValgrindError valgrindError) {
        this.parent = valgrindTreeElement;
        this.error = valgrindError;
        this.children = new ArrayList();
        ArrayList<ValgrindStackFrame> arrayList = valgrindError.getFrames();
        this.createStackElements(arrayList);
        String string = valgrindError.getAuxWhat();
        if (string != null) {
            this.children.add(new AuxErrorTreeElement(this, valgrindError));
        }
    }

    @Override
    public String getText() {
        return String.valueOf(this.error.getWhat()) + " [pid: " + this.error.getPid() + " / tid: " + this.error.getTid() + "]";
    }

    @Override
    public Image getImage() {
        return ERROR_IMG;
    }

    public String getKind() {
        return this.error.getKind();
    }

    public String getWhat() {
        return this.error.getWhat();
    }

    public String getPid() {
        return this.error.getPid();
    }

    public String getTid() {
        return this.error.getTid();
    }

    public String getFunction() {
        if (this.error.getFrames().size() != 0) {
            return this.error.getFrames().get(0).getFunc();
        }
        return null;
    }

    public String getAddress() {
        if (this.error.getFrames().size() != 0) {
            return this.error.getFrames().get(0).getPC().toUpperCase().replace("X", "x");
        }
        return null;
    }

    public String getLocation() {
        if (this.error.getFrames().size() != 0) {
            ValgrindStackFrame valgrindStackFrame = this.error.getFrames().get(0);
            if (valgrindStackFrame.getDir() == null || valgrindStackFrame.getFile() == null) {
                return valgrindStackFrame.getObj();
            }
            return String.valueOf(valgrindStackFrame.getFile()) + ":" + valgrindStackFrame.getLine();
        }
        return null;
    }
}

