/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.massif;

import org.eclipse.linuxtools.valgrind.massif.MassifHeapTreeNode;

public class MassifSnapshot {
    protected long number;
    protected long time;
    protected long heapBytes;
    protected long heapExtra;
    protected long stacks;
    protected String cmd;
    protected TimeUnit unit;
    protected SnapshotType type;
    protected MassifHeapTreeNode root;

    public MassifSnapshot(int n) {
        this.number = n;
    }

    public long getNumber() {
        return this.number;
    }

    public long getHeapBytes() {
        return this.heapBytes;
    }

    public long getHeapExtra() {
        return this.heapExtra;
    }

    public long getStacks() {
        return this.stacks;
    }

    public long getTime() {
        return this.time;
    }

    public long getTotal() {
        return this.heapBytes + this.heapExtra + this.stacks;
    }

    public SnapshotType getType() {
        return this.type;
    }

    public String getCmd() {
        return this.cmd;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public MassifHeapTreeNode getRoot() {
        return this.root;
    }

    public boolean isDetailed() {
        return !this.type.equals((Object)SnapshotType.EMPTY);
    }

    protected void setTime(long l) {
        this.time = l;
    }

    protected void setHeapBytes(long l) {
        this.heapBytes = l;
    }

    protected void setHeapExtra(long l) {
        this.heapExtra = l;
    }

    protected void setStacks(long l) {
        this.stacks = l;
    }

    protected void setType(SnapshotType snapshotType) {
        this.type = snapshotType;
    }

    protected void setCmd(String string) {
        this.cmd = string;
    }

    protected void setUnit(TimeUnit timeUnit) {
        this.unit = timeUnit;
    }

    protected void setRoot(MassifHeapTreeNode massifHeapTreeNode) {
        this.root = massifHeapTreeNode;
    }

    public static enum SnapshotType {
        EMPTY,
        DETAILED,
        PEAK;

    }

    public static enum TimeUnit {
        INSTRUCTIONS,
        MILLISECONDS,
        BYTES;

    }
}

