/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.launch;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IStepFilters;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.DebugOptions;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.core.LogicalStructureManager;
import org.eclipse.debug.internal.core.MemoryBlockManager;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.core.StepFilterManager;
import org.eclipse.debug.internal.core.commands.CommandAdapterFactory;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupUtils;
import org.eclipse.linuxtools.valgrind.launch.Messages;
import org.eclipse.linuxtools.valgrind.launch.ValgrindRuntimeProcess;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValgrindDebugPlugin
extends Plugin {
    private static final String PI_DEBUG_CORE = "org.eclipse.debug.core";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_TYPES = "launchConfigurationTypes";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_COMPARATORS = "launchConfigurationComparators";
    public static final String EXTENSION_POINT_BREAKPOINTS = "breakpoints";
    public static final String EXTENSION_POINT_STATUS_HANDLERS = "statusHandlers";
    public static final String EXTENSION_POINT_SOURCE_LOCATORS = "sourceLocators";
    public static final String EXTENSION_POINT_LAUNCH_MODES = "launchModes";
    public static final String EXTENSION_POINT_LAUNCH_DELEGATES = "launchDelegates";
    public static final String EXTENSION_POINT_PROCESS_FACTORIES = "processFactories";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_TYPES = "logicalStructureTypes";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_PROVIDERS = "logicalStructureProviders";
    public static final String EXTENSION_POINT_SOURCE_CONTAINER_TYPES = "sourceContainerTypes";
    public static final String EXTENSION_POINT_SOURCE_PATH_COMPUTERS = "sourcePathComputers";
    public static final String EXTENSION_POINT_LAUNCH_OPTIONS = "launchOptions";
    public static final String EXTENSION_POINT_BREAKPOINT_IMPORT_PARTICIPANTS = "breakpointImportParticipants";
    public static final int ERROR = 125;
    public static final int INTERNAL_ERROR = 120;
    public static final int ERR_WORKING_DIRECTORY_NOT_SUPPORTED = 115;
    public static final String ATTR_PROCESS_FACTORY_ID = "process_factory_id";
    public static final String ATTR_CAPTURE_OUTPUT = "org.eclipse.debug.core.capture_output";
    public static final String ATTR_LAUNCH_TIMESTAMP = "org.eclipse.debug.core.launch.timestamp";
    public static final String ATTR_CONSOLE_ENCODING = "org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING";
    public static final String PREF_DELETE_CONFIGS_ON_PROJECT_DELETE = String.valueOf(ValgrindDebugPlugin.getUniqueIdentifier()) + ".PREF_DELETE_CONFIGS_ON_PROJECT_DELETE";
    public static final String ATTR_BREAKPOINT_IS_DELETED = String.valueOf(ValgrindDebugPlugin.getUniqueIdentifier()) + ".breakpointIsDeleted";
    private static ValgrindDebugPlugin fgDebugPlugin = null;
    private BreakpointManager fBreakpointManager;
    private ExpressionManager fExpressionManager;
    private LaunchManager fLaunchManager;
    private MemoryBlockManager fMemoryBlockManager;
    private ListenerList fEventListeners = new ListenerList();
    private ListenerList fEventFilters = new ListenerList();
    private boolean fShuttingDown = false;
    private HashMap fStatusHandlers = null;
    private HashMap fProcessFactories = null;
    private static final int NOTIFY_FILTERS = 0;
    private static final int NOTIFY_EVENTS = 1;
    private List fEventQueue = new ArrayList();
    private EventDispatchJob fEventDispatchJob = new EventDispatchJob();

    public static ValgrindDebugPlugin getDefault() {
        return fgDebugPlugin;
    }

    private static void setDefault(ValgrindDebugPlugin valgrindDebugPlugin) {
        fgDebugPlugin = valgrindDebugPlugin;
    }

    public static String getUniqueIdentifier() {
        return PI_DEBUG_CORE;
    }

    public ValgrindDebugPlugin() {
        ValgrindDebugPlugin.setDefault(this);
    }

    public void addDebugEventListener(IDebugEventSetListener iDebugEventSetListener) {
        this.fEventListeners.add((Object)iDebugEventSetListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEventSet(DebugEvent[] debugEventArray) {
        if (this.isShuttingDown() || debugEventArray == null || this.fEventListeners.isEmpty()) {
            return;
        }
        List list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(debugEventArray);
        }
        this.fEventDispatchJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        List list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(runnable);
        }
        this.fEventDispatchJob.schedule();
    }

    public synchronized IBreakpointManager getBreakpointManager() {
        if (this.fBreakpointManager == null) {
            this.fBreakpointManager = new BreakpointManager();
        }
        return this.fBreakpointManager;
    }

    public synchronized ILaunchManager getLaunchManager() {
        if (this.fLaunchManager == null) {
            this.fLaunchManager = new LaunchManager();
        }
        return this.fLaunchManager;
    }

    public synchronized IMemoryBlockManager getMemoryBlockManager() {
        if (this.fMemoryBlockManager == null) {
            this.fMemoryBlockManager = new MemoryBlockManager();
        }
        return this.fMemoryBlockManager;
    }

    public IStatusHandler getStatusHandler(IStatus iStatus) {
        IConfigurationElement iConfigurationElement;
        if (Platform.getPreferencesService() == null) {
            return null;
        }
        boolean bl = Platform.getPreferencesService().getBoolean(ValgrindDebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, true, null);
        if (!bl) {
            return null;
        }
        StatusHandlerKey statusHandlerKey = new StatusHandlerKey(iStatus.getPlugin(), iStatus.getCode());
        if (this.fStatusHandlers == null) {
            this.initializeStatusHandlers();
        }
        if ((iConfigurationElement = (IConfigurationElement)this.fStatusHandlers.get(statusHandlerKey)) != null) {
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                if (object instanceof IStatusHandler) {
                    return (IStatusHandler)object;
                }
                if (iConfigurationElement.getDeclaringExtension() != null) {
                    this.invalidStatusHandler(null, MessageFormat.format("Registered status handler {0} does not implement required interface IStatusHandler.", iConfigurationElement.getDeclaringExtension().getUniqueIdentifier()));
                }
            }
            catch (CoreException coreException) {
                ValgrindDebugPlugin.log(coreException);
            }
        }
        return null;
    }

    public synchronized IExpressionManager getExpressionManager() {
        if (this.fExpressionManager == null) {
            this.fExpressionManager = new ExpressionManager();
        }
        return this.fExpressionManager;
    }

    public void removeDebugEventListener(IDebugEventSetListener iDebugEventSetListener) {
        this.fEventListeners.remove((Object)iDebugEventSetListener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.setShuttingDown(true);
            if (this.fLaunchManager != null) {
                this.fLaunchManager.shutdown();
            }
            if (this.fBreakpointManager != null) {
                this.fBreakpointManager.shutdown();
            }
            if (this.fMemoryBlockManager != null) {
                this.fMemoryBlockManager.shutdown();
            }
            this.fEventListeners.clear();
            this.fEventFilters.clear();
            SourceLookupUtils.shutdown();
            Preferences.savePreferences((String)ValgrindDebugPlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(ValgrindDebugPlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(bundleContext);
            ValgrindDebugPlugin.setDefault(null);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ResourcesPlugin.getWorkspace().addSaveParticipant(ValgrindDebugPlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void saving(ISaveContext iSaveContext) throws CoreException {
                if (ValgrindDebugPlugin.this.fExpressionManager != null) {
                    ValgrindDebugPlugin.this.fExpressionManager.storeWatchExpressions();
                }
                Preferences.savePreferences((String)ValgrindDebugPlugin.getUniqueIdentifier());
            }

            public void rollback(ISaveContext iSaveContext) {
            }

            public void prepareToSave(ISaveContext iSaveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext iSaveContext) {
            }
        });
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        CommandAdapterFactory commandAdapterFactory = new CommandAdapterFactory();
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IDisconnect.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IDropToFrame.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IStep.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IStepFilters.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, ISuspendResume.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, ITerminate.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, ILaunch.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IProcess.class);
        iAdapterManager.registerAdapters((IAdapterFactory)commandAdapterFactory, IDebugElement.class);
    }

    public static IProcess newProcess(ILaunch iLaunch, Process process, String string, String string2) {
        return ValgrindDebugPlugin.newProcess(iLaunch, process, string, string2, null);
    }

    public static IProcess newProcess(ILaunch iLaunch, Process process, String string, String string2, Map map) {
        ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
        String string3 = null;
        if (iLaunchConfiguration != null) {
            try {
                string3 = iLaunchConfiguration.getAttribute(ATTR_PROCESS_FACTORY_ID, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        if (string3 != null) {
            IConfigurationElement iConfigurationElement;
            ValgrindDebugPlugin valgrindDebugPlugin = ValgrindDebugPlugin.getDefault();
            if (valgrindDebugPlugin.fProcessFactories == null) {
                valgrindDebugPlugin.initializeProcessFactories();
            }
            if ((iConfigurationElement = (IConfigurationElement)valgrindDebugPlugin.fProcessFactories.get(string3)) == null) {
                return null;
            }
            IProcessFactory iProcessFactory = null;
            try {
                iProcessFactory = (IProcessFactory)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                ValgrindDebugPlugin.log(coreException);
                return null;
            }
            return iProcessFactory.newProcess(iLaunch, process, string, map);
        }
        ValgrindRuntimeProcess valgrindRuntimeProcess = new ValgrindRuntimeProcess(iLaunch, process, string, string2, map);
        valgrindRuntimeProcess.startProcessMonitorThread();
        return valgrindRuntimeProcess;
    }

    public static ILogicalStructureType[] getLogicalStructureTypes(IValue iValue) {
        return LogicalStructureManager.getDefault().getLogicalStructureTypes(iValue);
    }

    public static ILogicalStructureType getDefaultStructureType(ILogicalStructureType[] iLogicalStructureTypeArray) {
        return LogicalStructureManager.getDefault().getSelectedStructureType(iLogicalStructureTypeArray);
    }

    public static void setDefaultStructureType(ILogicalStructureType[] iLogicalStructureTypeArray, ILogicalStructureType iLogicalStructureType) {
        LogicalStructureManager.getDefault().setEnabledType(iLogicalStructureTypeArray, iLogicalStructureType);
    }

    public static Process exec(String[] stringArray, File file) throws CoreException {
        return ValgrindDebugPlugin.exec(stringArray, file, null);
    }

    public static Process exec(String[] stringArray, File file, String[] stringArray2) throws CoreException {
        Process process;
        block3: {
            process = null;
            try {
                process = file == null ? Runtime.getRuntime().exec(stringArray, stringArray2) : Runtime.getRuntime().exec(stringArray, stringArray2, file);
            }
            catch (IOException iOException) {
                Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_0, (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Object object;
                Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 115, DebugCoreMessages.DebugPlugin_Eclipse_runtime_does_not_support_working_directory_2, (Throwable)noSuchMethodError);
                IStatusHandler iStatusHandler = ValgrindDebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (iStatusHandler == null || !((object = iStatusHandler.handleStatus((IStatus)status, null)) instanceof Boolean) || !((Boolean)object).booleanValue()) break block3;
                process = ValgrindDebugPlugin.exec(stringArray, null);
            }
        }
        return process;
    }

    private boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean bl) {
        this.fShuttingDown = bl;
    }

    private Object[] getEventListeners() {
        return this.fEventListeners.getListeners();
    }

    public void addDebugEventFilter(IDebugEventFilter iDebugEventFilter) {
        this.fEventFilters.add((Object)iDebugEventFilter);
    }

    public void removeDebugEventFilter(IDebugEventFilter iDebugEventFilter) {
        this.fEventFilters.remove((Object)iDebugEventFilter);
    }

    public static void logDebugMessage(String string) {
        if (ValgrindDebugPlugin.getDefault().isDebugging()) {
            ValgrindDebugPlugin.log((IStatus)new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_2, string), null));
        }
    }

    public static void logMessage(String string, Throwable throwable) {
        ValgrindDebugPlugin.log((IStatus)new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, string, throwable));
    }

    public static void log(IStatus iStatus) {
        ValgrindDebugPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_3, throwable);
        ValgrindDebugPlugin.log((IStatus)status);
    }

    private void initializeStatusHandlers() {
        if (Platform.getExtensionRegistry() == null) {
            ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, Messages.getString((String)"ValgrindDebugPlugin.invalid_extension_registry"), null));
            this.fStatusHandlers = new HashMap();
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_STATUS_HANDLERS);
        if (iExtensionPoint == null) {
            ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, Messages.getString((String)"ValgrindDebugPlugin.invalid_extension_point"), null));
            this.fStatusHandlers = new HashMap();
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        this.fStatusHandlers = new HashMap(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string = iConfigurationElement.getAttribute("plugin");
            String string2 = iConfigurationElement.getAttribute("code");
            if (string != null && string2 != null) {
                try {
                    StatusHandlerKey statusHandlerKey = new StatusHandlerKey(string, Integer.parseInt(string2));
                    this.fStatusHandlers.put(statusHandlerKey, iConfigurationElement);
                }
                catch (NumberFormatException numberFormatException) {
                    this.invalidStatusHandler(numberFormatException, iConfigurationElement.getAttribute("id"));
                }
            } else {
                this.invalidStatusHandler(null, iConfigurationElement.getAttribute("id"));
            }
            ++n;
        }
    }

    private void initializeProcessFactories() {
        if (Platform.getExtensionRegistry() == null) {
            ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, Messages.getString((String)"ValgrindDebugPlugin.invalid_extension_registry"), null));
            this.fProcessFactories = new HashMap();
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_PROCESS_FACTORIES);
        if (iExtensionPoint == null) {
            ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, Messages.getString((String)"ValgrindDebugPlugin.invalid_extension_point"), null));
            this.fProcessFactories = new HashMap();
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        this.fProcessFactories = new HashMap(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string = iConfigurationElement.getAttribute("id");
            String string2 = iConfigurationElement.getAttribute("class");
            if (string != null && string2 != null) {
                this.fProcessFactories.put(string, iConfigurationElement);
            } else {
                String string3 = null;
                if (iConfigurationElementArray[n].getContributor() != null) {
                    string3 = iConfigurationElementArray[n].getContributor().getName();
                }
                ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_4, string3, string), null));
            }
            ++n;
        }
    }

    private void invalidStatusHandler(Exception exception, String string) {
        ValgrindDebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 125, MessageFormat.format(DebugCoreMessages.DebugPlugin_5, string), (Throwable)exception));
    }

    public static Document newDocument() throws CoreException {
        try {
            return LaunchManager.getDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ValgrindDebugPlugin.abort(Messages.getString((String)"ValgrindDebugPlugin.valgrind_error_message"), null);
            parserConfigurationException.printStackTrace();
            return null;
        }
    }

    public static String serializeDocument(Document document) throws CoreException {
        try {
            return LaunchManager.serializeDocument((Document)document);
        }
        catch (TransformerException transformerException) {
            ValgrindDebugPlugin.abort(Messages.getString((String)"ValgrindDebugPlugin.valgrind_error_message"), null);
            transformerException.printStackTrace();
        }
        catch (IOException iOException) {
            ValgrindDebugPlugin.abort(Messages.getString((String)"ValgrindDebugPlugin.valgrind_error_message"), null);
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Element parseDocument(String var0) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void abort(String string, Throwable throwable) throws CoreException {
        Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, string, throwable);
        throw new CoreException((IStatus)status);
    }

    public static String[] parseArguments(String string) {
        if (string == null) {
            return new String[0];
        }
        ArgumentParser argumentParser = new ArgumentParser(string);
        String[] stringArray = argumentParser.parseArguments();
        return stringArray;
    }

    public static void setUseStepFilters(boolean bl) {
        ValgrindDebugPlugin.getStepFilterManager().setUseStepFilters(bl);
    }

    public static boolean isUseStepFilters() {
        return ValgrindDebugPlugin.getStepFilterManager().isUseStepFilters();
    }

    private static StepFilterManager getStepFilterManager() {
        return ((LaunchManager)ValgrindDebugPlugin.getDefault().getLaunchManager()).getStepFilterManager();
    }

    public static Object getAdapter(Object object, Class clazz) {
        Object object2 = null;
        if (object != null) {
            if (clazz.isInstance(object)) {
                return object;
            }
            if (object instanceof IAdaptable) {
                object2 = ((IAdaptable)object).getAdapter(clazz);
            }
            if (object2 == null && !(object instanceof PlatformObject)) {
                object2 = Platform.getAdapterManager().getAdapter(object, clazz);
            }
            if (object2 == null) {
                object2 = Platform.getAdapterManager().loadAdapter(object, clazz.getName());
            }
        }
        return object2;
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String string) {
            this.fArgs = string;
        }

        public String[] parseArguments() {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.ch = this.getNext();
            while (this.ch > 0) {
                if (Character.isWhitespace((char)this.ch)) {
                    this.ch = this.getNext();
                    continue;
                }
                if (this.ch == 34) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(this.parseString());
                    if (((StringBuffer)object).length() == 0 && Platform.getOS().equals("win32")) {
                        ((StringBuffer)object).append("\"\"");
                    }
                    arrayList.add(((StringBuffer)object).toString());
                    continue;
                }
                arrayList.add(this.parseToken());
            }
            object = new String[arrayList.size()];
            arrayList.toArray((T[])object);
            return object;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            this.ch = this.getNext();
            if (this.ch == 34) {
                this.ch = this.getNext();
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        stringBuffer.append('\\');
                    } else if (Platform.getOS().equals("win32")) {
                        stringBuffer.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                stringBuffer.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return stringBuffer.toString();
        }

        private String parseToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (Character.isWhitespace((char)this.ch)) {
                        stringBuffer.append('\\');
                        return stringBuffer.toString();
                    }
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            stringBuffer.append('\\');
                        } else if (Platform.getOS().equals("win32")) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    stringBuffer.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    stringBuffer.append(this.parseString());
                    continue;
                }
                stringBuffer.append((char)this.ch);
                this.ch = this.getNext();
            }
            return stringBuffer.toString();
        }
    }

    static class AsynchRunner
    implements ISafeRunnable {
        private Runnable fRunnable = null;

        AsynchRunner() {
        }

        void async(Runnable runnable) {
            this.fRunnable = runnable;
            SafeRunner.run((ISafeRunnable)this);
            this.fRunnable = null;
        }

        public void handleException(Throwable throwable) {
            Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_6, throwable);
            ValgrindDebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fRunnable.run();
        }
    }

    class EventDispatchJob
    extends Job {
        EventNotifier fNotifier;
        AsynchRunner fRunner;

        public EventDispatchJob() {
            super(DebugCoreMessages.DebugPlugin_1);
            this.fNotifier = new EventNotifier();
            this.fRunner = new AsynchRunner();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            while (!ValgrindDebugPlugin.this.fEventQueue.isEmpty()) {
                Object var2_2 = null;
                List list = ValgrindDebugPlugin.this.fEventQueue;
                synchronized (list) {
                    if (!ValgrindDebugPlugin.this.fEventQueue.isEmpty()) {
                        var2_2 = ValgrindDebugPlugin.this.fEventQueue.remove(0);
                    }
                }
                if (var2_2 instanceof Runnable) {
                    this.fRunner.async(var2_2);
                    continue;
                }
                if (var2_2 == null) continue;
                this.fNotifier.dispatch(var2_2);
            }
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        public boolean shouldSchedule() {
            return !ValgrindDebugPlugin.this.isShuttingDown() && !ValgrindDebugPlugin.this.fEventListeners.isEmpty();
        }
    }

    class EventNotifier
    implements ISafeRunnable {
        private DebugEvent[] fEvents;
        private IDebugEventSetListener fListener;
        private IDebugEventFilter fFilter;
        private int fMode;

        EventNotifier() {
        }

        public void handleException(Throwable throwable) {
            switch (this.fMode) {
                case 0: {
                    Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_7, throwable);
                    ValgrindDebugPlugin.log((IStatus)status);
                    break;
                }
                case 1: {
                    Status status = new Status(4, ValgrindDebugPlugin.getUniqueIdentifier(), 125, DebugCoreMessages.DebugPlugin_8, throwable);
                    ValgrindDebugPlugin.log((IStatus)status);
                    break;
                }
            }
        }

        public void run() throws Exception {
            switch (this.fMode) {
                case 0: {
                    this.fEvents = this.fFilter.filterDebugEvents(this.fEvents);
                    break;
                }
                case 1: {
                    this.fListener.handleDebugEvents(this.fEvents);
                    break;
                }
            }
        }

        void dispatch(DebugEvent[] debugEventArray) {
            int n;
            this.fEvents = debugEventArray;
            Object[] objectArray = ValgrindDebugPlugin.this.fEventFilters.getListeners();
            if (objectArray.length > 0) {
                this.fMode = 0;
                int n2 = 0;
                while (n2 < objectArray.length) {
                    this.fFilter = (IDebugEventFilter)objectArray[n2];
                    SafeRunner.run((ISafeRunnable)this);
                    if (this.fEvents == null || this.fEvents.length == 0) {
                        return;
                    }
                    ++n2;
                }
            }
            this.fMode = 1;
            Object[] objectArray2 = ValgrindDebugPlugin.this.getEventListeners();
            if (DebugOptions.DEBUG_EVENTS) {
                n = 0;
                while (n < this.fEvents.length) {
                    System.out.println(this.fEvents[n]);
                    ++n;
                }
            }
            n = 0;
            while (n < objectArray2.length) {
                this.fListener = (IDebugEventSetListener)objectArray2[n];
                SafeRunner.run((ISafeRunnable)this);
                ++n;
            }
            this.fEvents = null;
            this.fFilter = null;
            this.fListener = null;
        }
    }

    static class StatusHandlerKey {
        String fPluginId;
        int fCode;

        StatusHandlerKey(String string, int n) {
            this.fPluginId = string;
            this.fCode = n;
        }

        public int hashCode() {
            return this.fPluginId.hashCode() + this.fCode;
        }

        public boolean equals(Object object) {
            if (object instanceof StatusHandlerKey) {
                StatusHandlerKey statusHandlerKey = (StatusHandlerKey)object;
                return this.fCode == statusHandlerKey.fCode && this.fPluginId.equals(statusHandlerKey.fPluginId);
            }
            return false;
        }
    }
}

