/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.memcheck.model;

import java.util.ArrayList;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.linuxtools.valgrind.memcheck.ValgrindStackFrame;
import org.eclipse.linuxtools.valgrind.memcheck.model.Messages;
import org.eclipse.linuxtools.valgrind.memcheck.model.ValgrindTreeElement;
import org.eclipse.swt.graphics.Image;

public class StackFrameTreeElement
extends ValgrindTreeElement {
    protected ValgrindStackFrame frame;
    protected boolean top;

    public StackFrameTreeElement(ValgrindTreeElement valgrindTreeElement, ValgrindStackFrame valgrindStackFrame, boolean bl) {
        this.parent = valgrindTreeElement;
        this.frame = valgrindStackFrame;
        this.top = bl;
        this.children = new ArrayList();
    }

    public StackFrameTreeElement(ValgrindTreeElement valgrindTreeElement, ValgrindStackFrame valgrindStackFrame) {
        this(valgrindTreeElement, valgrindStackFrame, false);
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.top ? Messages.getString("StackFrameTreeElement.at") : Messages.getString("StackFrameTreeElement.by"));
        stringBuffer.append(String.valueOf(this.frame.getPC()) + ": ");
        if (this.frame.getObj() != null) {
            if (this.frame.getFunc() != null) {
                stringBuffer.append(String.valueOf(this.frame.getFunc()) + " ");
            }
            stringBuffer.append("(");
            if (this.frame.getFile() != null) {
                stringBuffer.append(String.valueOf(this.frame.getFile()) + ":" + String.valueOf(this.frame.getLine()));
            } else {
                stringBuffer.append(String.valueOf(Messages.getString("StackFrameTreeElement.within")) + this.frame.getObj());
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append("***");
        }
        return stringBuffer.toString();
    }

    @Override
    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
    }

    public ValgrindStackFrame getFrame() {
        return this.frame;
    }
}

