/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.linuxtools.valgrind.core.Messages;
import org.eclipse.osgi.util.NLS;

public class ValgrindCommand {
    protected static final String WHICH_CMD = "which";
    protected static final String VALGRIND_CMD = "valgrind";
    public static final String OPT_TOOL = "--tool";
    public static final String OPT_XML = "--xml";
    public static final String OPT_LOGFILE = "--log-file";
    public static final String OPT_XMLFILE = "--xml-file";
    public static final String OPT_TRACECHILD = "--trace-children";
    public static final String OPT_CHILDSILENT = "--child-silent-after-fork";
    public static final String OPT_TRACKFDS = "--track-fds";
    public static final String OPT_TIMESTAMP = "--time-stamp";
    public static final String OPT_FREERES = "--run-libc-freeres";
    public static final String OPT_DEMANGLE = "--demangle";
    public static final String OPT_NUMCALLERS = "--num-callers";
    public static final String OPT_ERRLIMIT = "--error-limit";
    public static final String OPT_BELOWMAIN = "--show-below-main";
    public static final String OPT_MAXFRAME = "--max-stackframe";
    public static final String OPT_SUPPFILE = "--suppressions";
    public static final String PROFILE_SCRIPT = "profile";
    public static final String PROFILE_COMMAND = "/usr/bin/profile_command";
    protected File datadir;
    protected Process process;
    protected String[] args;

    public ValgrindCommand(File file) throws IOException {
        this.datadir = file;
    }

    public static String whichValgrind() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Process process = Runtime.getRuntime().exec("which valgrind");
        try {
            int n;
            boolean bl = process.waitFor() == 0;
            InputStream inputStream = bl ? process.getInputStream() : process.getErrorStream();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            if (!bl) {
                throw new IOException(stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return stringBuffer.toString().trim();
    }

    public void execute(String[] stringArray, String[] stringArray2, File file, boolean bl) throws IOException {
        this.args = stringArray;
        try {
            this.createDatadir();
            this.process = file == null ? ProcessFactory.getFactory().exec(stringArray, stringArray2) : (PTY.isSupported() && bl ? ProcessFactory.getFactory().exec(stringArray, stringArray2, file, new PTY()) : ProcessFactory.getFactory().exec(stringArray, stringArray2, file));
        }
        catch (IOException iOException) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw iOException;
        }
    }

    public File getDatadir() {
        return this.datadir;
    }

    protected void createDatadir() throws IOException {
        if (this.datadir.exists()) {
            this.deleteFiles();
        } else if (!this.datadir.mkdir()) {
            throw new IOException(NLS.bind((String)Messages.getString("ValgrindCommand.Couldnt_create"), (Object)this.datadir.getAbsolutePath()));
        }
    }

    protected void deleteFiles() throws IOException {
        if (this.datadir.listFiles() != null) {
            File[] fileArray = this.datadir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.delete()) {
                    throw new IOException(NLS.bind((String)Messages.getString("ValgrindCommand.Couldnt_delete"), (Object)file.getCanonicalPath()));
                }
                ++n2;
            }
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getCommandLine() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringBuffer.append(String.valueOf(string) + " ");
            ++n2;
        }
        return stringBuffer.toString().trim();
    }
}

