/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.Rotation3DImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.AxisImpl;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.DifferenceSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.StockSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;

public class InitialValueProvider {
    private static final ChartWithAxes defChartWithAxes = InitialValueProvider.createDefaultChartWithAxes();
    private static final TitleBlock defTitleBlock = InitialValueProvider.getTitleBlock(defChartWithAxes);
    private static final Plot defPlot = InitialValueProvider.getPlot(defChartWithAxes);
    private static final Legend defLegend = InitialValueProvider.getLegend(defChartWithAxes);
    private static final Series defSeries = SeriesImpl.createDefault();
    private static final GanttSeries defGanttSeries = (GanttSeries)GanttSeriesImpl.createDefault();
    private static final ScatterSeries defScatterSeries = (ScatterSeries)ScatterSeriesImpl.createDefault();
    private static final DialSeries defDialSeries = (DialSeries)DialSeriesImpl.createDefault();
    private static final PieSeries defPieSeries = (PieSeries)PieSeriesImpl.createDefault();
    private static final DifferenceSeries defDifferenceSeries = (DifferenceSeries)DifferenceSeriesImpl.createDefault();
    private static final StockSeries defStockSeries = (StockSeries)StockSeriesImpl.createDefault();
    private static final LineSeries defLineSeries = (LineSeries)LineSeriesImpl.createDefault();
    private static final AreaSeries defAreaSeries = (AreaSeries)AreaSeriesImpl.createDefault();
    private static final BarSeries defBarSeries = (BarSeries)BarSeriesImpl.createDefault();
    private static final BubbleSeries defBubbleSeries = (BubbleSeries)BubbleSeriesImpl.createDefault();
    private static final Axis defBaseAxis = (Axis)defChartWithAxes.getAxes().get(0);
    private static final Axis defOrthAxis = (Axis)defBaseAxis.getAssociatedAxes().get(0);
    private static final Axis defAncillaryAxis = (Axis)defBaseAxis.getAncillaryAxes().get(0);
    private static final Insets defLabelInsets = InsetsImpl.createDefault(0.0, 2.0, 0.0, 3.0);
    private static final Label defLabel = LabelImpl.createDefault();
    private static final DefSeriesDefinitionPool defSeriesDefinitions = new DefSeriesDefinitionPool();
    private static ChartWithoutAxes defChartWithoutAxes = InitialValueProvider.createDefaultChartWithoutAxes();
    private static DialChart defDialChart = InitialValueProvider.createDefaultDialChart();

    public static ChartWithAxes defChartWithAxes() {
        return defChartWithAxes;
    }

    public static ChartWithoutAxes defChartWithoutAxes() {
        return defChartWithoutAxes;
    }

    public static DialChart defDialChart() {
        return defDialChart;
    }

    public static TitleBlock defTitleBlock() {
        return defTitleBlock;
    }

    public static Plot defPlot() {
        return defPlot;
    }

    public static Legend defLegend() {
        return defLegend;
    }

    public static SeriesDefinition defSeriesDefinition(int id) {
        return defSeriesDefinitions.get(id);
    }

    public static Series defSeries() {
        return defSeries;
    }

    public static Axis defBaseAxis() {
        return defBaseAxis;
    }

    public static Axis defOrthogonalAxis() {
        return defOrthAxis;
    }

    public static Axis defAncillaryAxis() {
        return defAncillaryAxis;
    }

    public static GanttSeries defGanttSeries() {
        return defGanttSeries;
    }

    public static ScatterSeries defScatterSeries() {
        return defScatterSeries;
    }

    public static DialSeries defDialSeries() {
        return defDialSeries;
    }

    public static PieSeries defPieSeries() {
        return defPieSeries;
    }

    public static DifferenceSeries defDifferenceSeries() {
        return defDifferenceSeries;
    }

    public static StockSeries defStockSeries() {
        return defStockSeries;
    }

    public static LineSeries defLineSeries() {
        return defLineSeries;
    }

    public static AreaSeries defAreaSeries() {
        return defAreaSeries;
    }

    public static BarSeries defBarSeries() {
        return defBarSeries;
    }

    public static BubbleSeries defBubbleSeries() {
        return defBubbleSeries;
    }

    private static ChartWithAxes createDefaultChartWithAxes() {
        ChartWithAxes newChart = ChartWithAxesImpl.createDefault();
        Axis axBase = (Axis)newChart.getAxes().get(0);
        try {
            ChartElementUtil.setDefaultValue(axBase, "categoryAxis", true);
        }
        catch (ChartException chartException) {}
        axBase.getSeriesDefinitions().add((Object)InitialValueProvider.createDefaultSeriesDefinition(0));
        axBase.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        Axis axOrth = (Axis)axBase.getAssociatedAxes().get(0);
        axOrth.getSeriesDefinitions().add((Object)InitialValueProvider.createDefaultSeriesDefinition(0));
        axOrth.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        InitialValueProvider.createDefaultAncillaryAxis(newChart);
        return newChart;
    }

    private static Axis createDefaultAncillaryAxis(ChartWithAxes chart) {
        chart.setRotation(Rotation3DImpl.createDefault(new Angle3D[]{Angle3DImpl.createDefault(-20.0, 45.0, 0.0)}));
        try {
            chart.setUnitSpacing(50.0);
            Axis zAxisAncillary = AxisImpl.createDefault(3);
            ChartElementUtil.setDefaultValue(zAxisAncillary, "titlePosition", (Object)Position.BELOW_LITERAL);
            zAxisAncillary.getTitle().getCaption().setValue(Messages.getString("ChartWithAxesImpl.Z_Axis.title"));
            ChartElementUtil.setDefaultValue(zAxisAncillary.getTitle(), "visible", false);
            ChartElementUtil.setDefaultValue(zAxisAncillary, "primaryAxis", true);
            ChartElementUtil.setDefaultValue(zAxisAncillary, "labelPosition", (Object)Position.BELOW_LITERAL);
            ChartElementUtil.setDefaultValue(zAxisAncillary, "orientation", (Object)Orientation.HORIZONTAL_LITERAL);
            ChartElementUtil.setDefaultValue(zAxisAncillary.getOrigin(), "type", (Object)IntersectionType.MIN_LITERAL);
            zAxisAncillary.getOrigin().setValue(NumberDataElementImpl.create(0.0));
            ChartElementUtil.setDefaultValue(zAxisAncillary, "type", (Object)AxisType.TEXT_LITERAL);
            chart.getPrimaryBaseAxes()[0].getAncillaryAxes().add((Object)zAxisAncillary);
            SeriesDefinition sdZ = SeriesDefinitionImpl.createDefault();
            sdZ.getSeriesPalette().shift(0);
            sdZ.getSeries().add((Object)SeriesImpl.createDefault());
            zAxisAncillary.getSeriesDefinitions().add((Object)sdZ);
            return zAxisAncillary;
        }
        catch (ChartException chartException) {
            return null;
        }
    }

    public static Insets defLabelInsets() {
        return defLabelInsets;
    }

    public static Label defLabel() {
        return defLabel;
    }

    private static ChartWithoutAxes createDefaultChartWithoutAxes() {
        ChartWithoutAxes newChart = ChartWithoutAxesImpl.createDefault();
        newChart.setSubType("Standard");
        SeriesDefinition sdX = InitialValueProvider.createDefaultSeriesDefinition(0);
        sdX.getQuery().setDefinition("Base Series");
        SeriesDefinition sdY = InitialValueProvider.createDefaultSeriesDefinition(0);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        return newChart;
    }

    private static DialChart createDefaultDialChart() {
        DialChart newChart = (DialChart)DialChartImpl.createDefault();
        newChart.setSubType("Standard Meter Chart");
        newChart.setUnits("Points");
        newChart.setDialSuperimposition(false);
        newChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        SeriesDefinition sdX = InitialValueProvider.createDefaultSeriesDefinition(0);
        sdX.getQuery().setDefinition("Base Series");
        SeriesDefinition sdY = InitialValueProvider.createDefaultSeriesDefinition(0);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        return newChart;
    }

    private static TitleBlock getTitleBlock(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof TitleBlock)) continue;
            return (TitleBlock)b;
        }
        return null;
    }

    private static Plot getPlot(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof Plot)) continue;
            return (Plot)b;
        }
        return null;
    }

    private static Legend getLegend(Chart chart) {
        for (Block b : chart.getBlock().getChildren()) {
            if (!(b instanceof Legend)) continue;
            return (Legend)b;
        }
        return null;
    }

    protected static SeriesDefinition createDefaultSeriesDefinition(int paletteShift) {
        SeriesDefinition sd = SeriesDefinitionImpl.createDefault();
        sd.getSeries().add((Object)SeriesImpl.createDefault());
        return sd;
    }

    private static class DefSeriesDefinitionPool {
        private int size = 8;
        private SeriesDefinition[] pool = new SeriesDefinition[]{InitialValueProvider.createDefaultSeriesDefinition(0), InitialValueProvider.createDefaultSeriesDefinition(-1), InitialValueProvider.createDefaultSeriesDefinition(-2), InitialValueProvider.createDefaultSeriesDefinition(-3), InitialValueProvider.createDefaultSeriesDefinition(-4), InitialValueProvider.createDefaultSeriesDefinition(-5), InitialValueProvider.createDefaultSeriesDefinition(-6), InitialValueProvider.createDefaultSeriesDefinition(-7)};

        private DefSeriesDefinitionPool() {
        }

        public SeriesDefinition get(int id) {
            if (id >= this.size) {
                int sizeNew = (id / 4 + 1) * 4;
                SeriesDefinition[] poolNew = new SeriesDefinition[sizeNew];
                System.arraycopy(this.pool, 0, poolNew, 0, this.size);
                int i = this.size;
                while (i < sizeNew) {
                    poolNew[i] = InitialValueProvider.createDefaultSeriesDefinition(-i);
                    ++i;
                }
                this.pool = poolNew;
                this.size = sizeNew;
            }
            return this.pool[id];
        }
    }
}

