/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.hover;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNamedNodeMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.html.core.internal.document.DocumentStyleImpl;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.Activator;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.html.hover.ui.CSSRuleInfo;
import org.tizen.web.editor.html.hover.ui.HTMLEditorBrowserInformationControlInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class HTMLMarkupTagInfoProvider
extends MarkupTagInfoProvider
implements HTMLAdvancedFeatureConstants {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFile excludedFolderFile = null;
    private boolean isSameFile = false;

    public Object getInfo(IDOMNode xmlnode, IStructuredDocumentRegion flatNode, CMNode parentOrOwner, CMNode cmnode, String attName, String attrValue) {
        Object information = null;
        if (cmnode == null) {
            return information;
        }
        HTMLAdvancedFeatureConstants.HTMLTagAttribute htmlTagAttribute = HTMLAdvancedFeatureConstants.HTMLTagAttribute.getHTMLTagAttribute(attName);
        if (htmlTagAttribute == null || attrValue == null) {
            return information;
        }
        switch (htmlTagAttribute) {
            case HREF: {
                if (attrValue.trim().startsWith("\"#")) {
                    information = this.makeIdHoverInformation(xmlnode, attrValue);
                    if (information != null) break;
                    information = this.defaultHoverInformation(cmnode);
                    break;
                }
            }
            case SRC: {
                information = this.makeLinkedResourceHoverInformation(xmlnode, flatNode, parentOrOwner, attrValue);
                if (information != null) break;
                information = this.defaultHoverInformation(cmnode);
                break;
            }
            case CLASS: 
            case ID: {
                information = this.makeSelectorHoverInformation(xmlnode, attrValue);
                if (information != null) break;
                information = this.defaultHoverInformation(cmnode);
                break;
            }
            default: {
                information = this.defaultHoverInformation(cmnode);
            }
        }
        return information;
    }

    private Object makeIdHoverInformation(IDOMNode xmlnode, String attrValue) {
        HTMLEditorBrowserInformationControlInput information = new HTMLEditorBrowserInformationControlInput(null);
        ElementStyleImpl hoveredRegionElement = (ElementStyleImpl)xmlnode;
        Document ownerDocument = hoveredRegionElement.getOwnerDocument();
        if (attrValue.startsWith("\"")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
        }
        HTMLEditor htmlEditor = (HTMLEditor)SWTUtil.getActiveEditor();
        List<Node> findElementHasIdAttribute = this.findElementHasIdAttribute(ownerDocument);
        for (Node node : findElementHasIdAttribute) {
            String idValue = ((ElementStyleImpl)node).getAttribute("id");
            if (!idValue.equals(attrValue.substring(1))) continue;
            try {
                IStructuredDocumentRegion startStructuredDocumentRegion = ((ElementStyleImpl)node).getStartStructuredDocumentRegion();
                int start = startStructuredDocumentRegion.getStart();
                IDocument document = htmlEditor.getDocumentProvider().getDocument((Object)htmlEditor.getEditorInput());
                int lineOfOffset = document.getLineOfOffset(start);
                String hoverInfo = startStructuredDocumentRegion.getFullText();
                hoverInfo = hoverInfo.replaceAll("<", "&lt;");
                hoverInfo = hoverInfo.replaceAll(">", "&gt;");
                hoverInfo = String.valueOf(hoverInfo) + " - " + "line : " + (lineOfOffset + 1);
                hoverInfo = "<pre>" + hoverInfo + "</pre>";
                information.setHtml(hoverInfo);
                information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.NONE);
            }
            catch (BadLocationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (information.getHtml() == null || information.getHtml().equals("")) {
            information = null;
        }
        return information;
    }

    private List<Node> findElementHasIdAttribute(Document document) {
        ArrayList<Node> hasIdAttributeElement = new ArrayList<Node>();
        NodeList childNodes = document.getChildNodes();
        if (childNodes.getLength() > 0) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item instanceof ElementStyleImpl) {
                    this.findElementHasIdAttribute(item, hasIdAttributeElement);
                }
                ++i;
            }
        }
        return hasIdAttributeElement;
    }

    private List<Node> findElementHasIdAttribute(Node node, List<Node> hasIdAttributeElement) {
        if (node instanceof ElementStyleImpl) {
            String attribute;
            NodeList childNodes = node.getChildNodes();
            if (childNodes.getLength() > 0) {
                int i = 0;
                while (i < childNodes.getLength()) {
                    this.findElementHasIdAttribute(childNodes.item(i), hasIdAttributeElement);
                    ++i;
                }
            }
            if ((attribute = ((ElementStyleImpl)node).getAttribute("id")) != null && !attribute.trim().equals("")) {
                hasIdAttributeElement.add(node);
            }
        }
        return hasIdAttributeElement;
    }

    private String defaultHoverInformation(CMNode cmnode) {
        StringBuffer sb = new StringBuffer();
        this.printTagInfo(sb, cmnode);
        if (sb.length() == 0) {
            this.printDescription(sb, cmnode);
        }
        if (sb.length() == 0) {
            this.printDefaultInfo(cmnode, sb);
        }
        return sb.toString();
    }

    private Object makeLinkedResourceHoverInformation(IDOMNode xmlnode, IStructuredDocumentRegion flatNode, CMNode parentOrOwner, String attrValue) {
        HTMLEditorBrowserInformationControlInput information = new HTMLEditorBrowserInformationControlInput(null);
        String tagName = parentOrOwner.getNodeName();
        String nodeFullText = flatNode.getText();
        HTMLAdvancedFeatureConstants.HTMLTag htmlTag = HTMLAdvancedFeatureConstants.HTMLTag.getHTMLTag(tagName.toLowerCase());
        if (htmlTag == null) {
            return null;
        }
        if (attrValue.startsWith("\"") && (attrValue = attrValue.substring(1, attrValue.length() - 1)).startsWith("./")) {
            attrValue = attrValue.substring(2);
        }
        if (attrValue.toLowerCase().contains("http")) {
            return null;
        }
        IEditorPart activeEditor = SWTUtil.getActiveEditor();
        IEditorInput editorInput = activeEditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String workspacePath = workspace.getRoot().getLocation().toString();
            IFile currentEditingIFile = ((IFileEditorInput)editorInput).getFile();
            IProject project = currentEditingIFile.getProject();
            WebResourceManager resourceManager = new WebResourceManager(project, currentEditingIFile);
            resourceManager.makeProjectManagedResourceMap();
            String fileExtension = attrValue.substring(attrValue.lastIndexOf(".") + 1, attrValue.length());
            IFile linkedFile = resourceManager.getFile(attrValue, fileExtension);
            if (linkedFile == null) {
                return this.getInformationForExcludedFile(xmlnode, nodeFullText, currentEditingIFile, information, attrValue, workspacePath, htmlTag);
            }
            information.setLinkedResource(linkedFile);
            String filePath = String.valueOf(workspacePath) + linkedFile.getFullPath();
            switch (htmlTag) {
                case A: 
                case IFRAME: {
                    information.setHtml(this.readFile(filePath));
                    information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.HTML);
                    information.setDomNode(xmlnode);
                    break;
                }
                case LINK: {
                    information.setHtml(this.readFile(filePath));
                    information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.CSS);
                    information.setDomNode(xmlnode);
                    break;
                }
                case SCRIPT: {
                    information.setHtml(this.readFile(filePath));
                    information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.JS);
                    information.setDomNode(xmlnode);
                    break;
                }
                case IMG: {
                    information.setHtml(nodeFullText.replace(attrValue, filePath));
                    information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.IMAGE);
                    information.setDomNode(xmlnode);
                    break;
                }
            }
        }
        return information;
    }

    private Object getInformationForExcludedFile(IDOMNode xmlnode, String nodeFullText, final IFile currentEditingIFile, Object information, String attrValue, String workspacePath, HTMLAdvancedFeatureConstants.HTMLTag htmlTag) {
        try {
            final String orginAttrValue = attrValue;
            if (attrValue.startsWith("../")) {
                int lastIndexOf = attrValue.lastIndexOf("../");
                attrValue = attrValue.substring(lastIndexOf + 3);
            }
            this.excludedFolderFile = null;
            this.isSameFile = false;
            final String findFilePath = attrValue;
            currentEditingIFile.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String resourcePath;
                    if (resource instanceof IFile && (resourcePath = resource.getFullPath().toString()).contains(findFilePath)) {
                        HTMLMarkupTagInfoProvider.this.excludedFolderFile = (IFile)resource;
                        HTMLMarkupTagInfoProvider.this.isSameFile = HTMLMarkupTagInfoProvider.this.isSameRelativePath(currentEditingIFile, HTMLMarkupTagInfoProvider.this.excludedFolderFile, orginAttrValue);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.excludedFolderFile == null || !this.isSameFile) {
            return null;
        }
        String absolutePath = String.valueOf(workspacePath) + this.excludedFolderFile.getFullPath().toString();
        File file = new File(absolutePath);
        if (file.exists()) {
            switch (htmlTag) {
                case A: 
                case IFRAME: {
                    ((HTMLEditorBrowserInformationControlInput)information).setHtml(this.readFile(absolutePath));
                    ((HTMLEditorBrowserInformationControlInput)information).setInputType(HTMLEditorBrowserInformationControlInput.InputType.HTML);
                    ((HTMLEditorBrowserInformationControlInput)information).setDomNode(xmlnode);
                    ((HTMLEditorBrowserInformationControlInput)information).setLinkedResource(this.excludedFolderFile);
                    break;
                }
                case LINK: {
                    ((HTMLEditorBrowserInformationControlInput)information).setHtml(this.readFile(absolutePath));
                    ((HTMLEditorBrowserInformationControlInput)information).setInputType(HTMLEditorBrowserInformationControlInput.InputType.CSS);
                    ((HTMLEditorBrowserInformationControlInput)information).setDomNode(xmlnode);
                    ((HTMLEditorBrowserInformationControlInput)information).setLinkedResource(this.excludedFolderFile);
                    break;
                }
                case SCRIPT: {
                    ((HTMLEditorBrowserInformationControlInput)information).setHtml(this.readFile(absolutePath));
                    ((HTMLEditorBrowserInformationControlInput)information).setInputType(HTMLEditorBrowserInformationControlInput.InputType.JS);
                    ((HTMLEditorBrowserInformationControlInput)information).setDomNode(xmlnode);
                    ((HTMLEditorBrowserInformationControlInput)information).setLinkedResource(this.excludedFolderFile);
                    break;
                }
                case IMG: {
                    ((HTMLEditorBrowserInformationControlInput)information).setHtml(nodeFullText.replace(attrValue, absolutePath));
                    ((HTMLEditorBrowserInformationControlInput)information).setInputType(HTMLEditorBrowserInformationControlInput.InputType.IMAGE);
                    ((HTMLEditorBrowserInformationControlInput)information).setDomNode(xmlnode);
                    break;
                }
            }
        } else {
            return null;
        }
        return information;
    }

    private boolean isSameRelativePath(IFile sourceFile, IFile targetFile, String compareTargetFilePath) {
        boolean isSame = false;
        String sourceFilePath = sourceFile.getFullPath().toString();
        sourceFilePath = sourceFilePath.substring(sourceFile.getProject().getName().length() + 2);
        String targetFilePath = targetFile.getFullPath().toString();
        targetFilePath = targetFilePath.substring(targetFile.getProject().getName().length() + 2);
        if ((targetFilePath = FilenameUtil.getRelativePath((String)sourceFilePath, (String)targetFilePath)).startsWith("../")) {
            targetFilePath = targetFilePath.substring(3);
        }
        if (targetFilePath.equals(compareTargetFilePath)) {
            isSame = true;
        }
        return isSame;
    }

    private Object makeSelectorHoverInformation(IDOMNode xmlnode, String attrValue) {
        HTMLEditorBrowserInformationControlInput information = new HTMLEditorBrowserInformationControlInput(null);
        information.setInputType(HTMLEditorBrowserInformationControlInput.InputType.CSS);
        boolean bFirst = true;
        String compareCurrentAttrValue = attrValue.substring(1, attrValue.length() - 1);
        if (compareCurrentAttrValue.equals("")) {
            return null;
        }
        Document ownerDocument = xmlnode.getOwnerDocument();
        StyleSheetList styleSheets = ((DocumentStyleImpl)ownerDocument).getStyleSheets();
        if (styleSheets != null) {
            int numerOfStyleSheet = styleSheets.getLength();
            int j = 0;
            while (j < numerOfStyleSheet) {
                String filePath;
                StyleSheet styleSheet = styleSheets.item(j);
                if (styleSheet != null && (filePath = styleSheet.getHref()) != null && !filePath.trim().equals("")) {
                    int lastIndexOfFileSeparator = filePath.lastIndexOf("/");
                    filePath = filePath.substring(lastIndexOfFileSeparator + 1);
                    CSSNodeImpl css = (CSSNodeImpl)styleSheet;
                    IStructuredDocument document = ((ICSSDocument)css).getModel().getStructuredDocument();
                    ICSSNodeList childNodes = css.getChildNodes();
                    int numberOfChildNode = childNodes.getLength();
                    int index = 0;
                    while (index < numberOfChildNode) {
                        String selectorName;
                        CSSNodeImpl cssNode = (CSSNodeImpl)childNodes.item(index);
                        ICSSNamedNodeMap map = cssNode.getAttributes();
                        ICSSAttr attr = (ICSSAttr)map.item(0);
                        if (attr != null && (selectorName = attr.getValue()) != null && !selectorName.trim().equals("")) {
                            StringTokenizer selectorNameTokenizer = new StringTokenizer(selectorName);
                            while (selectorNameTokenizer.hasMoreTokens()) {
                                String[] splitedSelectorTokens;
                                String selectorToken = selectorNameTokenizer.nextToken();
                                String[] stringArray = splitedSelectorTokens = selectorToken.split(",");
                                int n = splitedSelectorTokens.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    URIResolver resolver;
                                    ICSSModel model;
                                    String fileName;
                                    String[] path;
                                    CSSRuleInfo cssRuleInfo;
                                    String html;
                                    String advancedInfo;
                                    int length;
                                    int offset;
                                    CSSNodeImpl ownerCSSNode;
                                    String commaSeperatedSelector = stringArray[n2];
                                    if (commaSeperatedSelector.equals("#" + compareCurrentAttrValue)) {
                                        ownerCSSNode = (CSSNodeImpl)attr.getOwnerCSSNode();
                                        offset = ownerCSSNode.getStartOffset();
                                        length = ownerCSSNode.getEndOffset() - offset;
                                        try {
                                            advancedInfo = document.get(offset, length);
                                            if (bFirst) {
                                                html = "<pre>" + advancedInfo + "</pre>";
                                                information.setHtml(html);
                                                bFirst = false;
                                            }
                                            cssRuleInfo = new CSSRuleInfo();
                                            cssRuleInfo.setCssRule(advancedInfo);
                                            cssRuleInfo.setOffset(offset);
                                            cssRuleInfo.setLength(length);
                                            cssRuleInfo.setFindSelectorName(commaSeperatedSelector);
                                            path = filePath.split("/");
                                            fileName = path[path.length - 1];
                                            cssRuleInfo.setCssRuleInfo(fileName);
                                            model = ((ICSSDocument)css).getModel();
                                            resolver = model.getResolver();
                                            cssRuleInfo.setCSSFilePath(resolver.getFileBaseLocation());
                                            information.addCssRuleInfo(cssRuleInfo);
                                        }
                                        catch (BadLocationException e) {
                                            this.logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    } else if (commaSeperatedSelector.equals("." + compareCurrentAttrValue)) {
                                        ownerCSSNode = (CSSNodeImpl)attr.getOwnerCSSNode();
                                        offset = ownerCSSNode.getStartOffset();
                                        length = ownerCSSNode.getEndOffset() - offset;
                                        try {
                                            advancedInfo = document.get(offset, length);
                                            if (bFirst) {
                                                html = "<pre>" + advancedInfo + "</pre>";
                                                information.setHtml(html);
                                                bFirst = false;
                                            }
                                            cssRuleInfo = new CSSRuleInfo();
                                            cssRuleInfo.setCssRule(advancedInfo);
                                            cssRuleInfo.setOffset(offset);
                                            cssRuleInfo.setLength(length);
                                            cssRuleInfo.setFindSelectorName(commaSeperatedSelector);
                                            path = filePath.split("/");
                                            fileName = path[path.length - 1];
                                            cssRuleInfo.setCssRuleInfo(fileName);
                                            model = ((ICSSDocument)css).getModel();
                                            resolver = model.getResolver();
                                            cssRuleInfo.setCSSFilePath(resolver.getFileBaseLocation());
                                            information.addCssRuleInfo(cssRuleInfo);
                                        }
                                        catch (BadLocationException e) {
                                            this.logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        ++index;
                    }
                }
                ++j;
            }
        }
        if (information.getHtml() == null) {
            information = null;
        }
        return information;
    }

    private boolean isNotSupportedPreviewFile(String filePath) {
        boolean isNotSupported = false;
        IPreferenceStore commonEditorPreferenceStore = Activator.getCommonEditorPreferenceStore();
        String excludedFolders = commonEditorPreferenceStore.getString("org.tizen.web.editor.EDITOR_ADVANCED_FEATURE_EXCLUDED_FOLDER_STORE_KEY");
        if (!excludedFolders.equals("")) {
            String[] splitedExcludeFolders;
            String[] stringArray = splitedExcludeFolders = excludedFolders.split(",");
            int n = splitedExcludeFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String folder = stringArray[n2];
                if (filePath.contains(folder)) {
                    isNotSupported = true;
                    break;
                }
                ++n2;
            }
        }
        return isNotSupported;
    }

    private String readFile(String filePath) {
        String content;
        block9: {
            content = "";
            if (filePath != null && this.isNotSupportedPreviewFile(filePath)) {
                content = "A Preview of this file is not supported. In order to view this file, please select 'Open the file...'.";
                return content;
            }
            FileInputStream ips = null;
            InputStreamReader ipsr = null;
            BufferedReader br = null;
            try {
                ips = new FileInputStream(filePath);
                ipsr = new InputStreamReader(ips);
                br = new BufferedReader(ipsr);
                String line = null;
                boolean bFirst = true;
                while ((line = br.readLine()) != null) {
                    line = line.replaceAll("<", "&lt;");
                    line = line.replaceAll(">", "&gt;");
                    if (bFirst) {
                        content = line.trim().equals("") ? "<pre>" + line : "<pre>" + line + "<br>";
                        bFirst = false;
                        continue;
                    }
                    content = String.valueOf(content) + line + "<br>";
                }
                content = String.valueOf(content) + "</pre>";
            }
            catch (FileNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                break block9;
            }
            catch (IOException e) {
                try {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
                break block9;
            }
            IOUtil.tryClose((Object[])new Object[]{br, ipsr, ips});
        }
        return content;
    }
}

