/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.hover.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.BrowserWrapper;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.contentassist.WebResourceManager;
import org.tizen.web.editor.html.HTMLAdvancedFeatureConstants;
import org.tizen.web.editor.html.HTMLEditor;
import org.tizen.web.editor.html.hover.ui.CSSRuleInfo;
import org.tizen.web.editor.html.hover.ui.HTMLEditorBrowserInformationControlInput;
import org.tizen.web.editor.html.hover.ui.HTMLHoverInformationControlCreator;

public class HTMLHoverInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension4,
IInformationControlExtension5,
HTMLAdvancedFeatureConstants {
    protected static final Logger logger = LoggerFactory.getLogger(HTMLHoverInformationControl.class);
    protected final Shell fShell;
    protected final Composite fContentComposite;
    protected Point fSizeConstraints;
    protected Combo combo;
    protected BrowserWrapper browserWrapper;
    protected Composite linkComposite;
    protected GridData comboGridData;
    protected HTMLEditorBrowserInformationControlInput fInput;
    protected boolean fCompleted = false;
    protected BrowserFunction function;
    public static final int MIN_WIDTH = 400;
    public static final int MIN_HEIGHT = 250;
    protected int hoverWidth = 400;
    protected int hoverHeight = 250;
    private String excludedFolderFile = null;
    private boolean isSameFile = false;
    private Listener openLinkFileListener = new Listener(){

        public void handleEvent(Event event) {
            IWorkbenchPage page = SWTUtil.getActivePage();
            IFile linkedResource = HTMLHoverInformationControl.this.fInput.getLinkedResource();
            if (linkedResource != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)linkedResource);
                }
                catch (PartInitException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                int indexOf;
                String fileFullPath;
                HTMLEditorBrowserInformationControlInput.InputType inputType = HTMLHoverInformationControl.this.fInput.getInputType();
                if (inputType != null && inputType == HTMLEditorBrowserInformationControlInput.InputType.CSS && (fileFullPath = HTMLHoverInformationControl.this.combo.getText()) != null && (indexOf = fileFullPath.indexOf("(")) > 0) {
                    fileFullPath = fileFullPath.substring(indexOf + 1, fileFullPath.length() - 1);
                    File openFile = new File(fileFullPath);
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(openFile.toURI());
                    try {
                        IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        if (editorPart instanceof StructuredTextEditor) {
                            String selectorName;
                            int selectionIndex = HTMLHoverInformationControl.this.combo.getSelectionIndex();
                            CSSRuleInfo cssRuleInfo = HTMLHoverInformationControl.this.fInput.getfFoundCSSList().get(selectionIndex);
                            String cssRule = cssRuleInfo.getCssRule();
                            int indexOfSelector = cssRule.indexOf(selectorName = cssRuleInfo.getFindSelectorName());
                            if (indexOfSelector == -1) {
                                indexOfSelector = 0;
                            }
                            ((StructuredTextEditor)editorPart).setHighlightRange(cssRuleInfo.getOffset() + indexOfSelector, cssRuleInfo.getLength(), true);
                        }
                    }
                    catch (PartInitException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    };

    public HTMLHoverInformationControl(Shell shell) {
        this.fShell = new Shell(shell, 16404);
        Display display = this.fShell.getDisplay();
        Color foreground = display.getSystemColor(28);
        Color background = display.getSystemColor(29);
        this.setColor((Control)this.fShell, foreground, background);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.fShell.setLayout((Layout)layout);
        this.fContentComposite = new Composite((Composite)this.fShell, 0);
        this.fContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout fContentCompositeLayout = new GridLayout(1, false);
        fContentCompositeLayout.marginHeight = 0;
        fContentCompositeLayout.marginWidth = 0;
        fContentCompositeLayout.verticalSpacing = 0;
        this.fContentComposite.setLayout((Layout)fContentCompositeLayout);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HTMLHoverInformationControl.this.handleDispose();
            }
        });
        this.createContent(this.fContentComposite);
    }

    public static boolean isAvailable(Composite parent) {
        return true;
    }

    protected void createContent(Composite parent) {
        this.combo = new Combo(parent, 2060);
        this.comboGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.comboGridData.exclude = true;
        this.combo.setLayoutData((Object)this.comboGridData);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                String selectedText = combo.getText();
                int indexOf = selectedText.lastIndexOf("(");
                String dataKey = selectedText.substring(indexOf + 1, selectedText.length() - 1);
                CSSRuleInfo cssRuleInfo = (CSSRuleInfo)combo.getData(dataKey);
                String cssRule = cssRuleInfo.getCssRule();
                cssRule = "<pre>" + cssRule + "</pre>";
                cssRule = "<html><body bgcolor=\"FFFFE1\">${place-holder}</body></html>".replace("${place-holder}", cssRule);
                HTMLHoverInformationControl.this.browserWrapper.setText(cssRule);
            }
        });
        this.combo.setVisible(false);
        this.browserWrapper = new BrowserWrapper(this.createBrowser(parent));
        this.browserWrapper.getBrowser().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.browserWrapper.getBrowser().addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                if (HTMLHoverInformationControl.this.fInput != null) {
                    HTMLEditorBrowserInformationControlInput.InputType inputType = HTMLHoverInformationControl.this.fInput.getInputType();
                    int[] fitableHoverPopupSize = HTMLHoverInformationControl.this.getFitableHoverPopupSize(HTMLHoverInformationControl.this.fInput);
                    if (inputType != null) {
                        switch (inputType) {
                            case HTML: 
                            case CSS: 
                            case IMAGE: 
                            case JS: 
                            case NONE: {
                                if (fitableHoverPopupSize == null) {
                                    HTMLHoverInformationControl.this.hoverWidth = 400;
                                    HTMLHoverInformationControl.this.hoverHeight = 250;
                                    break;
                                }
                                HTMLHoverInformationControl.this.hoverWidth = fitableHoverPopupSize[0];
                                HTMLHoverInformationControl.this.hoverHeight = fitableHoverPopupSize[1];
                            }
                        }
                    } else {
                        HTMLHoverInformationControl.this.hoverWidth = 400;
                        HTMLHoverInformationControl.this.hoverHeight = 250;
                    }
                    HTMLHoverInformationControl.this.setSize(HTMLHoverInformationControl.this.hoverWidth, HTMLHoverInformationControl.this.hoverHeight);
                }
                HTMLHoverInformationControl.this.fCompleted = true;
            }
        });
        this.linkComposite = new Composite((Composite)this.fShell, 0);
        GridData linkCompositeGridData = new GridData(4, 1024, true, false);
        linkCompositeGridData.exclude = true;
        this.linkComposite.setLayoutData((Object)linkCompositeGridData);
        GridLayout linkCompositeLayout = new GridLayout(1, false);
        linkCompositeLayout.marginHeight = 0;
        linkCompositeLayout.marginWidth = 0;
        linkCompositeLayout.verticalSpacing = 1;
        this.linkComposite.setLayout((Layout)linkCompositeLayout);
        Link link = new Link(this.linkComposite, 16384);
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        link.setText("  <a>Open the file...</a>");
        link.addListener(13, this.openLinkFileListener);
        this.linkComposite.setVisible(false);
    }

    public int[] getFitableHoverPopupSize(HTMLEditorBrowserInformationControlInput fInput) {
        int[] popupSize = new int[2];
        HTMLEditor htmlEditor = (HTMLEditor)SWTUtil.getActiveEditor();
        StructuredTextViewer textViewer = htmlEditor.getTextViewer();
        StyledText textWidget = textViewer.getTextWidget();
        Font font = textWidget.getFont();
        FontData[] fontData = font.getFontData();
        int height = fontData[0].getHeight();
        String inputString = fInput.getHtml();
        HTMLEditorBrowserInformationControlInput.InputType inputType = fInput.getInputType();
        if (inputType == HTMLEditorBrowserInformationControlInput.InputType.IMAGE) {
            IDOMNode domNode = fInput.getDomNode();
            if (domNode instanceof ElementStyleImpl) {
                String imageHeight;
                int widthInt = 0;
                int heightInt = 0;
                String src = ((ElementStyleImpl)domNode).getAttribute("src");
                int lastIndexOf = src.lastIndexOf(46);
                String exension = src.substring(lastIndexOf + 1);
                IFileEditorInput editorInput = (IFileEditorInput)htmlEditor.getEditorInput();
                final IFile editorInputFile = editorInput.getFile();
                WebResourceManager resourceManager = new WebResourceManager(editorInputFile.getProject(), editorInputFile);
                resourceManager.makeProjectManagedResourceMap();
                this.excludedFolderFile = null;
                this.isSameFile = false;
                IFile file = resourceManager.getFile(src, exension);
                if (file == null) {
                    try {
                        final String findFilePath = src;
                        editorInputFile.getProject().accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                String resourcePath;
                                if (resource instanceof IFile && (resourcePath = resource.getFullPath().toString()).contains(findFilePath)) {
                                    HTMLHoverInformationControl.this.excludedFolderFile = resourcePath;
                                    HTMLHoverInformationControl.this.isSameFile = HTMLHoverInformationControl.this.isSameRelativePath(editorInputFile, (IFile)resource, findFilePath);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    if (this.excludedFolderFile == null || !this.isSameFile) {
                        return null;
                    }
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                String workspacePath = workspace.getRoot().getLocation().toString();
                String absolutePath = null;
                absolutePath = file != null ? String.valueOf(workspacePath) + file.getFullPath() : String.valueOf(workspacePath) + this.excludedFolderFile;
                Image image = new Image((Device)Display.getCurrent(), absolutePath);
                Rectangle bounds = image.getBounds();
                String imageWidth = ((ElementStyleImpl)domNode).getAttribute("width");
                if (imageWidth != null && !imageWidth.trim().equals("")) {
                    widthInt = this.extractFloatNumberAndCastingInt(imageWidth);
                }
                if ((imageHeight = ((ElementStyleImpl)domNode).getAttribute("height")) != null && !imageHeight.trim().equals("")) {
                    heightInt = this.extractFloatNumberAndCastingInt(imageHeight);
                }
                if (widthInt != 0 && heightInt != 0) {
                    popupSize[0] = widthInt;
                    popupSize[1] = heightInt;
                } else if (widthInt != 0 && heightInt == 0) {
                    popupSize[0] = widthInt;
                    popupSize[1] = widthInt * bounds.height / bounds.width;
                } else if (widthInt == 0 && heightInt != 0) {
                    popupSize[0] = heightInt * bounds.width / bounds.height;
                    popupSize[1] = heightInt;
                } else {
                    popupSize[0] = bounds.width;
                    popupSize[1] = bounds.height;
                }
                popupSize[0] = popupSize[0] + 55;
                popupSize[1] = popupSize[1] + 55;
            }
        } else {
            String[] split2;
            String[] split = inputString.split("<br>");
            boolean isCssSelector = false;
            if (split != null && split.length == 1 && (split2 = split[0].split("\n")) != null && split2.length > 1) {
                split = split2;
                isCssSelector = true;
            }
            int lineCount = 0;
            int maxWidthLineWidth = 0;
            int i = 0;
            while (i < split.length) {
                int width = split[i].length() * height;
                if (width > maxWidthLineWidth) {
                    maxWidthLineWidth = width;
                }
                ++lineCount;
                ++i;
            }
            popupSize[0] = maxWidthLineWidth;
            if (popupSize[0] < 300) {
                popupSize[0] = 300;
            } else if (popupSize[0] > 800) {
                popupSize[0] = 800;
            }
            popupSize[1] = lineCount * (2 * height - 2);
            if (isCssSelector) {
                popupSize[1] = popupSize[1] + 85;
            }
            if (popupSize[1] < 100) {
                popupSize[1] = 100;
            } else if (popupSize[1] > 600) {
                popupSize[1] = 600;
            }
        }
        return popupSize;
    }

    private boolean isSameRelativePath(IFile sourceFile, IFile targetFile, String compareTargetFilePath) {
        boolean isSame = false;
        String sourceFilePath = sourceFile.getFullPath().toString();
        sourceFilePath = sourceFilePath.substring(sourceFile.getProject().getName().length() + 2);
        String targetFilePath = targetFile.getFullPath().toString();
        targetFilePath = targetFilePath.substring(targetFile.getProject().getName().length() + 2);
        if ((targetFilePath = FilenameUtil.getRelativePath((String)sourceFilePath, (String)targetFilePath)).startsWith("../")) {
            targetFilePath = targetFilePath.substring(3);
        }
        if (targetFilePath.equals(compareTargetFilePath)) {
            isSame = true;
        }
        return isSame;
    }

    private int extractFloatNumberAndCastingInt(String numberString) {
        String number;
        int convertedValue = 0;
        StringBuffer sb = new StringBuffer();
        char[] charArray = numberString.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (!Character.isDigit(charArray[i]) && (i == 0 || charArray[i] != '.')) break;
            sb.append(charArray[i]);
            ++i;
        }
        if (!(number = sb.toString()).trim().equals("")) {
            convertedValue = (int)Float.parseFloat(number);
        }
        return convertedValue;
    }

    public Browser createBrowser(Composite parent) {
        Browser browser = new Browser(parent, 0);
        browser.setJavascriptEnabled(true);
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        browser.setMenu(new Menu((Decorations)parent.getShell(), 0));
        return browser;
    }

    public void setInput(Object input) {
        Assert.isLegal((input == null || input instanceof HTMLEditorBrowserInformationControlInput ? 1 : 0) != 0);
        if (input == null) {
            return;
        }
        this.fInput = (HTMLEditorBrowserInformationControlInput)input;
        this.fCompleted = false;
        if (this.fInput.getfFoundCSSList() != null && this.fInput.getfFoundCSSList().size() > 0) {
            this.makeComboItems(this.fInput.getfFoundCSSList());
            this.combo.select(0);
            this.comboGridData.exclude = false;
            this.combo.setVisible(true);
            if (this.fInput.getfFoundCSSList().size() == 1) {
                this.combo.setEnabled(false);
            } else {
                this.combo.setEnabled(true);
            }
            this.fContentComposite.layout(false);
        } else {
            this.combo.removeAll();
            this.comboGridData.exclude = true;
            this.combo.setVisible(false);
            this.fContentComposite.layout(false);
        }
        GridData gridData = (GridData)this.linkComposite.getLayoutData();
        if (this.fInput.getInputType() == null || this.fInput.getInputType() == HTMLEditorBrowserInformationControlInput.InputType.IMAGE || this.fInput.getInputType() == HTMLEditorBrowserInformationControlInput.InputType.NONE) {
            gridData.exclude = true;
            this.linkComposite.setVisible(false);
        } else {
            gridData.exclude = false;
            this.linkComposite.setVisible(true);
        }
        this.browserWrapper.setText("");
        String html = this.fInput.getHtml();
        html = "<html><body bgcolor=\"FFFFE1\">${place-holder}</body></html>".replace("${place-holder}", html);
        this.browserWrapper.setText(html);
    }

    private void makeComboItems(List<CSSRuleInfo> cssRuleInfos) {
        this.combo.removeAll();
        for (CSSRuleInfo cssRuleInfo : cssRuleInfos) {
            String selectorName = cssRuleInfo.getCssRuleInfo();
            String cssFilePath = cssRuleInfo.getCssFilePath();
            this.combo.add(String.valueOf(selectorName) + " (" + cssFilePath + ")");
            this.combo.setData(cssFilePath, (Object)cssRuleInfo);
        }
        this.combo.select(0);
    }

    public boolean hasContents() {
        return true;
    }

    protected final Shell getShell() {
        return this.fShell;
    }

    public void setSize(int width, int height) {
        this.browserWrapper.setRedraw(false);
        try {
            this.fShell.setSize(width, height);
        }
        finally {
            this.browserWrapper.setRedraw(true);
        }
    }

    public HTMLEditorBrowserInformationControlInput getInput() {
        return this.fInput;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new HTMLHoverInformationControlCreator();
    }

    public void setInformation(String information) {
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fSizeConstraints = new Point(maxWidth, maxHeight);
    }

    protected final Point getSizeConstraints() {
        if (this.fSizeConstraints != null) {
            return Geometry.copy((Point)this.fSizeConstraints);
        }
        return null;
    }

    protected void handleDispose() {
        this.browserWrapper.dispose();
    }

    public Point computeSizeHint() {
        Point constrains = this.getSizeConstraints();
        if (constrains == null) {
            return this.fShell.computeSize(-1, -1, true);
        }
        return this.fShell.computeSize(constrains.x, constrains.y, true);
    }

    public boolean isResizable() {
        return false;
    }

    public void setVisible(boolean visible) {
        Shell shell = this.getShell();
        if (shell.isVisible() == visible) {
            return;
        }
        if (!visible) {
            this.fShell.setVisible(false);
            this.setInput(null);
            return;
        }
        Display display = shell.getDisplay();
        display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                HTMLHoverInformationControl.this.fCompleted = true;
            }
        });
        while (!this.fCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if ("win32".equals(SWT.getPlatform())) {
            shell.moveAbove(null);
        }
        this.fShell.setVisible(true);
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fContentComposite.setForeground(foreground);
        this.browserWrapper.setBackground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fContentComposite.setBackground(background);
        this.browserWrapper.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public void setFocus() {
        boolean focusTaken = this.fShell.setFocus();
        if (!focusTaken) {
            this.fShell.forceFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        return null;
    }

    public void setStatusText(String statusFieldText) {
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public Rectangle computeTrim() {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        return trim;
    }

    public boolean restoresSize() {
        return false;
    }

    public boolean restoresLocation() {
        return false;
    }

    private void setColor(Control control, Color foreground, Color background) {
        control.setForeground(foreground);
        control.setBackground(background);
    }
}

