/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege;

import java.util.Collection;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.editor.configuration.Activator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class PrivilegeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String KNOWN_PRIVILEGE_ICON_PATH = "icons/known_feature.png";
    public static final String FOREIGN_PRIVILEGE_ICON_PATH = "icons/foreign_feature.png";
    private Image knownIcon;
    private Image foreignIcon;
    private Collection<PrivilegeWrapper> knownPrivileges;

    public PrivilegeLabelProvider(ITizenConfigurator config) {
        this.knownPrivileges = config.getKnownPrivileges();
        this.knownIcon = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)KNOWN_PRIVILEGE_ICON_PATH);
        this.foreignIcon = ImageUtil.getImage((Plugin)Activator.getDefault(), (String)FOREIGN_PRIVILEGE_ICON_PATH);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof PrivilegeWrapper) {
            PrivilegeWrapper privilege = (PrivilegeWrapper)element;
            if (this.knownPrivileges.contains(privilege)) {
                return this.knownIcon;
            }
            return this.foreignIcon;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof PrivilegeWrapper)) {
            return null;
        }
        PrivilegeWrapper privilege = (PrivilegeWrapper)element;
        switch (columnIndex) {
            case 0: {
                String name = privilege.getName();
                if (name != null) {
                    return name;
                }
                return "";
            }
        }
        return null;
    }

    public void dispose() {
        this.knownIcon.dispose();
        this.foreignIcon.dispose();
    }
}

