/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.IResource;
import org.tizen.web.builder.AbstractLintBuilder;
import org.tizen.web.privilege.core.PrivilegeChecker;

public class PrivilegeCheckBuilder
extends AbstractLintBuilder {
    private String errorLevel = "ERROR";
    private IProject project = null;
    protected PrivilegeChecker validator = null;
    public static final String JS = "js";

    public PrivilegeCheckBuilder(IProject project, IBuildListener buildListener) {
        super(JS, buildListener);
        this.project = project;
        this.validator = PrivilegeChecker.getInstance();
    }

    public void setCheckingErrorLevel(String level) {
        this.errorLevel = level;
    }

    public PrivilegeChecker getValidator() {
        return this.validator;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        this.logger.debug("PrivilegeCheckBuilder: " + resource.getName());
        BuildResult buildResult = new BuildResult(BuildResult.Status.UNKNOWN);
        buildResult.setResult(BuildResult.Status.SUCCESS);
        Collection buildErrInfos = this.validator.validate(this.project, resource, this.errorLevel);
        if (buildErrInfos == null) {
            return buildResult;
        }
        BuildResult.Status status = BuildResult.Status.ERROR;
        if (this.validator.getSeverity() == 1) {
            status = BuildResult.Status.WARNING;
        }
        buildResult.setResult(status);
        buildResult.getBuildErrorInfos().addAll(buildErrInfos);
        return buildResult;
    }
}

