/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ScreenDensity;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.Executor;
import org.tizen.common.daemon.ServerException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.packager.PackageResource;
import org.tizen.common.packager.core.PackageCommand;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.browser.Activator;
import org.tizen.web.browser.view.preview.PreviewServer;
import org.tizen.web.browser.view.preview.PreviewServerManager;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Account;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.BoxContent;
import org.tizen.web.config.schema.model.BoxIcon;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.TizenAccountIcon;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.core.exception.PackageException;
import org.tizen.web.packager.ui.Messages;
import org.tizen.web.packager.ui.ResourceManager;
import org.tizen.web.packager.ui.util.PackageUtil;

public class WebPackager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private IProgressMonitor monitor;
    private static String PLUGIN_ID = "org.tizen.web.packager";
    private static final String INTERNET_PRIVILEGE = "http://tizen.org/privilege/internet";
    private IDevice device;

    public IDevice getDevice() {
        return this.device;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public boolean createPackage(IProject project, PackageProcessType type) throws PackageException, CoreException, BuildException {
        boolean bl;
        this.handleCancel();
        FileOutputStream fos = null;
        try {
            String packagePath = org.tizen.web.common.util.PackageUtil.getPackagePath((IProject)project);
            if (FileUtil.isExist((String)packagePath)) {
                FileUtil.recursiveDelete((File)new File(packagePath));
                project.refreshLocal(2, null);
            }
            fos = new FileOutputStream(packagePath);
            bl = this.createPackage(project, fos, type);
            this.removeWidgetTempDirectory(project);
        }
        catch (FileNotFoundException e) {
            try {
                throw new PackageException((Exception)e, e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                this.removeWidgetTempDirectory(project);
                project.refreshLocal(2, null);
                IOUtil.tryClose((Object[])new Object[]{fos});
                throw throwable;
            }
        }
        project.refreshLocal(2, null);
        IOUtil.tryClose((Object[])new Object[]{fos});
        return bl;
    }

    private void removeWidgetTempDirectory(IProject project) {
        String tempDirectoryPath = project.getLocation() + "/" + "widgettempdir";
        if (FileUtil.isExist((String)tempDirectoryPath)) {
            FileUtil.recursiveDelete((String)tempDirectoryPath);
        }
    }

    private void handleCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            this.logger.debug("packaging was canceled.");
            throw new CancellationException();
        }
    }

    public boolean createPackage(IProject project, OutputStream os, PackageProcessType type) throws PackageException, CoreException, BuildException {
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, Messages.COULD_NOT_FIND_PROJECT));
        }
        List<TizenProjectDescription.RefTizenProject> migratingReferencedProjects = PackageUtil.getMigratingReferencedProjectsForWeb(project);
        if (!CollectionUtil.isEmpty(migratingReferencedProjects)) {
            PackageUtil.migrateReferencedProjects((IProject)project, migratingReferencedProjects);
        }
        this.logger.debug("create package: {}", (Object)project.getName());
        this.handleCancel();
        IProject companionWebProject = ProjectUtil.getCompanionWebProject((IProject)project);
        if (companionWebProject != null) {
            this.logger.debug("create companion application's package: {}", (Object)companionWebProject.getName());
            this.createPackage(companionWebProject, type);
        }
        this.handleCancel();
        UserLogger.start((String)"web.package", (String)".get.resources");
        Collection<IResource> resources = this.getPackagingResources(project, type);
        UserLogger.end((String)"web.package", (String)".get.resources");
        this.handleCancel();
        if (this.monitor != null) {
            this.monitor.subTask(NLS.bind((String)Messages.SUBTASK_ZIP_RESOURCES, (Object)PackageUtil.getPackagePath((IProject)project)));
        }
        boolean isSuccess = this.createPackage(resources, os, PackageUtil.getSignPath((IProject)project), ProjectUtil.getTizenProjectDescription((IProject)project).getPlatformName());
        return isSuccess;
    }

    public boolean createUnitTestPackage(IProject project, String testHtmlPath, byte[] newTestHtml) throws IOException, CoreException, PackageException {
        boolean bl;
        ResourceManager resourceMan = new ResourceManager(project);
        Collection<IResource> packagingResources = resourceMan.getPackagingResources(PackageProcessType.DEBUG);
        packagingResources.addAll(resourceMan.getUnitTestResources());
        IResource oldConfigResource = null;
        IResource oldTestHtmlResource = null;
        for (IResource resource : packagingResources) {
            if (oldConfigResource != null && oldTestHtmlResource != null) break;
            if (oldConfigResource == null && resource.getPath().equals("config.xml")) {
                oldConfigResource = resource;
            }
            if (oldTestHtmlResource != null || !FilenameUtil.equals((String)resource.getPath(), (String)testHtmlPath)) continue;
            oldTestHtmlResource = resource;
        }
        if (oldConfigResource == null || oldTestHtmlResource == null) {
            return false;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
            wgtConfig.setContent(testHtmlPath);
            ConfiguratorFactory.marshalObject((IProject)project, (Widget)wgtConfig.getWidget(), (OutputStream)byteOut);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        IResource newConfigResource = this.createVirtualResource("config.xml", byteOut.toByteArray());
        IResource newTestHtmlResource = this.createVirtualResource(testHtmlPath, newTestHtml);
        packagingResources.remove(oldConfigResource);
        packagingResources.add(newConfigResource);
        packagingResources.remove(oldTestHtmlResource);
        packagingResources.add(newTestHtmlResource);
        String packagePath = org.tizen.web.common.util.PackageUtil.getPackagePath((IProject)project);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(packagePath);
            bl = this.createPackage(packagingResources, fos, PackageUtil.getSignPath((IProject)project), ProjectUtil.getTizenProjectDescription((IProject)project).getPlatformName());
        }
        catch (Throwable throwable) {
            project.refreshLocal(1, null);
            IOUtil.tryClose((Object[])new Object[]{fos});
            throw throwable;
        }
        project.refreshLocal(1, null);
        IOUtil.tryClose((Object[])new Object[]{fos});
        return bl;
    }

    private Collection<IResource> getPackagingResources(IProject project, PackageProcessType type) throws CoreException, PackageException {
        this.logger.debug("Get packaging resources.");
        project.refreshLocal(2, null);
        ResourceManager rm = new ResourceManager(project);
        rm.setMonitor(this.monitor);
        Collection<IResource> resources = rm.getPackagingResources(type);
        return resources;
    }

    public boolean createLiveEditingPackage(IProject project, OutputStream os) throws ConfigurationException, CoreException, ServerException, IOException, PackageException, BuildException {
        this.logger.debug("create live editing package: {}", (Object)project.getName());
        HashSet<IResource> packagingResources = new HashSet<IResource>();
        String webRelativeDest = ".";
        if (ProjectUtil.isHybridApp((IProject)project)) {
            IProject[] nativeProjects;
            IProject[] iProjectArray = nativeProjects = ProjectUtil.getReferencedNativeProjects((IProject)project);
            int n = nativeProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject nativeProject = iProjectArray[n2];
                packagingResources.addAll(PackageUtil.getNativeResources(PackageProcessType.RUN, (ITizenNativeProject)ProjectUtil.getTizenProject((IProject)nativeProject), (FileHandler)new StandardFileHandler(nativeProject.getLocation().toOSString()), "/.sign*", "/manifest.xml"));
                ++n2;
            }
            webRelativeDest = FileUtil.appendPath((String)"res", (String)"wgt");
        }
        ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        ArrayList<String> tizenIconPathList = new ArrayList<String>();
        ArrayList<String> tizenBoxContentPathList = new ArrayList<String>();
        if (wgtConfig instanceof IMobileConfigurator) {
            List appWidgetList = ((IMobileConfigurator)wgtConfig).getDynamicBoxes();
            for (AppWidget wgt : appWidgetList) {
                List contents = wgt.getContent();
                Iterator iterator = contents.iterator();
                while (iterator.hasNext()) {
                    String path;
                    Object content = iterator.next();
                    if (content instanceof BoxIcon) {
                        path = ((BoxIcon)content).getSrc();
                        this.addToPackagingResources(wgtConfig, packagingResources, tizenIconPathList, project, path);
                        continue;
                    }
                    if (!(content instanceof BoxContent)) continue;
                    path = ((BoxContent)content).getSrc();
                    this.addToPackagingResources(wgtConfig, packagingResources, tizenBoxContentPathList, project, path);
                }
            }
            List accountList = ((IMobileConfigurator)wgtConfig).getAccounts();
            for (Account account : accountList) {
                List contents = account.getIconOrDisplayNameOrCapability();
                for (Object content : contents) {
                    if (!(content instanceof TizenAccountIcon)) continue;
                    String path = ((TizenAccountIcon)content).getContent();
                    this.addToPackagingResources(wgtConfig, packagingResources, tizenIconPathList, project, path);
                }
            }
        }
        IResource configResource = this.createLiveEditingConfig(project, wgtConfig, webRelativeDest);
        IResource iconResource = this.createLiveEditingIcon(project, wgtConfig, webRelativeDest);
        packagingResources.add(configResource);
        packagingResources.add(iconResource);
        IProject companionWearableWebProject = ProjectUtil.getCompanionWebProject((IProject)project);
        if (companionWearableWebProject != null) {
            this.createPackage(companionWearableWebProject, PackageProcessType.RUN);
            String cwd = companionWearableWebProject.getLocation().toOSString();
            String packageRelativePath = FilenameUtil.getRelativePath((String)cwd, (String)PackageUtil.getPackagePath((IProject)companionWearableWebProject));
            packagingResources.add((IResource)new PackageResource((FileHandler)new StandardFileHandler(cwd), packageRelativePath, FileUtil.appendPath((String)PackageUtil.getCompanionAppDestPath(), (String)packageRelativePath)));
        }
        return this.createPackage(packagingResources, os, PackageUtil.getSignPath((IProject)project), ProjectUtil.getTizenProjectDescription((IProject)project).getPlatformName());
    }

    private boolean isDuplicatedResource(ITizenConfigurator wgtConfig, List<String> pathList, String path) {
        String wgtIconPath = wgtConfig.getIconSrc();
        return path.equals(wgtIconPath) || pathList.contains(path);
    }

    private void addToPackagingResources(ITizenConfigurator wgtConfig, HashSet<IResource> packagingResources, List<String> pathList, IProject project, String path) {
        if (this.isDuplicatedResource(wgtConfig, pathList, path)) {
            return;
        }
        pathList.add(path);
        PackageResource resource = new PackageResource((FileHandler)new StandardFileHandler(project.getLocation().toOSString()), path, path);
        packagingResources.add((IResource)resource);
    }

    private boolean createPackage(Collection<IResource> resources, OutputStream os, String signPath, String platformName) {
        boolean needSign = true;
        if (signPath == null || signPath.isEmpty()) {
            needSign = false;
        }
        PackageCommand command = new PackageCommand(resources, os, needSign, signPath, platformName);
        command.setDevice(this.getDevice());
        Executor executor = CommonPlugin.getDefault().getExecutor();
        executor.execute(new Command[]{command});
        return (Boolean)command.getResult();
    }

    private IFile getIconFile(IProject project, ITizenConfigurator wgtConfig) {
        if (wgtConfig == null) {
            return null;
        }
        String iconSrc = wgtConfig.getIconSrc();
        IFile iconFile = null;
        iconFile = StringUtil.isEmpty((CharSequence)iconSrc) ? WebProjectUtil.findDefaultIconFile((IProject)project) : project.getFile(iconSrc);
        return iconFile;
    }

    private IResource createLiveEditingConfig(IProject project, ITizenConfigurator wgtConfig, String webRelativeDest) throws ConfigurationException, CoreException, ServerException, IOException {
        IResource iResource;
        ByteArrayOutputStream byteOut = null;
        try {
            String content = this.getIndexFile(wgtConfig, project);
            if (StringUtil.isEmpty((CharSequence)content)) {
                throw new ConfigurationException(Messages.LIVE_EDITING_INDEX_FILE_DOES_NOT_EXIST);
            }
            IFile indexFile = project.getFile(content);
            PreviewServerManager serverManager = Activator.getDefault().getServerManager();
            PreviewServer server = serverManager.getServer(indexFile.getProject());
            String url = server.getURL(indexFile);
            this.logger.debug("URL: {}", (Object)url);
            wgtConfig.setContent(url);
            wgtConfig.setAccess(server.getDomain(), DataBoolean.TRUE);
            this.setPrivilege(wgtConfig, INTERNET_PRIVILEGE);
            byteOut = new ByteArrayOutputStream();
            ConfiguratorFactory.marshalObject((IProject)project, (Widget)wgtConfig.getWidget(), (OutputStream)byteOut);
            iResource = this.createVirtualResource(FilenameUtil.addTailingPath((String)webRelativeDest, (String)"config.xml"), byteOut.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{byteOut});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{byteOut});
        return iResource;
    }

    private void setPrivilege(ITizenConfigurator wgtConfig, String name) {
        if (!this.isExistPrivilege(wgtConfig, name)) {
            Privilege privilege = new Privilege();
            privilege.setName(name);
            wgtConfig.addElement((Object)privilege);
        }
    }

    private boolean isExistPrivilege(ITizenConfigurator wgtConfig, String name) {
        for (Privilege pri : wgtConfig.getPrivileges()) {
            if (!name.equals(pri.getName())) continue;
            return true;
        }
        return false;
    }

    private IResource createVirtualResource(String fileName, byte[] byteArray) throws IOException {
        String path = fileName;
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        PackageResource resource = new PackageResource((FileHandler)new VirtualFileHandler(), path, path);
        resource.setContents(byteArray);
        return resource;
    }

    private IResource createLiveEditingIcon(IProject project, ITizenConfigurator wgtConfig, String webRelativeDest) throws IOException, CoreException {
        IResource iResource;
        IFile iconSrcFile = this.getIconFile(project, wgtConfig);
        if (iconSrcFile == null || !iconSrcFile.exists()) {
            return null;
        }
        FileInputStream srcInputStream = null;
        ByteArrayOutputStream baos = null;
        List srcImgs = null;
        ArrayList<BufferedImage> modifiedImgs = new ArrayList<BufferedImage>();
        String iconPath = iconSrcFile.getLocation().toOSString();
        String formatName = ImageUtil.getFormatName((String)iconPath);
        try {
            srcInputStream = new FileInputStream(iconPath);
            srcImgs = ImageUtil.getAWTImages((InputStream)srcInputStream, (String)iconPath);
            for (BufferedImage srcImg : srcImgs) {
                modifiedImgs.add(this.getLiveEditingBufferedImage(srcImg));
            }
            baos = new ByteArrayOutputStream();
            if ("ico".equalsIgnoreCase(formatName)) {
                ImageUtil.writeICO(modifiedImgs, (OutputStream)baos);
            } else {
                ImageUtil.write((BufferedImage)((BufferedImage)modifiedImgs.get(0)), (String)formatName, (OutputStream)baos);
            }
            iResource = this.createVirtualResource(FilenameUtil.addTailingPath((String)webRelativeDest, (String)iconSrcFile.getName()), baos.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{srcInputStream, baos});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{srcInputStream, baos});
        return iResource;
    }

    private BufferedImage getLiveEditingBufferedImage(BufferedImage srcImg) throws CoreException, IOException {
        InputStream decoInputStream;
        BufferedImage resultImg;
        block5: {
            resultImg = null;
            decoInputStream = null;
            try {
                if (srcImg != null) break block5;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{decoInputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{decoInputStream});
            return null;
        }
        decoInputStream = this.getClass().getResourceAsStream("/icons/live_editing.png");
        BufferedImage decoImage = ImageUtil.getBufferedImage((InputStream)decoInputStream);
        if (decoImage != null) {
            decoImage = this.scaleDecoImage(decoImage, srcImg);
            Point srcPoint = new Point(0, 0);
            Point decoPoint = new Point(srcImg.getWidth() - decoImage.getWidth(), srcImg.getHeight() - decoImage.getHeight());
            resultImg = ImageUtil.pileUp((BufferedImage)srcImg, (Point)srcPoint, (BufferedImage)decoImage, (Point)decoPoint, (int)srcImg.getWidth(), (int)srcImg.getHeight(), (int)srcImg.getType());
        } else {
            resultImg = srcImg;
        }
        IOUtil.tryClose((Object[])new Object[]{decoInputStream});
        return resultImg;
    }

    private BufferedImage scaleDecoImage(BufferedImage decoImg, BufferedImage srcImg) {
        float iconWidth = ScreenDensity.XHIGH.getIconSize();
        float iconHeight = ScreenDensity.XHIGH.getIconSize();
        float srcWidth = srcImg.getWidth();
        float srcHeight = srcImg.getHeight();
        float decoWidth = decoImg.getWidth();
        float decoHeight = decoImg.getHeight();
        float rate = 0.0f;
        rate = srcWidth < srcHeight ? srcWidth / iconWidth : srcHeight / iconHeight;
        decoImg = ImageUtil.getScaledImage((BufferedImage)decoImg, (int)((int)(decoWidth *= rate)), (int)((int)(decoHeight *= rate)), (int)decoImg.getType());
        return decoImg;
    }

    private String getIndexFile(ITizenConfigurator wgtConfig, IProject project) {
        String[] defaultStartFiles;
        String content = wgtConfig.getContentSrc();
        if (!StringUtil.isEmpty((CharSequence)content)) {
            return content;
        }
        String[] stringArray = defaultStartFiles = new String[]{"index.htm", "index.html", "index.svg", "index.xhtml", "index.xht"};
        int n = defaultStartFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultStartFile = stringArray[n2];
            if (WebProjectUtil.isFileInTheProject((IProject)project, (String)defaultStartFile)) {
                return defaultStartFile;
            }
            ++n2;
        }
        return null;
    }

    public boolean removePackage(IProject project) throws CoreException {
        String packagePath = org.tizen.web.common.util.PackageUtil.getPackagePath((IProject)project);
        if (FileUtil.isExist((String)packagePath)) {
            try {
                boolean bl = FileUtil.recursiveDelete((File)new File(packagePath));
                return bl;
            }
            finally {
                project.refreshLocal(1, null);
            }
        }
        return true;
    }

    public boolean createDebugPackage(IProject project) throws CoreException, PackageException, FileNotFoundException, BuildException {
        boolean bl;
        FileOutputStream fos = null;
        try {
            String packagePath = org.tizen.web.common.util.PackageUtil.getPackagePath((IProject)project);
            fos = new FileOutputStream(packagePath);
            bl = this.createPackage(project, fos, PackageProcessType.DEBUG);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{fos});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{fos});
        return bl;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

