/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jshint.prefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.tizen.common.util.WorkspaceUtil;
import org.tizen.web.common.build.CleanJob;
import org.tizen.web.common.build.PropertyChangeCleanListener;
import org.tizen.web.jshint.Activator;
import org.tizen.web.jshint.PreferenceConstants;
import org.tizen.web.jshint.engine.Option;
import org.tizen.web.jshint.prefs.Messages;

public class JsHintPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor buildField;
    private BooleanFieldEditor reconcileField;
    private ComboFieldEditor levelField;
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private final List<Option> booleanOptions = this.booleanOptions();
    private PropertyChangeCleanListener changeListener = new PropertyChangeCleanListener();

    private List<Option> booleanOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            if (o.getType() == Boolean.class) {
                options.add(o);
            }
            ++n2;
        }
        return options;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = 1;
        result.setLayout((Layout)layout);
        Group validationGroup = new Group(result, 0);
        validationGroup.setText(Messages.JsHintPreferencePage_GroupLabel);
        GridLayout validationGroupLayout = new GridLayout();
        GridData validationGroupLayoutData = new GridData(1808);
        validationGroup.setLayout((Layout)validationGroupLayout);
        validationGroup.setLayoutData((Object)validationGroupLayoutData);
        Label lblInfo = new Label((Composite)validationGroup, 16384);
        lblInfo.setText(Messages.JsHintPreferencePage_GroupDescription);
        lblInfo.setLayoutData((Object)new GridData());
        Group validatorGroup = new Group((Composite)validationGroup, 0);
        validatorGroup.setText(Messages.JsHintPreferencePage_JsHintValidatorLabel);
        GridLayout validatorGroupLayout = new GridLayout();
        GridData validatorGroupLayoutGridData = new GridData(1808);
        validatorGroup.setLayout((Layout)validatorGroupLayout);
        validatorGroup.setLayoutData((Object)validatorGroupLayoutGridData);
        Composite validatorGroupInner = new Composite((Composite)validatorGroup, 0);
        validatorGroupInner.setLayoutData((Object)new GridData());
        this.buildField = new BooleanFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.build", Messages.JsHintPreferencePage_BuildLabel, validatorGroupInner);
        this.reconcileField = new BooleanFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.reconcile", Messages.JsHintPreferencePage_ReconcileLabel, validatorGroupInner);
        this.levelField = new ComboFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.level", Messages.JsHintPreferencePage_LevelLabel, PreferenceConstants.LEVEL_LISTS, validatorGroupInner);
        Composite commonComposite = this.createStyleTabContent((Composite)validatorGroup);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create();
        commonComposite.setLayoutData((Object)gridData);
        this.setPreferenceStore();
        this.loadPreference();
        this.buildField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        this.reconcileField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        this.levelField.setPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        return result;
    }

    private Composite createStyleTabContent(Composite folder) {
        ScrolledPageContent sc = new ScrolledPageContent(folder);
        int nColumns = 1;
        Composite composite = sc.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        ExpandableComposite optionsExcomposite = this.createStyleSection(composite, Messages.JsHintPreferencePage_OptionsComposite, nColumns);
        Composite optionComposite = new Composite((Composite)optionsExcomposite, 0);
        optionComposite.setLayout((Layout)new GridLayout(nColumns, false));
        optionsExcomposite.setClient((Control)optionComposite);
        for (Option o : this.booleanOptions) {
            this.addFieldEditor((FieldEditor)new BooleanFieldEditor(o.getLowerName(), o.getDescription(), optionComposite));
        }
        ExpandableComposite propertiesExcomposite = this.createStyleSection(composite, Messages.JsHintPreferencePage_PROPERTIESComposite, nColumns);
        Composite propertiesInner = new Composite((Composite)propertiesExcomposite, 0);
        propertiesInner.setLayout((Layout)new GridLayout(nColumns, false));
        propertiesExcomposite.setClient((Control)propertiesInner);
        this.addFieldEditor((FieldEditor)new IntegerFieldEditor(Option.ESVERSION.getLowerName(), Option.ESVERSION.getDescription(), propertiesInner));
        this.addFieldEditor((FieldEditor)new IntegerFieldEditor(Option.MAXERR.getLowerName(), Option.MAXERR.getDescription(), propertiesInner));
        this.addFieldEditor((FieldEditor)new IntegerFieldEditor(Option.MAXPARAMS.getLowerName(), Option.MAXPARAMS.getDescription(), propertiesInner));
        this.addFieldEditor((FieldEditor)new StringFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.predef", Messages.JsHintPreferencePage_PredefinedGlobalVarableLabel, 30, propertiesInner));
        this.addFieldEditor((FieldEditor)new StringFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.exclude", Messages.JsHintPreferencePage_ExcludeFileLabel, 30, propertiesInner));
        this.addFieldEditor((FieldEditor)new StringFieldEditor("org.tizen.web.jshint.preference.JsValidationPreferencePage.excludeFolder", Messages.JsHintPreferencePage_ExcludeFolderLabel, 30, propertiesInner));
        return sc;
    }

    private void addFieldEditor(FieldEditor fieldEditor) {
        fieldEditor.setPage((DialogPage)this);
        this.fieldEditors.add(fieldEditor);
    }

    private ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setLayoutData((Object)new GridData());
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                JsHintPreferencePage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    public boolean performOk() {
        if (this.changeListener.needToClean()) {
            CleanJob cleanJob = new CleanJob();
            cleanJob.run(WorkspaceUtil.getTizenWebProjects());
        }
        this.storePreference();
        return super.performOk();
    }

    protected void performDefaults() {
        this.loadDefaultPreference();
        super.performDefaults();
    }

    private void setPreferenceStore() {
        IPreferenceStore ps = this.getPreferenceStore();
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.setPreferenceStore(ps);
        }
        this.buildField.setPreferenceStore(ps);
        this.reconcileField.setPreferenceStore(ps);
        this.levelField.setPreferenceStore(ps);
    }

    private void loadPreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.load();
        }
        this.buildField.load();
        this.reconcileField.load();
        this.levelField.load();
    }

    private void storePreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.store();
        }
        this.buildField.store();
        this.reconcileField.store();
        this.levelField.store();
    }

    private void loadDefaultPreference() {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.loadDefault();
        }
        this.buildField.loadDefault();
        this.reconcileField.loadDefault();
        this.levelField.loadDefault();
    }
}

