/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.serviceprofile.wizard;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.config.schema.model.Metadata;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.serviceprofile.wizard.NewServiceProfileXMLFilePage;

public class ServiceProfileXMLFileWizard
extends Wizard
implements INewWizard {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected NewServiceProfileXMLFilePage newXMLFilePage;
    public static final String SERVICEPROFILE_WIZARD_TITLE = "New XML File - ServiceProfile";
    public static final String SERVICEPROFILE_KEY = "AccessoryServicesLocation";

    public ServiceProfileXMLFileWizard() {
        this.setWindowTitle(SERVICEPROFILE_WIZARD_TITLE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.newXMLFilePage = new NewServiceProfileXMLFilePage(SERVICEPROFILE_WIZARD_TITLE, this.selection);
        this.newXMLFilePage.setTitle(SERVICEPROFILE_WIZARD_TITLE);
        this.newXMLFilePage.setDescription(SERVICEPROFILE_WIZARD_TITLE);
        this.newXMLFilePage.setFileExtension("xml");
        super.addPage((IWizardPage)this.newXMLFilePage);
    }

    public boolean performFinish() {
        IFile file = this.newXMLFilePage.createNewFile();
        if (file != null) {
            try {
                IWorkbenchPage page;
                ITizenConfigurator configurator;
                if (!this.updateConfigurationEditor(file) && (configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)file.getProject())) instanceof IMobileConfigurator) {
                    IMobileConfigurator mConfig = (IMobileConfigurator)configurator;
                    boolean bModified = false;
                    for (Metadata data : mConfig.getMetadatas()) {
                        if (!data.getKey().equalsIgnoreCase(SERVICEPROFILE_KEY)) continue;
                        data.setValue(file.getProjectRelativePath().toString());
                        bModified = true;
                    }
                    if (!bModified) {
                        Metadata newMetadata = new Metadata();
                        newMetadata.setKey(SERVICEPROFILE_KEY);
                        newMetadata.setValue(file.getProjectRelativePath().toString());
                        mConfig.addElement((Object)newMetadata);
                    }
                    mConfig.doSave();
                }
                if ((page = SWTUtil.getActivePage()) != null) {
                    page.openEditor((IEditorInput)new FileEditorInput(file), "org.tizen.web.editor.configuration.serviceprofile.editor.xmleditor");
                }
            }
            catch (PartInitException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (ConfigurationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    protected boolean updateConfigurationEditor(IFile file) throws IOException, ConfigurationException {
        IEditorReference[] editorReferences = SWTUtil.getEditorReferences();
        if (editorReferences == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            if (editorRef.getId().equalsIgnoreCase("org.tizen.web.editor.configuration.ConfigurationEditor")) {
                ConfigurationEditor configEditor = (ConfigurationEditor)editorRef.getEditor(true);
                if (configEditor.getConfig() == null) {
                    configEditor.refresh(true);
                }
                if (file.getProject() == configEditor.getProject()) {
                    ITizenConfigurator configurator = configEditor.getConfig();
                    if (configurator instanceof IMobileConfigurator) {
                        IMobileConfigurator mConfig = (IMobileConfigurator)configurator;
                        boolean bModified = false;
                        for (Metadata data : mConfig.getMetadatas()) {
                            if (!data.getKey().equalsIgnoreCase(SERVICEPROFILE_KEY)) continue;
                            data.setValue(file.getProjectRelativePath().toString());
                            bModified = true;
                        }
                        if (!bModified) {
                            Metadata newMetadata = new Metadata();
                            newMetadata.setKey(SERVICEPROFILE_KEY);
                            newMetadata.setValue(file.getProjectRelativePath().toString());
                            mConfig.addElement((Object)newMetadata);
                        }
                        mConfig.doSave();
                        configEditor.reloadPage(configEditor.tizenPageIndex);
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

