/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.privilege.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.tizen.web.privilege.core.Api;
import org.tizen.web.privilege.core.Argument;
import org.tizen.web.privilege.core.Module;

public class Modules
extends HashMap<String, Module> {
    private static final long serialVersionUID = -4977045137558039674L;

    public void add(Element privilegeDomElement) {
        Api api;
        String privilegeName = privilegeDomElement.getTextTrim();
        Element operation = privilegeDomElement.getParent().getParent();
        String className = operation.attributeValue("id").split("::")[2];
        String apiName = operation.attributeValue("name");
        Module module = this.getModule(className);
        if (module == null) {
            module = new Module(className);
            this.put(module.getClassName(), module);
        }
        if ((api = module.getApi(apiName)) == null) {
            api = new Api(apiName, privilegeName);
            module.add(api);
        }
        api.setPrivilege(privilegeName);
    }

    private Element getRecursiveOperation(Element element) {
        if (element.getParent() == null) {
            return null;
        }
        if (element.getParent().getQName().getName().equals("Operation")) {
            return element.getParent();
        }
        return this.getRecursiveOperation(element.getParent());
    }

    public void addArgumentPrivilege(Element argumentPrivilege, int argumentIndex) {
        Argument argument;
        Api api;
        Element argumentElement = argumentPrivilege.getParent();
        String argumentName = argumentElement.attributeValue("name");
        String privilegeUrl = argumentPrivilege.getTextTrim();
        String[] privilegeProperties = argumentPrivilege.attributeValue("properties").split("\\s*,\\s*");
        List<String> propertiesList = Arrays.asList(privilegeProperties);
        Element operation = this.getRecursiveOperation(argumentPrivilege);
        if (operation == null) {
            return;
        }
        String className = operation.attributeValue("id").split("::")[2];
        String apiName = operation.attributeValue("name");
        Module module = this.getModule(className);
        if (module == null) {
            module = new Module(className);
            this.put(module.getClassName(), module);
        }
        if ((api = module.getApi(apiName)) == null) {
            api = new Api(apiName);
            module.add(api);
        }
        if ((argument = api.getArgument(argumentName)) == null) {
            argument = new Argument(argumentName, argumentIndex, privilegeUrl, propertiesList);
            api.addArgument(argument);
        }
    }

    public Module getModule(String className) {
        return (Module)this.get(className);
    }
}

