/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.web.project.wizard.extension.ITemplateContributor;
import org.tizen.web.project.wizard.extension.ITemplateOptionControl;

public class ExtensionTemplate {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String TYPE_ATTRIBUTE = "type";
    private final String PERSPECTIVE_ATTRIBUTE = "finalPerspective";
    private final String CONTRIBUTE_ELEMENT = "contributeTemplate";
    private final String EXECUTION_ATTRIBUTE = "class";
    private final String FILTER_ELEMENT = "buildResourceFilter";
    private final String FILTER_ATTRIBUTE = "pattern";
    private final String CONTROL_ELEMENT = "optionControl";
    private IConfigurationElement configuraionElement;

    public ExtensionTemplate(IConfigurationElement configuraionElement) {
        Assert.notNull((Object)configuraionElement);
        this.configuraionElement = configuraionElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configuraionElement;
    }

    protected IConfigurationElement[] getChildElement(String elementName) {
        return this.getConfigurationElement().getChildren(elementName);
    }

    public String getPluginID() {
        return this.getConfigurationElement().getContributor().getName();
    }

    public ITemplateContributor getInterface(String templateType) {
        Assert.notNull((Object)templateType);
        IConfigurationElement[] iConfigurationElementArray = this.getChildElement("contributeTemplate");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj;
                String type = element.getAttribute("type");
                if (type != null && type.equalsIgnoreCase(templateType) && (obj = element.createExecutableExtension("class")) instanceof ITemplateContributor) {
                    return (ITemplateContributor)obj;
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return null;
    }

    public String getFinalPerspective(String templateType) {
        Assert.notNull((Object)templateType);
        IConfigurationElement[] iConfigurationElementArray = this.getChildElement("contributeTemplate");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String type = element.getAttribute("type");
            if (type != null && type.equalsIgnoreCase(templateType)) {
                return element.getAttribute("finalPerspective");
            }
            ++n2;
        }
        return null;
    }

    public String getFilterPattern() {
        IConfigurationElement[] iConfigurationElementArray = this.getChildElement("buildResourceFilter");
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement element = iConfigurationElementArray[0];
            return element.getAttribute("pattern");
        }
        return null;
    }

    public ITemplateOptionControl[] getOptionControls() {
        ArrayList<ITemplateOptionControl> list = new ArrayList<ITemplateOptionControl>();
        IConfigurationElement[] iConfigurationElementArray = this.getChildElement("optionControl");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj = element.createExecutableExtension("class");
                if (obj instanceof ITemplateOptionControl) {
                    list.add((ITemplateOptionControl)obj);
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return list.toArray(new ITemplateOptionControl[0]);
    }
}

