/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.platform;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;
import org.tizen.web.editor.widl.util.PrivilegeUtil;

public class TizenWIDLPrivilegeReader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TIZEN_WIDLPROCXML_FILE_PATH = String.valueOf(File.separator) + "widlprocxmls" + File.separator + "tizen.widlprocxml";
    private static Collection<PrivilegeWrapper> privileges;

    public Collection<PrivilegeWrapper> getTizenWIDLPrivileges() {
        return privileges;
    }

    public TizenWIDLPrivilegeReader(IProject project) {
        privileges = new LinkedList<PrivilegeWrapper>();
        Collection<Document> widlDocs = PrivilegeUtil.getWidlProcXmls(project);
        for (Document widlDoc : widlDocs) {
            Collection<PrivilegeWrapper> widlPrivileges = null;
            if (widlDoc == null || (widlPrivileges = this.readPrivileges(widlDoc)) == null) continue;
            privileges.addAll(widlPrivileges);
        }
    }

    protected Collection<PrivilegeWrapper> readPrivileges(Document doc) {
        LinkedList<PrivilegeWrapper> privilegeWrappers = new LinkedList<PrivilegeWrapper>();
        Element root = doc.getRootElement();
        List moduleElements = root.elements("Module");
        for (Element moduleElement : moduleElements) {
            Iterator interaces = moduleElement.elementIterator("Interface");
            while (interaces.hasNext()) {
                Element interfaceElement = (Element)interaces.next();
                Iterator operations = interfaceElement.elementIterator("Operation");
                while (operations.hasNext()) {
                    Element operationElement = (Element)operations.next();
                    Iterator desciptives = operationElement.elementIterator("descriptive");
                    while (desciptives.hasNext()) {
                        Element descriptiveElement = (Element)desciptives.next();
                        PrivilegeWrapper privilege = null;
                        List privilegeElements = descriptiveElement.elements("privilege");
                        for (Element privilegeElement : privilegeElements) {
                            String privilegeName = privilegeElement.getTextTrim();
                            if (StringUtil.isEmpty((CharSequence)privilegeName) || privilegeWrappers.contains(privilege = new PrivilegeWrapper(privilegeName))) continue;
                            privilegeWrappers.add(privilege);
                        }
                        List privilegeLevelElements = descriptiveElement.elements("privilegelevel");
                        for (Element privilegeLevelElement : privilegeLevelElements) {
                            String privilegeLevel = privilegeLevelElement.getTextTrim();
                            if (privilege == null || StringUtil.isEmpty((CharSequence)privilegeLevel)) continue;
                            privilege.setPrivilgeLevel(privilegeLevel);
                        }
                    }
                }
                Iterator attributes = interfaceElement.elementIterator("Attribute");
                while (attributes.hasNext()) {
                    Element operationElement = (Element)attributes.next();
                    Iterator desciptives = operationElement.elementIterator("descriptive");
                    while (desciptives.hasNext()) {
                        Element descriptiveElement = (Element)desciptives.next();
                        PrivilegeWrapper privilege = null;
                        List privilegeElements = descriptiveElement.elements("privilege");
                        for (Element privilegeElement : privilegeElements) {
                            String privilegeName = privilegeElement.getTextTrim();
                            if (StringUtil.isEmpty((CharSequence)privilegeName) || privilegeWrappers.contains(privilege = new PrivilegeWrapper(privilegeName))) continue;
                            privilegeWrappers.add(privilege);
                        }
                        List privilegeLevelElements = descriptiveElement.elements("privilegelevel");
                        for (Element privilegeLevelElement : privilegeLevelElements) {
                            String privilegeLevel = privilegeLevelElement.getTextTrim();
                            if (privilege == null || StringUtil.isEmpty((CharSequence)privilegeLevel)) continue;
                            privilege.setPrivilgeLevel(privilegeLevel);
                        }
                    }
                }
            }
        }
        return privilegeWrappers;
    }
}

